/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.ResultSetUtility;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class UnreliableMetaDataTest {
    private BufferAllocator allocator;

    @BeforeEach
    public void beforeEach() {
        this.allocator = new RootAllocator();
    }

    @AfterEach
    public void afterEach() {
        this.allocator.close();
    }

    public static Stream<Arguments> getTestData() {
        return Arrays.stream(new Object[][]{{false}, {true}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testUnreliableMetaDataPrecisionAndScale(boolean reuseVectorSchemaRoot) throws Exception {
        ResultSet rs = this.buildIncorrectPrecisionAndScaleMetaDataResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        Assertions.assertEquals((int)3, (int)rsmd.getColumnType(1), (String)"Column type should be Types.DECIMAL");
        Assertions.assertEquals((int)0, (int)rsmd.getScale(1), (String)"Column scale should be zero");
        Assertions.assertEquals((int)0, (int)rsmd.getPrecision(1), (String)"Column precision should be zero");
        rs.next();
        BigDecimal bd1 = rs.getBigDecimal(1);
        Assertions.assertEquals((Object)new BigDecimal("1000000000000000.01"), (Object)bd1, (String)"Value should be 1000000000000000.01");
        Assertions.assertEquals((int)2, (int)bd1.scale(), (String)"Value scale should be 2");
        Assertions.assertEquals((int)18, (int)bd1.precision(), (String)"Value precision should be 18");
        Assertions.assertFalse((boolean)rs.next(), (String)"No more rows!");
        rs.beforeFirst();
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertThrows(RuntimeException.class, () -> ((ArrowVectorIterator)iter).next(), (String)"Expected to fail due to mismatched metadata!");
        }
        rs.beforeFirst();
        JdbcFieldInfo explicitMappingField = new JdbcFieldInfo(3, 18, 2);
        HashMap<Integer, JdbcFieldInfo> explicitMapping = new HashMap<Integer, JdbcFieldInfo>();
        explicitMapping.put(1, explicitMappingField);
        config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(explicitMapping).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            while (iter.hasNext()) {
                VectorSchemaRoot root = iter.next();
                root.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testInconsistentPrecisionAndScale(boolean reuseVectorSchemaRoot) throws Exception {
        ResultSet rs = this.buildVaryingPrecisionAndScaleResultSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        Assertions.assertEquals((int)3, (int)rsmd.getColumnType(1), (String)"Column type should be Types.DECIMAL");
        Assertions.assertEquals((int)0, (int)rsmd.getScale(1), (String)"Column scale should be zero");
        Assertions.assertEquals((int)0, (int)rsmd.getPrecision(1), (String)"Column precision should be zero");
        rs.next();
        BigDecimal bd1 = rs.getBigDecimal(1);
        Assertions.assertEquals((Object)new BigDecimal("1000000000000000.01"), (Object)bd1, (String)"Value should be 1000000000000000.01");
        Assertions.assertEquals((int)2, (int)bd1.scale(), (String)"Value scale should be 2");
        Assertions.assertEquals((int)18, (int)bd1.precision(), (String)"Value precision should be 18");
        rs.next();
        BigDecimal bd2 = rs.getBigDecimal(1);
        Assertions.assertEquals((Object)new BigDecimal("1000000000300.0000001"), (Object)bd2, (String)"Value should be 1000000000300.0000001");
        Assertions.assertEquals((int)7, (int)bd2.scale(), (String)"Value scale should be 7");
        Assertions.assertEquals((int)20, (int)bd2.precision(), (String)"Value precision should be 20");
        rs.beforeFirst();
        JdbcFieldInfo explicitMappingField = new JdbcFieldInfo(3, 20, 7);
        HashMap<Integer, JdbcFieldInfo> explicitMapping = new HashMap<Integer, JdbcFieldInfo>();
        explicitMapping.put(1, explicitMappingField);
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(explicitMapping).build();
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertThrows(RuntimeException.class, () -> ((ArrowVectorIterator)iter).next(), (String)"This is expected to fail due to inconsistent BigDecimal scales, while strict matching is enabled.");
        }
        config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(explicitMapping).setBigDecimalRoundingMode(RoundingMode.UNNECESSARY).build();
        iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);
        try {
            while (iter.hasNext()) {
                VectorSchemaRoot root = iter.next();
                root.close();
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getTestData"})
    public void testIncorrectNullability(boolean reuseVectorSchemaRoot) throws Exception {
        ResultSetUtility.MockResultSetMetaData.MockColumnMetaData columnMetaData = ResultSetUtility.MockResultSetMetaData.MockColumnMetaData.builder().sqlType(4).nullable(0).build();
        ResultSetUtility.MockResultSetMetaData metadata = new ResultSetUtility.MockResultSetMetaData(Collections.singletonList(columnMetaData));
        ResultSetUtility.MockResultSet.Builder resultSetBuilder = ResultSetUtility.MockResultSet.builder().setMetaData(metadata).addDataElement(new ResultSetUtility.MockDataElement(1024, 4)).finishRow().addDataElement(new ResultSetUtility.MockDataElement(null, 4)).finishRow();
        Schema notNullSchema = new Schema(Collections.singletonList(Field.notNullable(null, (ArrowType)new ArrowType.Int(32, true))));
        Schema nullSchema = new Schema(Collections.singletonList(Field.nullable(null, (ArrowType)new ArrowType.Int(32, true))));
        try (ResultSetUtility.MockResultSet rs = resultSetBuilder.build();){
            IntVector ints;
            VectorSchemaRoot root;
            JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).build();
            try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
                Assertions.assertTrue((boolean)iter.hasNext());
                VectorSchemaRoot root2 = iter.next();
                Assertions.assertEquals((Object)notNullSchema, (Object)root2.getSchema());
                Assertions.assertEquals((int)2, (int)root2.getRowCount());
                IntVector ints2 = (IntVector)root2.getVector(0);
                Assertions.assertEquals((int)1024, (int)ints2.get(0));
                Assertions.assertFalse((boolean)ints2.isNull(1));
                Assertions.assertFalse((boolean)iter.hasNext());
                root2.close();
            }
            rs.beforeFirst();
            HashMap<Integer, JdbcFieldInfo> typeMapping = new HashMap<Integer, JdbcFieldInfo>();
            JdbcFieldInfo realFieldInfo = new JdbcFieldInfo(4, 1, 0, 0);
            typeMapping.put(1, realFieldInfo);
            config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(typeMapping).build();
            try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);){
                Assertions.assertTrue((boolean)iter.hasNext());
                root = iter.next();
                Assertions.assertEquals((Object)nullSchema, (Object)root.getSchema());
                Assertions.assertEquals((int)2, (int)root.getRowCount());
                ints = (IntVector)root.getVector(0);
                Assertions.assertEquals((int)1024, (int)ints.get(0));
                Assertions.assertTrue((boolean)ints.isNull(1));
                Assertions.assertFalse((boolean)iter.hasNext());
                root.close();
            }
            rs.beforeFirst();
            realFieldInfo = new JdbcFieldInfo(4, 2, 0, 0);
            typeMapping.put(1, realFieldInfo);
            config = new JdbcToArrowConfigBuilder(this.allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).setExplicitTypesByColumnIndex(typeMapping).build();
            iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);
            try {
                Assertions.assertTrue((boolean)iter.hasNext());
                root = iter.next();
                Assertions.assertEquals((Object)notNullSchema, (Object)root.getSchema());
                Assertions.assertEquals((int)2, (int)root.getRowCount());
                ints = (IntVector)root.getVector(0);
                Assertions.assertEquals((int)1024, (int)ints.get(0));
                Assertions.assertFalse((boolean)ints.isNull(1));
                Assertions.assertFalse((boolean)iter.hasNext());
                root.close();
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
    }

    private ResultSet buildIncorrectPrecisionAndScaleMetaDataResultSet() throws SQLException {
        ResultSetUtility.MockResultSetMetaData.MockColumnMetaData columnMetaData = ResultSetUtility.MockResultSetMetaData.MockColumnMetaData.builder().sqlType(3).precision(0).scale(0).build();
        ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData> cols = new ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData>();
        cols.add(columnMetaData);
        ResultSetUtility.MockResultSetMetaData metadata = new ResultSetUtility.MockResultSetMetaData(cols);
        return ResultSetUtility.MockResultSet.builder().setMetaData(metadata).addDataElement(new ResultSetUtility.MockDataElement(new BigDecimal("1000000000000000.01"), 3)).finishRow().build();
    }

    private ResultSet buildVaryingPrecisionAndScaleResultSet() throws SQLException {
        ResultSetUtility.MockResultSetMetaData.MockColumnMetaData columnMetaData = ResultSetUtility.MockResultSetMetaData.MockColumnMetaData.builder().sqlType(3).precision(0).scale(0).build();
        ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData> cols = new ArrayList<ResultSetUtility.MockResultSetMetaData.MockColumnMetaData>();
        cols.add(columnMetaData);
        ResultSetUtility.MockResultSetMetaData metadata = new ResultSetUtility.MockResultSetMetaData(cols);
        return ResultSetUtility.MockResultSet.builder().setMetaData(metadata).addDataElement(new ResultSetUtility.MockDataElement(new BigDecimal("1000000000000000.01"), 3)).finishRow().addDataElement(new ResultSetUtility.MockDataElement(new BigDecimal("1000000000300.0000001"), 3)).finishRow().build();
    }
}

