/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.arrow.adapter.jdbc.JdbcToArrowTestHelper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Table {
    private String name;
    private String type;
    private String vector;
    private String timezone;
    private String create;
    private String[] data;
    private String query;
    private String drop;
    private String[] values;
    private String[] vectors;
    private int rowCount;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVector() {
        return this.vector;
    }

    public void setVector(String vector) {
        this.vector = vector;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public Long[] getLongValues() {
        Long[] arr = new Long[this.values.length];
        int i = 0;
        for (String str : this.values) {
            arr[i++] = Long.parseLong(str);
        }
        return arr;
    }

    public Integer[] getIntValues() {
        Integer[] arr = new Integer[this.values.length];
        int i = 0;
        for (String str : this.values) {
            arr[i++] = Integer.parseInt(str);
        }
        return arr;
    }

    public Boolean[] getBoolValues() {
        Boolean[] arr = new Boolean[this.values.length];
        int i = 0;
        for (String str : this.values) {
            arr[i++] = Boolean.parseBoolean(str);
        }
        return arr;
    }

    public BigDecimal[] getBigDecimalValues() {
        BigDecimal[] arr = new BigDecimal[this.values.length];
        int i = 0;
        for (String str : this.values) {
            arr[i++] = new BigDecimal(str);
        }
        return arr;
    }

    public Double[] getDoubleValues() {
        Double[] arr = new Double[this.values.length];
        int i = 0;
        for (String str : this.values) {
            arr[i++] = Double.parseDouble(str);
        }
        return arr;
    }

    public Float[] getFloatValues() {
        Float[] arr = new Float[this.values.length];
        int i = 0;
        for (String str : this.values) {
            arr[i++] = Float.valueOf(Float.parseFloat(str));
        }
        return arr;
    }

    public byte[][] getBinaryValues() {
        return Table.getByteArray(this.values);
    }

    public byte[][] getVarCharValues() {
        return Table.getByteArray(this.values);
    }

    public byte[][] getBlobValues() {
        return Table.getByteArray(this.values);
    }

    public byte[][] getClobValues() {
        return Table.getByteArray(this.values);
    }

    public byte[][] getCharValues() {
        return Table.getByteArray(this.values);
    }

    public Integer[][] getListValues() {
        return JdbcToArrowTestHelper.getListValues(this.values);
    }

    public String getCreate() {
        return this.create;
    }

    public void setCreate(String create) {
        this.create = create;
    }

    public String[] getData() {
        return this.data;
    }

    public void setData(String[] data) {
        this.data = data;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getDrop() {
        return this.drop;
    }

    public void setDrop(String drop) {
        this.drop = drop;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String[] getVectors() {
        return this.vectors;
    }

    public void setVectors(String[] vectors) {
        this.vectors = vectors;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public String toString() {
        return "Table{name='" + this.name + "', type='" + this.type + "'}";
    }

    static byte[][] getByteArray(String[] data) {
        byte[][] byteArr = new byte[data.length][];
        for (int i = 0; i < data.length; ++i) {
            byteArr[i] = data[i].getBytes(StandardCharsets.UTF_8);
        }
        return byteArr;
    }
}

