/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.ResultSetUtility;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResultSetUtilityTest {
    @Test
    public void testZeroRowResultSet() throws Exception {
        for (boolean reuseVectorSchemaRoot : new boolean[]{false, true}) {
            try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);){
                ResultSet rs = ResultSetUtility.generateEmptyResultSet();
                JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)allocator, JdbcToArrowUtils.getUtcCalendar(), false).setReuseVectorSchemaRoot(reuseVectorSchemaRoot).build();
                ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)rs, (JdbcToArrowConfig)config);
                Assertions.assertTrue((boolean)iter.hasNext(), (String)"Iterator on zero row ResultSet should haveNext() before use");
                VectorSchemaRoot root = iter.next();
                Assertions.assertNotNull((Object)root, (String)"VectorSchemaRoot from first next() result should never be null");
                Assertions.assertEquals((int)0, (int)root.getRowCount(), (String)"VectorSchemaRoot from empty ResultSet should have zero rows");
                Assertions.assertFalse((boolean)iter.hasNext(), (String)"hasNext() should return false on empty ResultSets after initial next() call");
            }
        }
    }

    @Test
    public void testBasicResultSet() throws Exception {
        try (ResultSetUtility.MockResultSet resultSet = ResultSetUtility.generateBasicResultSet(3);){
            Assertions.assertTrue((boolean)resultSet.isBeforeFirst());
            Assertions.assertFalse((boolean)resultSet.isFirst());
            Assertions.assertFalse((boolean)resultSet.isLast());
            Assertions.assertFalse((boolean)resultSet.isAfterLast());
            Assertions.assertThrows(SQLException.class, () -> resultSet.getString(1));
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertFalse((boolean)resultSet.isBeforeFirst());
            Assertions.assertTrue((boolean)resultSet.isFirst());
            Assertions.assertFalse((boolean)resultSet.isLast());
            Assertions.assertFalse((boolean)resultSet.isAfterLast());
            Assertions.assertEquals((Object)"row number: 1", (Object)resultSet.getString(1));
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertFalse((boolean)resultSet.isBeforeFirst());
            Assertions.assertFalse((boolean)resultSet.isFirst());
            Assertions.assertFalse((boolean)resultSet.isLast());
            Assertions.assertFalse((boolean)resultSet.isAfterLast());
            Assertions.assertEquals((Object)"row number: 2", (Object)resultSet.getString(1));
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertFalse((boolean)resultSet.isBeforeFirst());
            Assertions.assertFalse((boolean)resultSet.isFirst());
            Assertions.assertTrue((boolean)resultSet.isLast());
            Assertions.assertFalse((boolean)resultSet.isAfterLast());
            Assertions.assertEquals((Object)"row number: 3", (Object)resultSet.getString(1));
            Assertions.assertFalse((boolean)resultSet.next());
            Assertions.assertFalse((boolean)resultSet.isBeforeFirst());
            Assertions.assertFalse((boolean)resultSet.isFirst());
            Assertions.assertFalse((boolean)resultSet.isLast());
            Assertions.assertTrue((boolean)resultSet.isAfterLast());
        }
    }

    @Test
    public void testMockDataTypes() throws SQLException {
        ResultSetUtility.MockDataElement element = new ResultSetUtility.MockDataElement(1L, 2);
        Assertions.assertEquals((long)1L, (long)element.getLong());
        Assertions.assertEquals((int)1, (int)element.getInt());
        Assertions.assertEquals((Object)"1", (Object)element.getString());
    }
}

