/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class ResultSetUtility {
    public static ResultSet generateEmptyResultSet() throws SQLException {
        MockDataElement element = new MockDataElement("string_example");
        MockResultSetMetaData.MockColumnMetaData columnMetaData = MockResultSetMetaData.MockColumnMetaData.fromDataElement(element, 1);
        ArrayList<MockResultSetMetaData.MockColumnMetaData> cols = new ArrayList<MockResultSetMetaData.MockColumnMetaData>();
        cols.add(columnMetaData);
        MockResultSetMetaData metadata = new MockResultSetMetaData(cols);
        return MockResultSet.builder().setMetaData(metadata).build();
    }

    public static MockResultSet generateBasicResultSet(int rows) throws SQLException {
        MockResultSet.Builder builder = MockResultSet.builder();
        for (int i = 0; i < rows; ++i) {
            builder.addDataElement("row number: " + (i + 1)).addDataElement("data").finishRow();
        }
        return builder.build();
    }

    private static SQLException getExceptionToThrow() {
        return ResultSetUtility.getExceptionToThrow("Method is not implemented!");
    }

    private static SQLException getExceptionToThrow(String message) {
        return new SQLException(message);
    }

    public static class MockDataElement {
        private final Object value;
        private final int sqlType;

        public MockDataElement(String val) {
            this(val, 12);
        }

        public MockDataElement(Object val, int sqlType) {
            this.value = val;
            this.sqlType = sqlType;
        }

        private boolean isNull() {
            return this.value == null;
        }

        private String getValueAsString() {
            return this.value.toString();
        }

        private int getPrecision() throws SQLException {
            switch (this.sqlType) {
                case 12: {
                    return this.getValueAsString().length();
                }
                case 3: {
                    return this.getBigDecimal().precision();
                }
            }
            throw ResultSetUtility.getExceptionToThrow("Unable to determine precision for data type: " + this.sqlType);
        }

        private int getScale() throws SQLException {
            switch (this.sqlType) {
                case 12: {
                    return 0;
                }
                case 3: {
                    return this.getBigDecimal().scale();
                }
            }
            throw ResultSetUtility.getExceptionToThrow("Unable to determine scale for data type!");
        }

        private int isNullable() throws SQLException {
            switch (this.sqlType) {
                case 3: 
                case 12: {
                    return 1;
                }
            }
            return 2;
        }

        private int getSqlType() throws SQLException {
            return this.sqlType;
        }

        public BigDecimal getBigDecimal() throws SQLException {
            if (this.value == null) {
                return null;
            }
            try {
                return new BigDecimal(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public String getString() throws SQLException {
            if (this.value == null) {
                return null;
            }
            return this.getValueAsString();
        }

        public boolean getBoolean() throws SQLException {
            if (this.value == null) {
                return false;
            }
            try {
                return (Boolean)this.value;
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public int getInt() throws SQLException {
            if (this.value == null) {
                return 0;
            }
            try {
                return Integer.parseInt(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public long getLong() throws SQLException {
            if (this.value == null) {
                return 0L;
            }
            try {
                return Long.parseLong(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public double getDouble() throws SQLException {
            if (this.value == null) {
                return 0.0;
            }
            try {
                return Double.parseDouble(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public Date getDate() throws SQLException {
            if (this.value == null) {
                return null;
            }
            try {
                return Date.valueOf(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public Time getTime() throws SQLException {
            if (this.value == null) {
                return null;
            }
            try {
                return Time.valueOf(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public Timestamp getTimestamp() throws SQLException {
            if (this.value == null) {
                return null;
            }
            try {
                return Timestamp.valueOf(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public float getFloat() throws SQLException {
            if (this.value == null) {
                return 0.0f;
            }
            try {
                return Float.parseFloat(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }

        public short getShort() throws SQLException {
            if (this.value == null) {
                return 0;
            }
            try {
                return Short.parseShort(this.getValueAsString());
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }
    }

    public static class MockResultSetMetaData
    extends ThrowingResultSetMetaData {
        private final List<MockColumnMetaData> columns;

        public MockResultSetMetaData(List<MockColumnMetaData> columns) {
            this.columns = columns;
        }

        @Override
        public int getColumnCount() throws SQLException {
            return this.columns.size();
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.columns.get(column - 1).getLabel();
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            return this.columns.get(column - 1).getName();
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            return this.columns.get(column - 1).getType();
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            return this.columns.get(column - 1).getPrecision();
        }

        @Override
        public int getScale(int column) throws SQLException {
            return this.columns.get(column - 1).getScale();
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return this.columns.get(column - 1).isNullable();
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            return this.columns.get(column - 1).getDisplaySize();
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            return this.columns.get(column - 1).getTypeName();
        }

        public static MockResultSetMetaData fromRows(List<MockRow> rows) throws SQLException {
            if (rows.size() == 0) {
                throw new SQLException("Unable to dynamically generate ResultSetMetaData because row count is zero!");
            }
            MockRow firstRow = rows.get(0);
            if (firstRow.dataElements.size() == 0) {
                throw new SQLException("Unable to dynamically generate ResultSetMetaData because column count is zero!");
            }
            ArrayList<MockColumnMetaData> columns = new ArrayList<MockColumnMetaData>();
            for (int i = 0; i < firstRow.dataElements.size(); ++i) {
                MockDataElement element = firstRow.getDataElementAtIndex(i);
                columns.add(MockColumnMetaData.fromDataElement(element, i));
            }
            return new MockResultSetMetaData(columns);
        }

        public static class MockColumnMetaData {
            private int sqlType;
            private int precision;
            private int scale;
            private int nullable;
            private String label;
            private String typeName;
            private int displaySize;

            private MockColumnMetaData() {
            }

            private String getLabel() {
                return this.label;
            }

            private String getName() {
                return this.getLabel();
            }

            private int getType() {
                return this.sqlType;
            }

            private int getPrecision() {
                return this.precision;
            }

            private int getScale() {
                return this.scale;
            }

            private int isNullable() {
                return this.nullable;
            }

            private String getTypeName() {
                return this.typeName;
            }

            private int getDisplaySize() {
                return this.displaySize;
            }

            public static MockColumnMetaData fromDataElement(MockDataElement element, int i) throws SQLException {
                return MockColumnMetaData.builder().sqlType(element.getSqlType()).precision(element.getPrecision()).scale(element.getScale()).nullable(element.isNullable()).setTypeName("TYPE").setDisplaySize(420).label("col_" + i).build();
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private MockColumnMetaData columnMetaData = new MockColumnMetaData();

                public Builder label(String label) {
                    this.columnMetaData.label = label;
                    return this;
                }

                public Builder sqlType(int sqlType) {
                    this.columnMetaData.sqlType = sqlType;
                    return this;
                }

                public Builder precision(int precision) {
                    this.columnMetaData.precision = precision;
                    return this;
                }

                public Builder scale(int scale) {
                    this.columnMetaData.scale = scale;
                    return this;
                }

                public Builder nullable(int nullable) {
                    this.columnMetaData.nullable = nullable;
                    return this;
                }

                public Builder setTypeName(String typeName) {
                    this.columnMetaData.typeName = typeName;
                    return this;
                }

                public Builder setDisplaySize(int displaySize) {
                    this.columnMetaData.displaySize = displaySize;
                    return this;
                }

                public MockColumnMetaData build() {
                    return this.columnMetaData;
                }
            }
        }
    }

    public static class MockResultSet
    extends ThrowingResultSet {
        private final List<MockRow> rows;
        private int index = 0;
        private boolean isClosed = false;
        private ResultSetMetaData metadata;
        private boolean wasNull;

        public MockResultSet(List<MockRow> rows) throws SQLException {
            this(rows, MockResultSetMetaData.fromRows(rows));
        }

        public MockResultSet(List<MockRow> rows, ResultSetMetaData metadata) {
            this.rows = rows;
            this.metadata = metadata;
            this.wasNull = false;
        }

        public static Builder builder() {
            return new Builder();
        }

        private void throwIfClosed() throws SQLException {
            if (this.isClosed) {
                throw new SQLException("ResultSet is already closed!");
            }
        }

        private void setWasNull(MockDataElement element) {
            this.wasNull = element.isNull();
        }

        @Override
        public boolean next() throws SQLException {
            this.throwIfClosed();
            ++this.index;
            return this.index <= this.rows.size();
        }

        @Override
        public void close() throws SQLException {
            this.throwIfClosed();
            this.isClosed = true;
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            this.throwIfClosed();
            return this.index == 0;
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return this.index > this.rows.size();
        }

        @Override
        public boolean isFirst() throws SQLException {
            return this.index == 1;
        }

        @Override
        public boolean isLast() throws SQLException {
            return this.index == this.rows.size();
        }

        @Override
        public void beforeFirst() throws SQLException {
            this.index = 0;
        }

        @Override
        public void afterLast() throws SQLException {
            this.index = this.rows.size();
        }

        private MockRow getCurrentRow() throws SQLException {
            this.throwIfClosed();
            if (this.index == 0) {
                throw new SQLException("Index is before first element!");
            }
            if (this.index <= this.rows.size()) {
                return this.rows.get(this.index - 1);
            }
            throw new SQLException("Unable to fetch row at index: " + this.index);
        }

        private MockDataElement getDataElementAtCol(int idx) throws SQLException {
            MockRow row = this.getCurrentRow();
            MockDataElement element = row.getDataElementAtIndex(idx - 1);
            this.setWasNull(element);
            return element;
        }

        @Override
        public String getString(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getString();
        }

        @Override
        public boolean getBoolean(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getBoolean();
        }

        @Override
        public short getShort(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getShort();
        }

        @Override
        public int getInt(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getInt();
        }

        @Override
        public long getLong(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getLong();
        }

        @Override
        public float getFloat(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getFloat();
        }

        @Override
        public double getDouble(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getDouble();
        }

        @Override
        public BigDecimal getBigDecimal(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getBigDecimal();
        }

        @Override
        public Date getDate(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getDate();
        }

        @Override
        public Time getTime(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getTime();
        }

        @Override
        public Timestamp getTimestamp(int idx) throws SQLException {
            return this.getDataElementAtCol(idx).getTimestamp();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return this.metadata;
        }

        @Override
        public boolean wasNull() throws SQLException {
            return this.wasNull;
        }

        public static class Builder {
            private final ArrayList<MockRow> rows = new ArrayList();
            private ArrayList<MockDataElement> bufferedElements = new ArrayList();
            private ResultSetMetaData metadata;

            Builder() {
            }

            public Builder finishRow() {
                this.rows.add(new MockRow(this.bufferedElements));
                this.bufferedElements = new ArrayList();
                return this;
            }

            public Builder addDataElement(MockDataElement element) {
                this.bufferedElements.add(element);
                return this;
            }

            public Builder addDataElement(String str) {
                return this.addDataElement(new MockDataElement(str));
            }

            public Builder addDataElement(Object val, int sqlType) {
                return this.addDataElement(new MockDataElement(val, sqlType));
            }

            public Builder setMetaData(ResultSetMetaData metadata) {
                this.metadata = metadata;
                return this;
            }

            public MockResultSet build() throws SQLException {
                if (this.metadata == null) {
                    return new MockResultSet(this.rows);
                }
                return new MockResultSet(this.rows, this.metadata);
            }
        }
    }

    public static class ThrowingResultSetMetaData
    implements ResultSetMetaData {
        @Override
        public int getColumnCount() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int isNullable(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getScale(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getTableName(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }
    }

    public static class ThrowingResultSet
    implements ResultSet {
        @Override
        public boolean next() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void close() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean wasNull() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getString(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean getBoolean(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public byte getByte(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public short getShort(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getInt(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public long getLong(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public float getFloat(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public double getDouble(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public byte[] getBytes(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public InputStream getAsciiStream(int columnIndex) throws SQLException {
            return null;
        }

        @Override
        public InputStream getUnicodeStream(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public InputStream getBinaryStream(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getString(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean getBoolean(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public byte getByte(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public short getShort(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getInt(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public long getLong(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public float getFloat(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public double getDouble(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public byte[] getBytes(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Date getDate(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Time getTime(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Timestamp getTimestamp(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public InputStream getAsciiStream(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public InputStream getUnicodeStream(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public InputStream getBinaryStream(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void clearWarnings() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getCursorName() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Object getObject(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int findColumn(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Reader getCharacterStream(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Reader getCharacterStream(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isBeforeFirst() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isFirst() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isLast() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void beforeFirst() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void afterLast() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean first() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean last() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean absolute(int row) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean relative(int rows) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean previous() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getFetchDirection() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getFetchSize() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getType() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getConcurrency() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean rowUpdated() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean rowInserted() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean rowDeleted() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNull(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBoolean(int columnIndex, boolean x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateByte(int columnIndex, byte x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateShort(int columnIndex, short x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateInt(int columnIndex, int x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateLong(int columnIndex, long x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateFloat(int columnIndex, float x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateDouble(int columnIndex, double x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateString(int columnIndex, String x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBytes(int columnIndex, byte[] x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateDate(int columnIndex, Date x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateTime(int columnIndex, Time x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(int columnIndex, Object x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNull(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBoolean(String columnLabel, boolean x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateByte(String columnLabel, byte x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateShort(String columnLabel, short x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateInt(String columnLabel, int x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateLong(String columnLabel, long x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateFloat(String columnLabel, float x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateDouble(String columnLabel, double x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateString(String columnLabel, String x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBytes(String columnLabel, byte[] x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateDate(String columnLabel, Date x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateTime(String columnLabel, Time x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(String columnLabel, Object x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void insertRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void deleteRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void refreshRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void cancelRowUpdates() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void moveToInsertRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void moveToCurrentRow() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Statement getStatement() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Ref getRef(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Blob getBlob(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Clob getClob(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Array getArray(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Ref getRef(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Blob getBlob(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Clob getClob(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Array getArray(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Date getDate(int columnIndex, Calendar cal) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Date getDate(String columnLabel, Calendar cal) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Time getTime(int columnIndex, Calendar cal) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Time getTime(String columnLabel, Calendar cal) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public URL getURL(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public URL getURL(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateRef(int columnIndex, Ref x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateRef(String columnLabel, Ref x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBlob(int columnIndex, Blob x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBlob(String columnLabel, Blob x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateClob(int columnIndex, Clob x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateClob(String columnLabel, Clob x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateArray(int columnIndex, Array x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateArray(String columnLabel, Array x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public RowId getRowId(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public RowId getRowId(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateRowId(int columnIndex, RowId x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateRowId(String columnLabel, RowId x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public int getHoldability() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isClosed() throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNString(int columnIndex, String nString) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNString(String columnLabel, String nString) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public NClob getNClob(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public NClob getNClob(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public SQLXML getSQLXML(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public SQLXML getSQLXML(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getNString(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public String getNString(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Reader getNCharacterStream(int columnIndex) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public Reader getNCharacterStream(String columnLabel) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateClob(int columnIndex, Reader reader) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateClob(String columnLabel, Reader reader) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNClob(int columnIndex, Reader reader) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateNClob(String columnLabel, Reader reader) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw ResultSetUtility.getExceptionToThrow();
        }
    }

    public static class MockRow {
        private final List<MockDataElement> dataElements;

        public MockRow(List<MockDataElement> elements) {
            this.dataElements = elements;
        }

        public MockDataElement getDataElementAtIndex(int idx) throws SQLException {
            if (idx > this.dataElements.size()) {
                throw new SQLException("Unable to find data element at position: " + idx);
            }
            return this.dataElements.get(idx);
        }
    }
}

