/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.ObjectMapperFactory;
import org.apache.arrow.vector.util.Text;
import org.junit.jupiter.api.Assertions;

public class JdbcToArrowTestHelper {
    public static void assertIntVectorValues(IntVector intVector, int rowCount, Integer[] values) {
        Assertions.assertEquals((int)rowCount, (int)intVector.getValueCount());
        for (int j = 0; j < intVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)intVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((int)values[j], (int)intVector.get(j));
        }
    }

    public static void assertBooleanVectorValues(BitVector bitVector, int rowCount, Boolean[] values) {
        Assertions.assertEquals((int)rowCount, (int)bitVector.getValueCount());
        for (int j = 0; j < bitVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)bitVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((Object)values[j], (Object)(bitVector.get(j) == 1 ? 1 : 0));
        }
    }

    public static void assertBitVectorValues(BitVector bitVector, int rowCount, Integer[] values) {
        Assertions.assertEquals((int)rowCount, (int)bitVector.getValueCount());
        for (int j = 0; j < bitVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)bitVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((int)values[j], (int)bitVector.get(j));
        }
    }

    public static void assertTinyIntVectorValues(TinyIntVector tinyIntVector, int rowCount, Integer[] values) {
        Assertions.assertEquals((int)rowCount, (int)tinyIntVector.getValueCount());
        for (int j = 0; j < tinyIntVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)tinyIntVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((int)values[j], (int)tinyIntVector.get(j));
        }
    }

    public static void assertSmallIntVectorValues(SmallIntVector smallIntVector, int rowCount, Integer[] values) {
        Assertions.assertEquals((int)rowCount, (int)smallIntVector.getValueCount());
        for (int j = 0; j < smallIntVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)smallIntVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((int)values[j], (int)smallIntVector.get(j));
        }
    }

    public static void assertBigIntVectorValues(BigIntVector bigIntVector, int rowCount, Long[] values) {
        Assertions.assertEquals((int)rowCount, (int)bigIntVector.getValueCount());
        for (int j = 0; j < bigIntVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)bigIntVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((long)values[j], (long)bigIntVector.get(j));
        }
    }

    public static void assertDecimalVectorValues(DecimalVector decimalVector, int rowCount, BigDecimal[] values) {
        Assertions.assertEquals((int)rowCount, (int)decimalVector.getValueCount());
        for (int j = 0; j < decimalVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)decimalVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((double)values[j].doubleValue(), (double)decimalVector.getObject(j).doubleValue(), (double)0.0);
        }
    }

    public static void assertFloat8VectorValues(Float8Vector float8Vector, int rowCount, Double[] values) {
        Assertions.assertEquals((int)rowCount, (int)float8Vector.getValueCount());
        for (int j = 0; j < float8Vector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)float8Vector.isNull(j));
                continue;
            }
            Assertions.assertEquals((double)values[j], (double)float8Vector.get(j), (double)0.01);
        }
    }

    public static void assertFloat4VectorValues(Float4Vector float4Vector, int rowCount, Float[] values) {
        Assertions.assertEquals((int)rowCount, (int)float4Vector.getValueCount());
        for (int j = 0; j < float4Vector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)float4Vector.isNull(j));
                continue;
            }
            Assertions.assertEquals((double)values[j].floatValue(), (double)float4Vector.get(j), (double)0.01);
        }
    }

    public static void assertTimeVectorValues(TimeMilliVector timeMilliVector, int rowCount, Long[] values) {
        Assertions.assertEquals((int)rowCount, (int)timeMilliVector.getValueCount());
        for (int j = 0; j < timeMilliVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)timeMilliVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((long)values[j], (long)timeMilliVector.get(j));
        }
    }

    public static void assertDateVectorValues(DateDayVector dateDayVector, int rowCount, Integer[] values) {
        Assertions.assertEquals((int)rowCount, (int)dateDayVector.getValueCount());
        for (int j = 0; j < dateDayVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)dateDayVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((long)values[j].longValue(), (long)dateDayVector.get(j));
        }
    }

    public static void assertTimeStampVectorValues(TimeStampVector timeStampVector, int rowCount, Long[] values) {
        Assertions.assertEquals((int)rowCount, (int)timeStampVector.getValueCount());
        for (int j = 0; j < timeStampVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)timeStampVector.isNull(j));
                continue;
            }
            Assertions.assertEquals((long)values[j], (long)timeStampVector.get(j));
        }
    }

    public static void assertVarBinaryVectorValues(VarBinaryVector varBinaryVector, int rowCount, byte[][] values) {
        Assertions.assertEquals((int)rowCount, (int)varBinaryVector.getValueCount());
        for (int j = 0; j < varBinaryVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)varBinaryVector.isNull(j));
                continue;
            }
            Assertions.assertArrayEquals((byte[])values[j], (byte[])varBinaryVector.get(j));
        }
    }

    public static void assertVarcharVectorValues(VarCharVector varCharVector, int rowCount, byte[][] values) {
        Assertions.assertEquals((int)rowCount, (int)varCharVector.getValueCount());
        for (int j = 0; j < varCharVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)varCharVector.isNull(j));
                continue;
            }
            Assertions.assertArrayEquals((byte[])values[j], (byte[])varCharVector.get(j));
        }
    }

    public static void assertNullVectorValues(NullVector vector, int rowCount) {
        Assertions.assertEquals((int)rowCount, (int)vector.getValueCount());
    }

    public static void assertListVectorValues(ListVector listVector, int rowCount, Integer[][] values) {
        Assertions.assertEquals((int)rowCount, (int)listVector.getValueCount());
        for (int j = 0; j < listVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)listVector.isNull(j));
                continue;
            }
            List list = listVector.getObject(j);
            Assertions.assertEquals(Arrays.asList(values[j]), (Object)list);
        }
    }

    public static void assertMapVectorValues(MapVector mapVector, int rowCount, Map<String, String>[] values) {
        Assertions.assertEquals((int)rowCount, (int)mapVector.getValueCount());
        for (int j = 0; j < mapVector.getValueCount(); ++j) {
            if (values[j] == null) {
                Assertions.assertTrue((boolean)mapVector.isNull(j));
                continue;
            }
            JsonStringArrayList actualSource = (JsonStringArrayList)mapVector.getObject(j);
            Map actualMap = null;
            if (actualSource != null && !actualSource.isEmpty()) {
                actualMap = actualSource.stream().map(entry -> new AbstractMap.SimpleEntry<String, Object>(((Text)entry.get((Object)"key")).toString(), (entry.get((Object)"value") != null ? ((Text)entry.get((Object)"value")).toString() : null))).collect(HashMap::new, (collector, val) -> collector.put((String)val.getKey(), (String)val.getValue()), HashMap::putAll);
            }
            Assertions.assertEquals(values[j], actualMap);
        }
    }

    public static Map<String, String>[] getMapValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Map[] maps = new Map[dataArr.length];
        ObjectMapper objectMapper = ObjectMapperFactory.newObjectMapper();
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        for (int idx = 0; idx < dataArr.length; ++idx) {
            String jsonString = dataArr[idx].replace("|", ",");
            if (jsonString.isEmpty()) continue;
            try {
                maps[idx] = (Map)objectMapper.readValue(jsonString, (TypeReference)typeReference);
                continue;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return maps;
    }

    public static void assertNullValues(BaseValueVector vector, int rowCount) {
        Assertions.assertEquals((int)rowCount, (int)vector.getValueCount());
        for (int j = 0; j < vector.getValueCount(); ++j) {
            Assertions.assertTrue((boolean)vector.isNull(j));
        }
    }

    public static void assertFieldMetadataIsEmpty(VectorSchemaRoot schema) {
        Assertions.assertNotNull((Object)schema);
        Assertions.assertNotNull((Object)schema.getSchema());
        Assertions.assertNotNull((Object)schema.getSchema().getFields());
        for (Field field : schema.getSchema().getFields()) {
            Assertions.assertNotNull((Object)field.getMetadata());
            Assertions.assertEquals((int)0, (int)field.getMetadata().size());
        }
    }

    public static void assertFieldMetadataMatchesResultSetMetadata(ResultSetMetaData rsmd, Schema schema) throws SQLException {
        Assertions.assertNotNull((Object)schema);
        Assertions.assertNotNull((Object)schema.getFields());
        Assertions.assertNotNull((Object)rsmd);
        List fields = schema.getFields();
        Assertions.assertEquals((int)rsmd.getColumnCount(), (int)fields.size());
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            Map metadata = ((Field)fields.get(i - 1)).getMetadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertEquals((int)5, (int)metadata.size());
            Assertions.assertEquals((Object)rsmd.getCatalogName(i), metadata.get("SQL_CATALOG_NAME"));
            Assertions.assertEquals((Object)rsmd.getSchemaName(i), metadata.get("SQL_SCHEMA_NAME"));
            Assertions.assertEquals((Object)rsmd.getTableName(i), metadata.get("SQL_TABLE_NAME"));
            Assertions.assertEquals((Object)rsmd.getColumnLabel(i), metadata.get("SQL_COLUMN_NAME"));
            Assertions.assertEquals((Object)rsmd.getColumnTypeName(i), metadata.get("SQL_TYPE"));
        }
    }

    public static Integer[] getIntValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Integer[] valueArr = new Integer[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Integer.valueOf(Integer.parseInt(data));
        }
        return valueArr;
    }

    public static Boolean[] getBooleanValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Boolean[] valueArr = new Boolean[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Boolean.valueOf(data.trim().equals("1"));
        }
        return valueArr;
    }

    public static BigDecimal[] getDecimalValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        BigDecimal[] valueArr = new BigDecimal[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : new BigDecimal(data);
        }
        return valueArr;
    }

    public static Double[] getDoubleValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Double[] valueArr = new Double[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Double.valueOf(Double.parseDouble(data));
        }
        return valueArr;
    }

    public static Float[] getFloatValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Float[] valueArr = new Float[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Float.valueOf(Float.parseFloat(data));
        }
        return valueArr;
    }

    public static Long[] getLongValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        Long[] valueArr = new Long[dataArr.length];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : Long.valueOf(Long.parseLong(data));
        }
        return valueArr;
    }

    public static byte[][] getCharArray(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        byte[][] valueArr = new byte[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : data.trim().getBytes(StandardCharsets.UTF_8);
        }
        return valueArr;
    }

    public static byte[][] getCharArrayWithCharSet(String[] values, String dataType, Charset charSet) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        byte[][] valueArr = new byte[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : data.trim().getBytes(charSet);
        }
        return valueArr;
    }

    public static byte[][] getBinaryValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        byte[][] valueArr = new byte[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            valueArr[i++] = "null".equals(data.trim()) ? null : data.trim().getBytes(StandardCharsets.UTF_8);
        }
        return valueArr;
    }

    public static String[] getValues(String[] values, String dataType) {
        String value = "";
        for (String val : values) {
            if (!val.startsWith(dataType)) continue;
            value = val.split("=")[1];
            break;
        }
        return value.split(",");
    }

    public static Integer[][] getListValues(String[] values, String dataType) {
        String[] dataArr = JdbcToArrowTestHelper.getValues(values, dataType);
        return JdbcToArrowTestHelper.getListValues(dataArr);
    }

    public static Integer[][] getListValues(String[] dataArr) {
        Integer[][] valueArr = new Integer[dataArr.length][];
        int i = 0;
        for (String data : dataArr) {
            if ("null".equals(data.trim())) {
                valueArr[i++] = null;
                continue;
            }
            if ("()".equals(data.trim())) {
                valueArr[i++] = new Integer[0];
                continue;
            }
            String[] row = data.replace("(", "").replace(")", "").split(";");
            Integer[] arr = new Integer[row.length];
            for (int j = 0; j < arr.length; ++j) {
                arr[j] = "null".equals(row[j]) ? null : Integer.valueOf(Integer.parseInt(row[j]));
            }
            valueArr[i++] = arr;
        }
        return valueArr;
    }
}

