/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JdbcToArrowConfigTest {
    private static final BufferAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
    private static final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);

    @Test
    public void testConfigNullArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> new JdbcToArrowConfig(null, null));
    }

    @Test
    public void testBuilderNullArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> new JdbcToArrowConfigBuilder(null, null));
    }

    @Test
    public void testConfigNullCalendar() {
        JdbcToArrowConfig config = new JdbcToArrowConfig(allocator, null);
        Assertions.assertNull((Object)config.getCalendar());
    }

    @Test
    public void testBuilderNullCalendar() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, null);
        JdbcToArrowConfig config = builder.build();
        Assertions.assertNull((Object)config.getCalendar());
    }

    @Test
    public void testConfigNullAllocator() {
        Assertions.assertThrows(NullPointerException.class, () -> new JdbcToArrowConfig(null, calendar));
    }

    @Test
    public void testBuilderNullAllocator() {
        Assertions.assertThrows(NullPointerException.class, () -> new JdbcToArrowConfigBuilder(null, calendar));
    }

    @Test
    public void testSetNullAllocator() {
        Assertions.assertThrows(NullPointerException.class, () -> {
            JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar);
            builder.setAllocator(null);
        });
    }

    @Test
    public void testSetNullCalendar() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar);
        JdbcToArrowConfig config = builder.setCalendar(null).build();
        Assertions.assertNull((Object)config.getCalendar());
    }

    @Test
    public void testConfig() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar);
        JdbcToArrowConfig config = builder.build();
        Assertions.assertEquals((Object)allocator, (Object)config.getAllocator());
        Assertions.assertEquals((Object)calendar, (Object)config.getCalendar());
        Calendar newCalendar = Calendar.getInstance();
        RootAllocator newAllocator = new RootAllocator(32L);
        builder.setAllocator((BufferAllocator)newAllocator).setCalendar(newCalendar);
        config = builder.build();
        Assertions.assertEquals((Object)newAllocator, (Object)config.getAllocator());
        Assertions.assertEquals((Object)newCalendar, (Object)config.getCalendar());
    }

    @Test
    public void testIncludeMetadata() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar, false);
        JdbcToArrowConfig config = builder.build();
        Assertions.assertFalse((boolean)config.shouldIncludeMetadata());
        builder.setIncludeMetadata(true);
        config = builder.build();
        Assertions.assertTrue((boolean)config.shouldIncludeMetadata());
        config = new JdbcToArrowConfigBuilder(allocator, calendar, true).build();
        Assertions.assertTrue((boolean)config.shouldIncludeMetadata());
        config = new JdbcToArrowConfig(allocator, calendar, true, true, null, null, -1, null);
        Assertions.assertTrue((boolean)config.shouldIncludeMetadata());
        Assertions.assertTrue((boolean)config.isReuseVectorSchemaRoot());
        config = new JdbcToArrowConfig(allocator, calendar, false, false, null, null, -1, null);
        Assertions.assertFalse((boolean)config.shouldIncludeMetadata());
        Assertions.assertFalse((boolean)config.isReuseVectorSchemaRoot());
    }

    @Test
    public void testArraySubTypes() {
        JdbcToArrowConfigBuilder builder = new JdbcToArrowConfigBuilder(allocator, calendar, false);
        JdbcToArrowConfig config = builder.build();
        boolean columnIndex = true;
        String columnName = "COLUMN";
        Assertions.assertNull((Object)config.getArraySubTypeByColumnIndex(1));
        Assertions.assertNull((Object)config.getArraySubTypeByColumnName("COLUMN"));
        HashMap<Integer, JdbcFieldInfo> indexMapping = new HashMap<Integer, JdbcFieldInfo>();
        indexMapping.put(2, new JdbcFieldInfo(-5));
        HashMap<String, JdbcFieldInfo> fieldMapping = new HashMap<String, JdbcFieldInfo>();
        fieldMapping.put("NEW_COLUMN", new JdbcFieldInfo(-2));
        builder.setArraySubTypeByColumnIndexMap(indexMapping);
        builder.setArraySubTypeByColumnNameMap(fieldMapping);
        config = builder.build();
        Assertions.assertNull((Object)config.getArraySubTypeByColumnIndex(1));
        Assertions.assertNull((Object)config.getArraySubTypeByColumnName("COLUMN"));
        indexMapping.put(1, new JdbcFieldInfo(-7));
        fieldMapping.put("COLUMN", new JdbcFieldInfo(2004));
        Assertions.assertNotNull((Object)config.getArraySubTypeByColumnIndex(1));
        Assertions.assertEquals((int)-7, (int)config.getArraySubTypeByColumnIndex(1).getJdbcType());
        Assertions.assertEquals((int)2004, (int)config.getArraySubTypeByColumnName("COLUMN").getJdbcType());
    }
}

