/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JdbcToArrowCommentMetadataTest {
    private static final String COMMENT = "comment";
    private Connection conn = null;

    @BeforeEach
    public void setUp() throws SQLException, ClassNotFoundException {
        String url = "jdbc:h2:mem:JdbcToArrowTest?characterEncoding=UTF-8;INIT=runscript from 'classpath:/h2/comment.sql'";
        String driver = "org.h2.Driver";
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url);
    }

    @AfterEach
    public void tearDown() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    private static Field field(String name, boolean nullable, ArrowType type, Map<String, String> metadata) {
        return new Field(name, new FieldType(nullable, type, null, metadata), Collections.emptyList());
    }

    private static Map<String, String> metadata(String ... entries) {
        if (entries.length % 2 != 0) {
            throw new IllegalArgumentException("Map must have equal number of keys and values");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < entries.length; i += 2) {
            result.put(entries[i], entries[i + 1]);
        }
        return result;
    }

    @Test
    public void schemaComment() throws Exception {
        boolean includeMetadata = false;
        Schema schema = this.getSchemaWithCommentFromQuery(includeMetadata);
        Schema expectedSchema = new Schema(Arrays.asList(JdbcToArrowCommentMetadataTest.field("ID", false, Types.MinorType.BIGINT.getType(), JdbcToArrowCommentMetadataTest.metadata(COMMENT, "Record identifier")), JdbcToArrowCommentMetadataTest.field("NAME", true, Types.MinorType.VARCHAR.getType(), JdbcToArrowCommentMetadataTest.metadata(COMMENT, "Name of record")), JdbcToArrowCommentMetadataTest.field("COLUMN1", true, Types.MinorType.BIT.getType(), JdbcToArrowCommentMetadataTest.metadata(new String[0])), JdbcToArrowCommentMetadataTest.field("COLUMNN", true, Types.MinorType.INT.getType(), JdbcToArrowCommentMetadataTest.metadata(COMMENT, "Informative description of columnN"))), JdbcToArrowCommentMetadataTest.metadata(COMMENT, "This is super special table with valuable data"));
        Assertions.assertThat((Object)schema).isEqualTo((Object)expectedSchema);
    }

    @Test
    public void schemaCommentWithDatabaseMetadata() throws Exception {
        boolean includeMetadata = true;
        Schema schema = this.getSchemaWithCommentFromQuery(includeMetadata);
        Schema expectedSchema = new Schema(Arrays.asList(JdbcToArrowCommentMetadataTest.field("ID", false, Types.MinorType.BIGINT.getType(), JdbcToArrowCommentMetadataTest.metadata("SQL_CATALOG_NAME", "JDBCTOARROWTEST?CHARACTERENCODING=UTF-8", "SQL_SCHEMA_NAME", "PUBLIC", "SQL_TABLE_NAME", "TABLE1", "SQL_COLUMN_NAME", "ID", "SQL_TYPE", "BIGINT", COMMENT, "Record identifier")), JdbcToArrowCommentMetadataTest.field("NAME", true, Types.MinorType.VARCHAR.getType(), JdbcToArrowCommentMetadataTest.metadata("SQL_CATALOG_NAME", "JDBCTOARROWTEST?CHARACTERENCODING=UTF-8", "SQL_SCHEMA_NAME", "PUBLIC", "SQL_TABLE_NAME", "TABLE1", "SQL_COLUMN_NAME", "NAME", "SQL_TYPE", "CHARACTER VARYING", COMMENT, "Name of record")), JdbcToArrowCommentMetadataTest.field("COLUMN1", true, Types.MinorType.BIT.getType(), JdbcToArrowCommentMetadataTest.metadata("SQL_CATALOG_NAME", "JDBCTOARROWTEST?CHARACTERENCODING=UTF-8", "SQL_SCHEMA_NAME", "PUBLIC", "SQL_TABLE_NAME", "TABLE1", "SQL_COLUMN_NAME", "COLUMN1", "SQL_TYPE", "BOOLEAN")), JdbcToArrowCommentMetadataTest.field("COLUMNN", true, Types.MinorType.INT.getType(), JdbcToArrowCommentMetadataTest.metadata("SQL_CATALOG_NAME", "JDBCTOARROWTEST?CHARACTERENCODING=UTF-8", "SQL_SCHEMA_NAME", "PUBLIC", "SQL_TABLE_NAME", "TABLE1", "SQL_COLUMN_NAME", "COLUMNN", "SQL_TYPE", "INTEGER", COMMENT, "Informative description of columnN"))), JdbcToArrowCommentMetadataTest.metadata(COMMENT, "This is super special table with valuable data"));
        Assertions.assertThat((Object)schema).isEqualTo((Object)expectedSchema);
        Assertions.assertThat((Object)schema).isEqualTo((Object)expectedSchema);
    }

    private Schema getSchemaWithCommentFromQuery(boolean includeMetadata) throws SQLException {
        DatabaseMetaData metaData = this.conn.getMetaData();
        try (Statement statement = this.conn.createStatement();){
            Schema schema;
            block12: {
                ResultSet resultSet = statement.executeQuery("select * from table1");
                try {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Map<Integer, Map<String, String>> columnCommentByColumnIndex = this.getColumnComments(metaData, resultSetMetaData);
                    String tableName = this.getTableNameFromResultSetMetaData(resultSetMetaData);
                    String tableComment = this.getTableComment(metaData, tableName);
                    JdbcToArrowConfig config = new JdbcToArrowConfigBuilder().setAllocator((BufferAllocator)new RootAllocator()).setSchemaMetadata(Collections.singletonMap(COMMENT, tableComment)).setColumnMetadataByColumnIndex(columnCommentByColumnIndex).setIncludeMetadata(includeMetadata).build();
                    schema = JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSetMetaData, (JdbcToArrowConfig)config);
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return schema;
        }
    }

    private String getTableNameFromResultSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        HashSet<String> tablesFromQuery = new HashSet<String>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int idx = 1; idx <= columnCount; ++idx) {
            String tableName = resultSetMetaData.getTableName(idx);
            if (tableName == null || tableName.isEmpty()) continue;
            tablesFromQuery.add(tableName);
        }
        if (tablesFromQuery.size() == 1) {
            return (String)tablesFromQuery.iterator().next();
        }
        throw new RuntimeException("Table metadata is absent or ambiguous");
    }

    private Map<Integer, Map<String, String>> getColumnComments(DatabaseMetaData metaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        HashMap<Integer, Map<String, String>> columnCommentByColumnIndex = new HashMap<Integer, Map<String, String>>();
        int columnCount = resultSetMetaData.getColumnCount();
        for (int columnIdx = 1; columnIdx <= columnCount; ++columnIdx) {
            String columnComment = this.getColumnComment(metaData, resultSetMetaData.getTableName(columnIdx), resultSetMetaData.getColumnName(columnIdx));
            if (columnComment == null || columnComment.isEmpty()) continue;
            columnCommentByColumnIndex.put(columnIdx, Collections.singletonMap(COMMENT, columnComment));
        }
        return columnCommentByColumnIndex;
    }

    private String getTableComment(DatabaseMetaData metaData, String tableName) throws SQLException {
        if (tableName == null || tableName.isEmpty()) {
            return null;
        }
        String comment = null;
        int rowCount = 0;
        try (ResultSet tableMetadata = metaData.getTables(null, null, tableName, null);){
            if (tableMetadata.next()) {
                comment = tableMetadata.getString("REMARKS");
                ++rowCount;
            }
        }
        if (rowCount == 1) {
            return comment;
        }
        if (rowCount > 1) {
            throw new RuntimeException("Multiple tables found for table name");
        }
        throw new RuntimeException("Table comment not found");
    }

    private String getColumnComment(DatabaseMetaData metaData, String tableName, String columnName) throws SQLException {
        try (ResultSet tableMetadata = metaData.getColumns(null, null, tableName, columnName);){
            if (tableMetadata.next()) {
                String string = tableMetadata.getString("REMARKS");
                return string;
            }
        }
        return null;
    }
}

