/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.Table;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ValueVectorUtility;
import org.junit.jupiter.api.AfterEach;

public abstract class AbstractJdbcToArrowTest {
    protected static final String BIGINT = "BIGINT_FIELD5";
    protected static final String BINARY = "BINARY_FIELD12";
    protected static final String BIT = "BIT_FIELD17";
    protected static final String BLOB = "BLOB_FIELD14";
    protected static final String BOOL = "BOOL_FIELD2";
    protected static final String CHAR = "CHAR_FIELD16";
    protected static final String CLOB = "CLOB_FIELD15";
    protected static final String DATE = "DATE_FIELD10";
    protected static final String DECIMAL = "DECIMAL_FIELD6";
    protected static final String DOUBLE = "DOUBLE_FIELD7";
    protected static final String INT = "INT_FIELD1";
    protected static final String LIST = "LIST_FIELD19";
    protected static final String MAP = "MAP_FIELD20";
    protected static final String REAL = "REAL_FIELD8";
    protected static final String SMALLINT = "SMALLINT_FIELD4";
    protected static final String TIME = "TIME_FIELD9";
    protected static final String TIMESTAMP = "TIMESTAMP_FIELD11";
    protected static final String TINYINT = "TINYINT_FIELD3";
    protected static final String VARCHAR = "VARCHAR_FIELD13";
    protected static final String NULL = "NULL_FIELD18";
    protected static final Map<String, JdbcFieldInfo> ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP = new HashMap<String, JdbcFieldInfo>();
    protected Connection conn = null;
    protected Table table;
    protected boolean reuseVectorSchemaRoot;

    protected static Table getTable(String ymlFilePath, Class clss) throws IOException {
        return (Table)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(clss.getClassLoader().getResourceAsStream(ymlFilePath), Table.class);
    }

    protected void initializeDatabase(Table table) throws SQLException, ClassNotFoundException {
        this.table = table;
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        String url = "jdbc:h2:mem:JdbcToArrowTest";
        String driver = "org.h2.Driver";
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url);
        try (Statement stmt = this.conn.createStatement();){
            stmt.executeUpdate(table.getCreate());
            for (String insert : table.getData()) {
                stmt.executeUpdate(insert);
            }
        }
    }

    @AfterEach
    public void destroy() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public static Object[][] prepareTestData(String[] testFiles, Class clss) throws SQLException, ClassNotFoundException, IOException {
        Object[][] tableArr = new Object[testFiles.length][];
        int i = 0;
        for (String testFile : testFiles) {
            tableArr[i++] = new Object[]{AbstractJdbcToArrowTest.getTable(testFile, clss)};
        }
        return tableArr;
    }

    public abstract void testJdbcToArrowValues(Table var1) throws SQLException, IOException, ClassNotFoundException;

    public abstract void testDataSets(VectorSchemaRoot var1, boolean var2);

    public VectorSchemaRoot sqlToArrow(Connection connection, String query, BufferAllocator allocator) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator object cannot be null");
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(allocator, JdbcToArrowUtils.getUtcCalendar()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        return AbstractJdbcToArrowTest.sqlToArrow(connection, query, config);
    }

    public VectorSchemaRoot sqlToArrow(Connection connection, String query, BufferAllocator allocator, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator object cannot be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object cannot be null");
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(allocator, calendar).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        return AbstractJdbcToArrowTest.sqlToArrow(connection, query, config);
    }

    public static VectorSchemaRoot sqlToArrow(Connection connection, String query, JdbcToArrowConfig config) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)connection, (Object)"JDBC connection object cannot be null");
        Preconditions.checkArgument((query != null && query.length() > 0 ? 1 : 0) != 0, (Object)"SQL query cannot be null or empty");
        try (Statement stmt = connection.createStatement();){
            VectorSchemaRoot vectorSchemaRoot = AbstractJdbcToArrowTest.sqlToArrow(stmt.executeQuery(query), config);
            return vectorSchemaRoot;
        }
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object cannot be null");
        return AbstractJdbcToArrowTest.sqlToArrow(resultSet, JdbcToArrowUtils.getUtcCalendar());
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, BufferAllocator allocator) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory Allocator object cannot be null");
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(allocator, JdbcToArrowUtils.getUtcCalendar()).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        return AbstractJdbcToArrowTest.sqlToArrow(resultSet, config);
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object cannot be null");
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder((BufferAllocator)new RootAllocator(Integer.MAX_VALUE), calendar).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        return AbstractJdbcToArrowTest.sqlToArrow(resultSet, config);
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, BufferAllocator allocator, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory Allocator object cannot be null");
        JdbcToArrowConfig config = new JdbcToArrowConfigBuilder(allocator, calendar).setArraySubTypeByColumnNameMap(ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP).build();
        return AbstractJdbcToArrowTest.sqlToArrow(resultSet, config);
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, JdbcToArrowConfig config) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"The configuration cannot be null");
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)JdbcToArrowUtils.jdbcToArrowSchema((ResultSetMetaData)resultSet.getMetaData(), (JdbcToArrowConfig)config), (BufferAllocator)config.getAllocator());
        if (config.getTargetBatchSize() != -1) {
            ValueVectorUtility.preAllocate((VectorSchemaRoot)root, (int)config.getTargetBatchSize());
        }
        JdbcToArrowUtils.jdbcToArrowVectors((ResultSet)resultSet, (VectorSchemaRoot)root, (JdbcToArrowConfig)config);
        return root;
    }

    protected Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter(Calendar calendar, ResultSetMetaData rsmd) {
        return jdbcFieldInfo -> {
            String columnLabel = null;
            try {
                int columnIndex = jdbcFieldInfo.getColumn();
                if (columnIndex != 0) {
                    columnLabel = rsmd.getColumnLabel(columnIndex);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            if (MAP.equals(columnLabel)) {
                return new ArrowType.Map(false);
            }
            return JdbcToArrowUtils.getArrowTypeFromJdbcType((JdbcFieldInfo)jdbcFieldInfo, (Calendar)calendar);
        };
    }

    protected ResultSetMetaData getQueryMetaData(String query) throws SQLException {
        return this.conn.createStatement().executeQuery(query).getMetaData();
    }

    static {
        ARRAY_SUB_TYPE_BY_COLUMN_NAME_MAP.put(LIST, new JdbcFieldInfo(4));
    }
}

