/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.c.ReferenceCountedArrowArray;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.util.DataSizeRoundingUtil;

class BufferImportTypeVisitor
implements ArrowType.ArrowTypeVisitor<List<ArrowBuf>>,
AutoCloseable {
    private final BufferAllocator allocator;
    private final ReferenceCountedArrowArray underlyingAllocation;
    private final ArrowFieldNode fieldNode;
    private final long[] buffers;
    private final List<ArrowBuf> imported;

    BufferImportTypeVisitor(BufferAllocator allocator, ReferenceCountedArrowArray underlyingAllocation, ArrowFieldNode fieldNode, long[] buffers) {
        this.allocator = allocator;
        this.underlyingAllocation = underlyingAllocation;
        this.fieldNode = fieldNode;
        this.buffers = buffers;
        this.imported = new ArrayList<ArrowBuf>();
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.imported);
    }

    @VisibleForTesting
    ArrowBuf importBuffer(ArrowType type, int index, long capacity) {
        Preconditions.checkState((this.buffers.length > index ? 1 : 0) != 0, (String)"Expected at least %s buffers for type %s, but found %s", (Object)(index + 1), (Object)type, (Object)this.buffers.length);
        long bufferPtr = this.buffers[index];
        if (bufferPtr == 0L) {
            if (capacity != 0L) {
                throw new IllegalStateException(String.format("Buffer %s for type %s cannot be null", index, type));
            }
            return this.allocator.getEmpty();
        }
        ArrowBuf buf = this.underlyingAllocation.unsafeAssociateAllocation(this.allocator, capacity, bufferPtr);
        this.imported.add(buf);
        return buf;
    }

    private ArrowBuf importFixedBits(ArrowType type, int index, long bitsPerSlot) {
        long capacity = DataSizeRoundingUtil.divideBy8Ceil((long)(bitsPerSlot * (long)this.fieldNode.getLength()));
        return this.importBuffer(type, index, capacity);
    }

    private ArrowBuf importFixedBytes(ArrowType type, int index, long bytesPerSlot) {
        long capacity = bytesPerSlot * (long)this.fieldNode.getLength();
        return this.importBuffer(type, index, capacity);
    }

    private ArrowBuf importOffsets(ArrowType type, long bytesPerSlot) {
        long capacity = bytesPerSlot * (long)(this.fieldNode.getLength() + 1);
        return this.importBuffer(type, 1, capacity);
    }

    private ArrowBuf importData(ArrowType type, long capacity) {
        return this.importBuffer(type, 2, capacity);
    }

    private ArrowBuf maybeImportBitmap(ArrowType type) {
        Preconditions.checkState((this.buffers.length > 0 ? 1 : 0) != 0, (String)"Expected at least %s buffers for type %s, but found %s", (Object)1, (Object)type, (Object)this.buffers.length);
        if (this.buffers[0] == 0L) {
            return null;
        }
        return this.importFixedBits(type, 0, 1L);
    }

    public List<ArrowBuf> visit(ArrowType.Null type) {
        Preconditions.checkState((this.buffers.length == 0 ? 1 : 0) != 0, (String)"Expected %s buffers for type %s, but found %s", (Object)0, (Object)type, (Object)this.buffers.length);
        return Collections.emptyList();
    }

    public List<ArrowBuf> visit(ArrowType.Struct type) {
        return Collections.singletonList(this.maybeImportBitmap((ArrowType)type));
    }

    public List<ArrowBuf> visit(ArrowType.List type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importOffsets((ArrowType)type, 4L));
    }

    public List<ArrowBuf> visit(ArrowType.LargeList type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importOffsets((ArrowType)type, 8L));
    }

    public List<ArrowBuf> visit(ArrowType.FixedSizeList type) {
        return Collections.singletonList(this.maybeImportBitmap((ArrowType)type));
    }

    public List<ArrowBuf> visit(ArrowType.Union type) {
        switch (type.getMode()) {
            case Sparse: {
                return Collections.singletonList(this.importFixedBytes((ArrowType)type, 0, 1L));
            }
            case Dense: {
                return Arrays.asList(this.importFixedBytes((ArrowType)type, 0, 1L), this.importFixedBytes((ArrowType)type, 1, 4L));
            }
        }
        throw new UnsupportedOperationException("Importing buffers for union type: " + String.valueOf(type));
    }

    public List<ArrowBuf> visit(ArrowType.RunEndEncoded type) {
        return List.of();
    }

    public List<ArrowBuf> visit(ArrowType.Map type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importOffsets((ArrowType)type, 4L));
    }

    public List<ArrowBuf> visit(ArrowType.Int type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBits((ArrowType)type, 1, type.getBitWidth()));
    }

    public List<ArrowBuf> visit(ArrowType.FloatingPoint type) {
        switch (type.getPrecision()) {
            case HALF: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 2L));
            }
            case SINGLE: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 4L));
            }
            case DOUBLE: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
            }
        }
        throw new UnsupportedOperationException("Importing buffers for type: " + String.valueOf(type));
    }

    public List<ArrowBuf> visit(ArrowType.Utf8 type) {
        try (ArrowBuf offsets = this.importOffsets((ArrowType)type, 4L);){
            int start = offsets.getInt(0L);
            int end = offsets.getInt((long)this.fieldNode.getLength() * 4L);
            Preconditions.checkState((end >= start ? 1 : 0) != 0, (String)"Offset buffer for type %s is malformed: start: %s, end: %s", (Object)type, (Object)start, (Object)end);
            offsets.getReferenceManager().retain();
            List<ArrowBuf> list = Arrays.asList(this.maybeImportBitmap((ArrowType)type), offsets, this.importData((ArrowType)type, end));
            return list;
        }
    }

    private List<ArrowBuf> visitVariableWidthView(ArrowType type) {
        boolean viewBufferIndex = true;
        int variadicSizeBufferIndex = this.buffers.length - 1;
        long numOfVariadicBuffers = (long)this.buffers.length - 3L;
        long variadicSizeBufferCapacity = numOfVariadicBuffers * 8L;
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        ArrowBuf variadicSizeBuffer = this.importBuffer(type, variadicSizeBufferIndex, variadicSizeBufferCapacity);
        ArrowBuf view = this.importFixedBytes(type, 1, 16L);
        buffers.add(this.maybeImportBitmap(type));
        buffers.add(view);
        int variadicBufferReadOffset = 2;
        int i = 0;
        while ((long)i < numOfVariadicBuffers) {
            long size = variadicSizeBuffer.getLong((long)i * 8L);
            buffers.add(this.importBuffer(type, i + 2, size));
            ++i;
        }
        return buffers;
    }

    public List<ArrowBuf> visit(ArrowType.Utf8View type) {
        return this.visitVariableWidthView((ArrowType)type);
    }

    public List<ArrowBuf> visit(ArrowType.LargeUtf8 type) {
        try (ArrowBuf offsets = this.importOffsets((ArrowType)type, 8L);){
            long start = offsets.getLong(0L);
            long end = offsets.getLong((long)this.fieldNode.getLength() * 8L);
            Preconditions.checkState((end >= start ? 1 : 0) != 0, (String)"Offset buffer for type %s is malformed: start: %s, end: %s", (Object)type, (Object)start, (Object)end);
            offsets.getReferenceManager().retain();
            List<ArrowBuf> list = Arrays.asList(this.maybeImportBitmap((ArrowType)type), offsets, this.importData((ArrowType)type, end));
            return list;
        }
    }

    public List<ArrowBuf> visit(ArrowType.Binary type) {
        try (ArrowBuf offsets = this.importOffsets((ArrowType)type, 4L);){
            int start = offsets.getInt(0L);
            int end = offsets.getInt((long)this.fieldNode.getLength() * 4L);
            Preconditions.checkState((end >= start ? 1 : 0) != 0, (String)"Offset buffer for type %s is malformed: start: %s, end: %s", (Object)type, (Object)start, (Object)end);
            offsets.getReferenceManager().retain();
            List<ArrowBuf> list = Arrays.asList(this.maybeImportBitmap((ArrowType)type), offsets, this.importData((ArrowType)type, end));
            return list;
        }
    }

    public List<ArrowBuf> visit(ArrowType.BinaryView type) {
        return this.visitVariableWidthView((ArrowType)type);
    }

    public List<ArrowBuf> visit(ArrowType.LargeBinary type) {
        try (ArrowBuf offsets = this.importOffsets((ArrowType)type, 8L);){
            long start = offsets.getLong(0L);
            long end = offsets.getLong((long)this.fieldNode.getLength() * 8L);
            Preconditions.checkState((end >= start ? 1 : 0) != 0, (String)"Offset buffer for type %s is malformed: start: %s, end: %s", (Object)type, (Object)start, (Object)end);
            offsets.getReferenceManager().retain();
            List<ArrowBuf> list = Arrays.asList(this.maybeImportBitmap((ArrowType)type), offsets, this.importData((ArrowType)type, end));
            return list;
        }
    }

    public List<ArrowBuf> visit(ArrowType.FixedSizeBinary type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, type.getByteWidth()));
    }

    public List<ArrowBuf> visit(ArrowType.Bool type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBits((ArrowType)type, 1, 1L));
    }

    public List<ArrowBuf> visit(ArrowType.Decimal type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBits((ArrowType)type, 1, type.getBitWidth()));
    }

    public List<ArrowBuf> visit(ArrowType.Date type) {
        switch (type.getUnit()) {
            case DAY: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 4L));
            }
            case MILLISECOND: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
            }
        }
        throw new UnsupportedOperationException("Importing buffers for type: " + String.valueOf(type));
    }

    public List<ArrowBuf> visit(ArrowType.Time type) {
        switch (type.getUnit()) {
            case SECOND: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 4L));
            }
            case MILLISECOND: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 4L));
            }
            case MICROSECOND: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
            }
            case NANOSECOND: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
            }
        }
        throw new UnsupportedOperationException("Importing buffers for type: " + String.valueOf(type));
    }

    public List<ArrowBuf> visit(ArrowType.Timestamp type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
    }

    public List<ArrowBuf> visit(ArrowType.Interval type) {
        switch (type.getUnit()) {
            case YEAR_MONTH: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 4L));
            }
            case DAY_TIME: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
            }
            case MONTH_DAY_NANO: {
                return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 16L));
            }
        }
        throw new UnsupportedOperationException("Importing buffers for type: " + String.valueOf(type));
    }

    public List<ArrowBuf> visit(ArrowType.Duration type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L));
    }

    public List<ArrowBuf> visit(ArrowType.ListView type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 4L), this.importFixedBytes((ArrowType)type, 2, 4L));
    }

    public List<ArrowBuf> visit(ArrowType.LargeListView type) {
        return Arrays.asList(this.maybeImportBitmap((ArrowType)type), this.importFixedBytes((ArrowType)type, 1, 8L), this.importFixedBytes((ArrowType)type, 2, 8L));
    }
}

