/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.CDataDictionaryProvider;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ViewVarBinaryVector;
import org.apache.arrow.vector.ViewVarCharVector;
import org.apache.arrow.vector.compare.Range;
import org.apache.arrow.vector.compare.RangeEqualsVisitor;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

final class StreamTest {
    private RootAllocator allocator = null;

    StreamTest() {
    }

    @BeforeEach
    public void setUp() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testRoundtripInts() throws Exception {
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"ints", (ArrowType)new ArrowType.Int(32, true))));
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            IntVector ints = (IntVector)root.getVector(0);
            VectorUnloader unloader = new VectorUnloader(root);
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setSafe(1, 2);
            ints.setSafe(2, 4);
            ints.setSafe(3, 8);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setNull(1);
            ints.setSafe(2, 4);
            ints.setNull(3);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            this.roundtrip(schema, batches);
        }
    }

    @Test
    public void roundtripStrings() throws Exception {
        Schema schema = new Schema(Arrays.asList(Field.nullable((String)"ints", (ArrowType)new ArrowType.Int(32, true)), Field.nullable((String)"strs", (ArrowType)new ArrowType.Utf8())));
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            IntVector ints = (IntVector)root.getVector(0);
            VarCharVector strs = (VarCharVector)root.getVector(1);
            VectorUnloader unloader = new VectorUnloader(root);
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setSafe(1, 2);
            ints.setSafe(2, 4);
            ints.setSafe(3, 8);
            strs.setSafe(0, "".getBytes(StandardCharsets.UTF_8));
            strs.setSafe(1, "a".getBytes(StandardCharsets.UTF_8));
            strs.setSafe(2, "bc".getBytes(StandardCharsets.UTF_8));
            strs.setSafe(3, "defg".getBytes(StandardCharsets.UTF_8));
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setNull(1);
            ints.setSafe(2, 4);
            ints.setNull(3);
            strs.setSafe(0, "".getBytes(StandardCharsets.UTF_8));
            strs.setNull(1);
            strs.setSafe(2, "bc".getBytes(StandardCharsets.UTF_8));
            strs.setNull(3);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            this.roundtrip(schema, batches);
        }
    }

    @Test
    public void roundtripStringViews() throws Exception {
        Schema schema = new Schema(Arrays.asList(Field.nullable((String)"ints", (ArrowType)new ArrowType.Int(32, true)), Field.nullable((String)"string_views", (ArrowType)new ArrowType.Utf8View())));
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            IntVector ints = (IntVector)root.getVector(0);
            ViewVarCharVector strs = (ViewVarCharVector)root.getVector(1);
            VectorUnloader unloader = new VectorUnloader(root);
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setSafe(1, 2);
            ints.setSafe(2, 4);
            ints.setSafe(3, 8);
            strs.setSafe(0, "".getBytes(StandardCharsets.UTF_8));
            strs.setSafe(1, "a".getBytes(StandardCharsets.UTF_8));
            strs.setSafe(2, "bc1234567890bc".getBytes(StandardCharsets.UTF_8));
            strs.setSafe(3, "defg1234567890defg".getBytes(StandardCharsets.UTF_8));
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setNull(1);
            ints.setSafe(2, 4);
            ints.setNull(3);
            strs.setSafe(0, "".getBytes(StandardCharsets.UTF_8));
            strs.setNull(1);
            strs.setSafe(2, "bc1234567890bc".getBytes(StandardCharsets.UTF_8));
            strs.setNull(3);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            this.roundtrip(schema, batches);
        }
    }

    @Test
    public void roundtripBinaryViews() throws Exception {
        Schema schema = new Schema(Arrays.asList(Field.nullable((String)"ints", (ArrowType)new ArrowType.Int(32, true)), Field.nullable((String)"binary_views", (ArrowType)new ArrowType.BinaryView())));
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            IntVector ints = (IntVector)root.getVector(0);
            ViewVarBinaryVector strs = (ViewVarBinaryVector)root.getVector(1);
            VectorUnloader unloader = new VectorUnloader(root);
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setSafe(1, 2);
            ints.setSafe(2, 4);
            ints.setSafe(3, 8);
            strs.setSafe(0, new byte[0]);
            strs.setSafe(1, new byte[]{97});
            strs.setSafe(2, new byte[]{98, 99, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 98, 99});
            strs.setSafe(3, new byte[]{100, 101, 102, 103, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 100, 101, 102, 103});
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            root.allocateNew();
            ints.setSafe(0, 1);
            ints.setNull(1);
            ints.setSafe(2, 4);
            ints.setNull(3);
            strs.setSafe(0, new byte[0]);
            strs.setNull(1);
            strs.setSafe(2, new byte[]{98, 99, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 98, 99});
            strs.setNull(3);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            this.roundtrip(schema, batches);
        }
    }

    @Test
    public void roundtripDictionary() throws Exception {
        ArrowType.Int indexType = new ArrowType.Int(32, true);
        DictionaryEncoding encoding = new DictionaryEncoding(0L, false, indexType);
        Schema schema = new Schema(Collections.singletonList(new Field("dict", new FieldType(true, (ArrowType)indexType, encoding), Collections.emptyList())));
        ArrayList<ArrowRecordBatch> batches = new ArrayList<ArrowRecordBatch>();
        try (CDataDictionaryProvider provider = new CDataDictionaryProvider();
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            VarCharVector dictionary = new VarCharVector("values", (BufferAllocator)this.allocator);
            dictionary.allocateNew();
            dictionary.setSafe(0, "foo".getBytes(StandardCharsets.UTF_8));
            dictionary.setSafe(1, "bar".getBytes(StandardCharsets.UTF_8));
            dictionary.setNull(2);
            dictionary.setValueCount(3);
            provider.put(new Dictionary((FieldVector)dictionary, encoding));
            IntVector encoded = (IntVector)root.getVector(0);
            VectorUnloader unloader = new VectorUnloader(root);
            root.allocateNew();
            encoded.setSafe(0, 0);
            encoded.setSafe(1, 1);
            encoded.setSafe(2, 0);
            encoded.setSafe(3, 2);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            root.allocateNew();
            encoded.setSafe(0, 0);
            encoded.setNull(1);
            encoded.setSafe(2, 1);
            encoded.setNull(3);
            root.setRowCount(4);
            batches.add(unloader.getRecordBatch());
            this.roundtrip(schema, batches, (DictionaryProvider)provider);
        }
    }

    @Test
    public void importReleasedStream() {
        try (ArrowArrayStream stream = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);){
            Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)stream));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Cannot import released ArrowArrayStream");
        }
    }

    @Test
    public void getNextError() throws Exception {
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"ints", (ArrowType)new ArrowType.Int(32, true))));
        ArrayList batches = new ArrayList();
        try (InMemoryArrowReader source = new InMemoryArrowReader((BufferAllocator)this.allocator, schema, batches, (DictionaryProvider)new DictionaryProvider.MapDictionaryProvider(new Dictionary[0])){

            @Override
            public boolean loadNextBatch() throws IOException {
                throw new IOException("Failed to load batch!");
            }
        };
             ArrowArrayStream stream = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);){
            Data.exportArrayStream((BufferAllocator)this.allocator, (ArrowReader)source, (ArrowArrayStream)stream);
            try (ArrowReader reader = Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)stream);){
                Assertions.assertThat((Object)reader.getVectorSchemaRoot().getSchema()).isEqualTo((Object)schema);
                IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> ((ArrowReader)reader).loadNextBatch());
                Assertions.assertThat((Throwable)e).hasMessageContaining("Failed to load batch!");
                Assertions.assertThat((Throwable)e).hasMessageContaining("[errno ");
            }
        }
    }

    @Test
    public void getSchemaError() throws Exception {
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"ints", (ArrowType)new ArrowType.Int(32, true))));
        ArrayList batches = new ArrayList();
        try (InMemoryArrowReader source = new InMemoryArrowReader((BufferAllocator)this.allocator, schema, batches, (DictionaryProvider)new DictionaryProvider.MapDictionaryProvider(new Dictionary[0])){

            @Override
            protected Schema readSchema() {
                throw new IllegalArgumentException("Failed to read schema!");
            }
        };
             ArrowArrayStream stream = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);){
            Data.exportArrayStream((BufferAllocator)this.allocator, (ArrowReader)source, (ArrowArrayStream)stream);
            try (ArrowReader reader = Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)stream);){
                IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> ((ArrowReader)reader).getVectorSchemaRoot());
                Assertions.assertThat((Throwable)e).hasMessageContaining("Failed to read schema!");
                Assertions.assertThat((Throwable)e).hasMessageContaining("[errno ");
            }
        }
    }

    void roundtrip(Schema schema, List<ArrowRecordBatch> batches, DictionaryProvider provider) throws Exception {
        InMemoryArrowReader source = new InMemoryArrowReader((BufferAllocator)this.allocator, schema, batches, provider);
        try (ArrowArrayStream stream = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            VectorLoader loader = new VectorLoader(root);
            Data.exportArrayStream((BufferAllocator)this.allocator, (ArrowReader)source, (ArrowArrayStream)stream);
            try (ArrowReader reader = Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)stream);){
                Assertions.assertThat((Object)reader.getVectorSchemaRoot().getSchema()).isEqualTo((Object)schema);
                for (ArrowRecordBatch arrowRecordBatch : batches) {
                    Assertions.assertThat((boolean)reader.loadNextBatch()).isTrue();
                    loader.load(arrowRecordBatch);
                    Assertions.assertThat((int)reader.getVectorSchemaRoot().getRowCount()).isEqualTo(root.getRowCount());
                    for (int i = 0; i < root.getFieldVectors().size(); ++i) {
                        FieldVector expected = root.getVector(i);
                        FieldVector actual = reader.getVectorSchemaRoot().getVector(i);
                        StreamTest.assertVectorsEqual(expected, actual);
                    }
                }
                Assertions.assertThat((boolean)reader.loadNextBatch()).isFalse();
                Assertions.assertThat((Collection)reader.getDictionaryIds()).isEqualTo((Object)provider.getDictionaryIds());
                for (Map.Entry entry : reader.getDictionaryVectors().entrySet()) {
                    FieldVector expected = provider.lookup(((Long)entry.getKey()).longValue()).getVector();
                    FieldVector actual = ((Dictionary)entry.getValue()).getVector();
                    StreamTest.assertVectorsEqual(expected, actual);
                }
            }
        }
    }

    void roundtrip(Schema schema, List<ArrowRecordBatch> batches) throws Exception {
        this.roundtrip(schema, batches, (DictionaryProvider)new CDataDictionaryProvider());
    }

    private static void assertVectorsEqual(FieldVector expected, FieldVector actual) {
        Assertions.assertThat((Object)actual.getField().getType()).isEqualTo((Object)expected.getField().getType());
        Assertions.assertThat((int)actual.getValueCount()).isEqualTo(expected.getValueCount());
        Range range = new Range(0, 0, expected.getValueCount());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)new RangeEqualsVisitor((ValueVector)expected, (ValueVector)actual).rangeEquals(range)).as("Vectors were not equal.\nExpected: %s\nGot: %s", new Object[]{expected, actual})).isTrue();
    }

    static class InMemoryArrowReader
    extends ArrowReader {
        private final Schema schema;
        private final List<ArrowRecordBatch> batches;
        private final DictionaryProvider provider;
        private int nextBatch;

        InMemoryArrowReader(BufferAllocator allocator, Schema schema, List<ArrowRecordBatch> batches, DictionaryProvider provider) {
            super(allocator);
            this.schema = schema;
            this.batches = batches;
            this.provider = provider;
            this.nextBatch = 0;
        }

        public Dictionary lookup(long id) {
            return this.provider.lookup(id);
        }

        public Set<Long> getDictionaryIds() {
            return this.provider.getDictionaryIds();
        }

        public Map<Long, Dictionary> getDictionaryVectors() {
            return this.getDictionaryIds().stream().collect(Collectors.toMap(Function.identity(), this::lookup));
        }

        public boolean loadNextBatch() throws IOException {
            if (this.nextBatch < this.batches.size()) {
                VectorLoader loader = new VectorLoader(this.getVectorSchemaRoot());
                loader.load(this.batches.get(this.nextBatch++));
                return true;
            }
            return false;
        }

        public long bytesRead() {
            return 0L;
        }

        protected void closeReadSource() throws IOException {
            try {
                AutoCloseables.close(this.batches);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        protected Schema readSchema() {
            return this.schema;
        }
    }
}

