/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.vector.BaseLargeVariableWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.ExtensionTypeVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float2Vector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VariableWidthFieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ViewVarBinaryVector;
import org.apache.arrow.vector.ViewVarCharVector;
import org.apache.arrow.vector.ZeroVector;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.LargeListViewVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.ListViewVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.RunEndEncodedVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.vector.holders.IntervalDayHolder;
import org.apache.arrow.vector.holders.NullableLargeVarBinaryHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.table.Table;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.ExtensionTypeRegistry;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoundtripTest {
    private static final String EMPTY_SCHEMA_PATH = "";
    private RootAllocator allocator = null;
    private BufferAllocator childAllocator = null;

    @BeforeEach
    public void setUp() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
        this.childAllocator = this.allocator.newChildAllocator("child", 0L, Long.MAX_VALUE);
    }

    @AfterEach
    public void tearDown() {
        this.childAllocator.close();
        this.allocator.close();
    }

    FieldVector vectorRoundtrip(FieldVector vector) {
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
            FieldVector fieldVector;
            block26: {
                ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);
                try {
                    try (ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                         ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());){
                        Data.exportVector((BufferAllocator)this.allocator, (FieldVector)vector, null, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
                    }
                    FieldVector imported = Data.importVector((BufferAllocator)this.childAllocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, null);
                    if (!(imported instanceof NullVector)) {
                        Assertions.assertEquals((Object)this.childAllocator, (Object)imported.getAllocator());
                    }
                    TransferPair pair = imported.getTransferPair((BufferAllocator)this.allocator);
                    pair.transfer();
                    fieldVector = (FieldVector)pair.getTo();
                    if (consumerArrowArray == null) break block26;
                }
                catch (Throwable throwable) {
                    if (consumerArrowArray != null) {
                        try {
                            consumerArrowArray.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                consumerArrowArray.close();
            }
            return fieldVector;
        }
    }

    VectorSchemaRoot vectorSchemaRootRoundtrip(VectorSchemaRoot root) {
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
            VectorSchemaRoot vectorSchemaRoot;
            block25: {
                ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);
                try {
                    try (ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                         ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());){
                        Data.exportVectorSchemaRoot((BufferAllocator)this.allocator, (VectorSchemaRoot)root, null, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
                    }
                    vectorSchemaRoot = Data.importVectorSchemaRoot((BufferAllocator)this.allocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, null);
                    if (consumerArrowArray == null) break block25;
                }
                catch (Throwable throwable) {
                    if (consumerArrowArray != null) {
                        try {
                            consumerArrowArray.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                consumerArrowArray.close();
            }
            return vectorSchemaRoot;
        }
    }

    boolean roundtrip(FieldVector vector, Class<?> clazz) {
        List fieldBuffers = vector.getFieldBuffers();
        List orgRefCnts = fieldBuffers.stream().map(buf -> buf.refCnt()).collect(Collectors.toList());
        long orgMemorySize = this.allocator.getAllocatedMemory();
        boolean result = false;
        try (FieldVector imported = this.vectorRoundtrip(vector);){
            Assertions.assertTrue((boolean)clazz.isInstance(imported), (String)String.format("expected %s but was %s", clazz, imported.getClass()));
            result = VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported);
            if (imported instanceof BaseVariableWidthVector || imported instanceof BaseLargeVariableWidthVector) {
                ArrowBuf offsetBuffer = imported.getOffsetBuffer();
                Assertions.assertTrue((offsetBuffer.capacity() > 0L ? 1 : 0) != 0);
                Assertions.assertEquals((int)0, (int)offsetBuffer.getInt(0L));
            }
        }
        IntStream.range(0, orgRefCnts.size()).forEach(i -> {
            ArrowBuf buf = (ArrowBuf)fieldBuffers.get(i);
            Assertions.assertEquals((int)buf.refCnt(), (Integer)((Integer)orgRefCnts.get(i)));
        });
        Assertions.assertEquals((long)orgMemorySize, (long)this.allocator.getAllocatedMemory());
        return result;
    }

    @Test
    public void testBitVector() {
        BitVector imported;
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);){
            vector.allocateNew(1024);
            vector.setValueCount(1024);
            vector.set(0, 1);
            vector.set(1, 0);
            vector.set(100, 0);
            vector.set(1022, 1);
            vector.setValueCount(1024);
            imported = (BitVector)this.vectorRoundtrip((FieldVector)vector);
            Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported));
        }
        Assertions.assertEquals((int)1, (int)imported.get(0));
        Assertions.assertEquals((int)0, (int)imported.get(1));
        Assertions.assertEquals((int)0, (int)imported.get(100));
        Assertions.assertEquals((int)1, (int)imported.get(1022));
        Assertions.assertEquals((int)1020, (int)imported.getNullCount());
        imported.close();
    }

    @Test
    public void testIntVector() {
        IntVector imported;
        try (IntVector vector = new IntVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vector, (Integer[])new Integer[]{1, 2, 3, null});
            imported = (IntVector)this.vectorRoundtrip((FieldVector)vector);
            Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported));
        }
        Assertions.assertEquals((int)1, (int)imported.get(0));
        Assertions.assertEquals((int)2, (int)imported.get(1));
        Assertions.assertEquals((int)3, (int)imported.get(2));
        Assertions.assertEquals((int)4, (int)imported.getValueCount());
        Assertions.assertEquals((int)1, (int)imported.getNullCount());
        imported.close();
    }

    @Test
    public void testBigIntVector() {
        BigIntVector imported;
        try (BigIntVector vector = new BigIntVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((BigIntVector)vector, (Long[])new Long[]{1L, 2L, 3L, null});
            imported = (BigIntVector)this.vectorRoundtrip((FieldVector)vector);
            Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported));
        }
        Assertions.assertEquals((long)1L, (long)imported.get(0));
        Assertions.assertEquals((long)2L, (long)imported.get(1));
        Assertions.assertEquals((long)3L, (long)imported.get(2));
        Assertions.assertEquals((int)4, (int)imported.getValueCount());
        Assertions.assertEquals((int)1, (int)imported.getNullCount());
        imported.close();
    }

    @Test
    public void testDateDayVector() {
        DateDayVector imported;
        try (DateDayVector vector = new DateDayVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((DateDayVector)vector, (Integer[])new Integer[]{1, 2, 3, null});
            imported = (DateDayVector)this.vectorRoundtrip((FieldVector)vector);
            Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported));
        }
        Assertions.assertEquals((int)1, (int)imported.get(0));
        Assertions.assertEquals((int)2, (int)imported.get(1));
        Assertions.assertEquals((int)3, (int)imported.get(2));
        Assertions.assertEquals((int)4, (int)imported.getValueCount());
        Assertions.assertEquals((int)1, (int)imported.getNullCount());
        imported.close();
    }

    @Test
    public void testDateMilliVector() {
        DateMilliVector imported;
        try (DateMilliVector vector = new DateMilliVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((DateMilliVector)vector, (Long[])new Long[]{1L, 2L, 3L, null});
            imported = (DateMilliVector)this.vectorRoundtrip((FieldVector)vector);
            Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported));
        }
        Assertions.assertEquals((long)1L, (long)imported.get(0));
        Assertions.assertEquals((long)2L, (long)imported.get(1));
        Assertions.assertEquals((long)3L, (long)imported.get(2));
        Assertions.assertEquals((int)4, (int)imported.getValueCount());
        Assertions.assertEquals((int)1, (int)imported.getNullCount());
        imported.close();
    }

    @Test
    public void testDecimalVector() {
        try (DecimalVector vector = new DecimalVector("v", (BufferAllocator)this.allocator, 1, 1);){
            ValueVectorDataPopulator.setVector((DecimalVector)vector, (Long[])new Long[]{1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, DecimalVector.class));
        }
    }

    @Test
    public void testDurationVector() {
        for (TimeUnit unit : TimeUnit.values()) {
            FieldType fieldType = FieldType.nullable((ArrowType)new ArrowType.Duration(unit));
            try (DurationVector vector = new DurationVector("v", fieldType, (BufferAllocator)this.allocator);){
                ValueVectorDataPopulator.setVector((DurationVector)vector, (Long[])new Long[]{1L, 2L, 3L, null});
                Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, DurationVector.class));
            }
        }
    }

    @Test
    public void testZeroVectorEquals() {
        try (ZeroVector vector = new ZeroVector();){
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, NullVector.class));
        }
    }

    @Test
    public void testFixedSizeBinaryVector() {
        try (FixedSizeBinaryVector vector = new FixedSizeBinaryVector("v", (BufferAllocator)this.allocator, 2);){
            ValueVectorDataPopulator.setVector((FixedSizeBinaryVector)vector, (byte[][])new byte[][]{{0, 1}, {2, 3}});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, FixedSizeBinaryVector.class));
        }
    }

    @Test
    public void testFloat2Vector() {
        try (Float2Vector vector = new Float2Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((Float2Vector)vector, (Float[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, Float2Vector.class));
        }
    }

    @Test
    public void testFloat4Vector() {
        try (Float4Vector vector = new Float4Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((Float4Vector)vector, (Float[])new Float[]{Float.valueOf(0.1f), Float.valueOf(0.2f), Float.valueOf(0.3f), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, Float4Vector.class));
        }
    }

    @Test
    public void testFloat8Vector() {
        try (Float8Vector vector = new Float8Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((Float8Vector)vector, (Double[])new Double[]{0.1, 0.2, 0.3, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, Float8Vector.class));
        }
    }

    @Test
    public void testIntervalDayVector() {
        try (IntervalDayVector vector = new IntervalDayVector("v", (BufferAllocator)this.allocator);){
            IntervalDayHolder value = new IntervalDayHolder();
            value.days = 5;
            value.milliseconds = 100;
            ValueVectorDataPopulator.setVector((IntervalDayVector)vector, (IntervalDayHolder[])new IntervalDayHolder[]{value, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, IntervalDayVector.class));
        }
    }

    @Test
    public void testIntervalYearVector() {
        try (IntervalYearVector vector = new IntervalYearVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((IntervalYearVector)vector, (Integer[])new Integer[]{1990, 2000, 2010, 2020, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, IntervalYearVector.class));
        }
    }

    @Test
    public void testSmallIntVector() {
        try (SmallIntVector vector = new SmallIntVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((SmallIntVector)vector, (Short[])new Short[]{(short)0, (short)256, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, SmallIntVector.class));
        }
    }

    @Test
    public void testTimeMicroVector() {
        try (TimeMicroVector vector = new TimeMicroVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeMicroVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeMicroVector.class));
        }
    }

    @Test
    public void testTimeMilliVector() {
        try (TimeMilliVector vector = new TimeMilliVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeMilliVector)vector, (Integer[])new Integer[]{0, 1, 2, 3, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeMilliVector.class));
        }
    }

    @Test
    public void testTimeNanoVector() {
        try (TimeNanoVector vector = new TimeNanoVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeNanoVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeNanoVector.class));
        }
    }

    @Test
    public void testTimeSecVector() {
        try (TimeSecVector vector = new TimeSecVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeSecVector)vector, (Integer[])new Integer[]{0, 1, 2, 3, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeSecVector.class));
        }
    }

    @Test
    public void testTimeStampMicroTZVector() {
        try (TimeStampMicroTZVector vector = new TimeStampMicroTZVector("v", (BufferAllocator)this.allocator, "UTC");){
            ValueVectorDataPopulator.setVector((TimeStampMicroTZVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampMicroTZVector.class));
        }
    }

    @Test
    public void testTimeStampMicroVector() {
        try (TimeStampMicroVector vector = new TimeStampMicroVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeStampMicroVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampMicroVector.class));
        }
    }

    @Test
    public void testTimeStampMilliTZVector() {
        try (TimeStampMilliTZVector vector = new TimeStampMilliTZVector("v", (BufferAllocator)this.allocator, "UTC");){
            ValueVectorDataPopulator.setVector((TimeStampMilliTZVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampMilliTZVector.class));
        }
    }

    @Test
    public void testTimeStampMilliVector() {
        try (TimeStampMilliVector vector = new TimeStampMilliVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeStampMilliVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampMilliVector.class));
        }
    }

    @Test
    public void testTimeTimeStampNanoTZVector() {
        try (TimeStampNanoTZVector vector = new TimeStampNanoTZVector("v", (BufferAllocator)this.allocator, "UTC");){
            ValueVectorDataPopulator.setVector((TimeStampNanoTZVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampNanoTZVector.class));
        }
    }

    @Test
    public void testTimeStampNanoVector() {
        try (TimeStampNanoVector vector = new TimeStampNanoVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeStampNanoVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampNanoVector.class));
        }
    }

    @Test
    public void testTimeStampSecTZVector() {
        try (TimeStampSecTZVector vector = new TimeStampSecTZVector("v", (BufferAllocator)this.allocator, "UTC");){
            ValueVectorDataPopulator.setVector((TimeStampSecTZVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampSecTZVector.class));
        }
    }

    @Test
    public void testTimeStampSecVector() {
        try (TimeStampSecVector vector = new TimeStampSecVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TimeStampSecVector)vector, (Long[])new Long[]{0L, 1L, 2L, 3L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TimeStampSecVector.class));
        }
    }

    @Test
    public void testTinyIntVector() {
        try (TinyIntVector vector = new TinyIntVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((TinyIntVector)vector, (Byte[])new Byte[]{(byte)0, (byte)1, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, TinyIntVector.class));
        }
    }

    @Test
    public void testUInt1Vector() {
        try (UInt1Vector vector = new UInt1Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((UInt1Vector)vector, (Byte[])new Byte[]{(byte)0, (byte)1, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, UInt1Vector.class));
        }
    }

    @Test
    public void testUInt2Vector() {
        try (UInt2Vector vector = new UInt2Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((UInt2Vector)vector, (Character[])new Character[]{Character.valueOf('0'), Character.valueOf('1'), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, UInt2Vector.class));
        }
    }

    @Test
    public void testUInt4Vector() {
        try (UInt4Vector vector = new UInt4Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((UInt4Vector)vector, (Integer[])new Integer[]{0, 1, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, UInt4Vector.class));
        }
    }

    @Test
    public void testUInt8Vector() {
        try (UInt8Vector vector = new UInt8Vector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((UInt8Vector)vector, (Long[])new Long[]{0L, 1L, null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, UInt8Vector.class));
        }
    }

    @Test
    public void testNullVector() {
        try (NullVector vector = new NullVector("v", 1024);){
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, NullVector.class));
        }
    }

    @Test
    public void testVarBinaryVector() {
        try (VarBinaryVector vector = new VarBinaryVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((VarBinaryVector)vector, (byte[][])new byte[][]{"abc".getBytes(StandardCharsets.UTF_8), "def".getBytes(StandardCharsets.UTF_8), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, VarBinaryVector.class));
        }
    }

    @Test
    public void testViewVector() {
        try (ViewVarCharVector vector = new ViewVarCharVector("v1", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((VariableWidthFieldVector)vector, (byte[][])new byte[][]{"abc".getBytes(StandardCharsets.UTF_8), "def".getBytes(StandardCharsets.UTF_8), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ViewVarCharVector.class));
        }
        vector = new ViewVarCharVector("v2", (BufferAllocator)this.allocator);
        try {
            ValueVectorDataPopulator.setVector((VariableWidthFieldVector)vector, (byte[][])new byte[][]{"01234567890123".getBytes(StandardCharsets.UTF_8), "01234567890123567".getBytes(StandardCharsets.UTF_8), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ViewVarCharVector.class));
        }
        finally {
            vector.close();
        }
        vector = new ViewVarBinaryVector("v3", (BufferAllocator)this.allocator);
        try {
            ValueVectorDataPopulator.setVector((VariableWidthFieldVector)vector, (byte[][])new byte[][]{"abc".getBytes(StandardCharsets.UTF_8), "def".getBytes(StandardCharsets.UTF_8), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ViewVarBinaryVector.class));
        }
        finally {
            vector.close();
        }
        vector = new ViewVarBinaryVector("v4", (BufferAllocator)this.allocator);
        try {
            ValueVectorDataPopulator.setVector((VariableWidthFieldVector)vector, (byte[][])new byte[][]{"01234567890123".getBytes(StandardCharsets.UTF_8), "01234567890123567".getBytes(StandardCharsets.UTF_8), null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ViewVarBinaryVector.class));
        }
        finally {
            vector.close();
        }
        ArrayList<byte[]> byteArrayList = new ArrayList<byte[]>();
        for (int i = 1; i <= 500; ++i) {
            StringBuilder sb = new StringBuilder(i);
            for (int j = 0; j < i; ++j) {
                sb.append(j);
            }
            byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            byteArrayList.add(bytes);
        }
        try (ViewVarCharVector vector = new ViewVarCharVector("v5", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((VariableWidthFieldVector)vector, (byte[][])((byte[][])byteArrayList.toArray((T[])new byte[0][])));
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ViewVarCharVector.class));
        }
        vector = new ViewVarBinaryVector("v6", (BufferAllocator)this.allocator);
        try {
            ValueVectorDataPopulator.setVector((VariableWidthFieldVector)vector, (byte[][])((byte[][])byteArrayList.toArray((T[])new byte[0][])));
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ViewVarBinaryVector.class));
        }
        finally {
            vector.close();
        }
    }

    @Test
    public void testVarCharVector() {
        try (VarCharVector vector = new VarCharVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((VarCharVector)vector, (String[])new String[]{"abc", "def", null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, VarCharVector.class));
        }
    }

    @Test
    public void testEmptyVarCharVector() {
        try (VarCharVector vector = new VarCharVector("v", (BufferAllocator)this.allocator);){
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, VarCharVector.class));
        }
    }

    @Test
    public void testLargeVarBinaryVector() {
        try (LargeVarBinaryVector vector = new LargeVarBinaryVector(EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);){
            vector.allocateNew(5L, 1);
            NullableLargeVarBinaryHolder nullHolder = new NullableLargeVarBinaryHolder();
            nullHolder.isSet = 0;
            NullableLargeVarBinaryHolder binHolder = new NullableLargeVarBinaryHolder();
            binHolder.isSet = 1;
            String str = "hello world";
            try (ArrowBuf buf = this.allocator.buffer(16L);){
                buf.setBytes(0L, str.getBytes(StandardCharsets.UTF_8));
                binHolder.start = 0L;
                binHolder.end = str.length();
                binHolder.buffer = buf;
                vector.setSafe(0, binHolder);
                vector.setSafe(1, nullHolder);
                Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, LargeVarBinaryVector.class));
            }
        }
    }

    @Test
    public void testLargeVarCharVector() {
        try (LargeVarCharVector vector = new LargeVarCharVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((LargeVarCharVector)vector, (String[])new String[]{"abc", "def", null});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, LargeVarCharVector.class));
        }
    }

    @Test
    public void testEmptyLargeVarCharVector() {
        try (LargeVarCharVector vector = new LargeVarCharVector("v", (BufferAllocator)this.allocator);){
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, LargeVarCharVector.class));
        }
    }

    @Test
    public void testListVector() {
        try (ListVector vector = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((ListVector)vector, (List[])new List[]{Arrays.stream(new int[]{1, 2}).boxed().collect(Collectors.toList()), Arrays.stream(new int[]{3, 4}).boxed().collect(Collectors.toList()), new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ListVector.class));
        }
    }

    @Test
    public void testEmptyListVector() {
        try (ListVector vector = ListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((ListVector)vector, (List[])new List[]{new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ListVector.class));
        }
    }

    @Test
    public void testLargeListVector() {
        try (LargeListVector vector = LargeListVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((LargeListVector)vector, (List[])new List[]{Arrays.stream(new int[]{1, 2}).boxed().collect(Collectors.toList()), Arrays.stream(new int[]{3, 4}).boxed().collect(Collectors.toList()), new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, LargeListVector.class));
        }
    }

    @Test
    public void testFixedSizeListVector() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"v", (int)2, (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((FixedSizeListVector)vector, (List[])new List[]{Arrays.stream(new int[]{1, 2}).boxed().collect(Collectors.toList()), Arrays.stream(new int[]{3, 4}).boxed().collect(Collectors.toList())});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, FixedSizeListVector.class));
        }
    }

    @Test
    public void testListViewVector() {
        try (ListViewVector vector = ListViewVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((ListViewVector)vector, (List[])new List[]{Arrays.stream(new int[]{1, 2}).boxed().collect(Collectors.toList()), Arrays.stream(new int[]{3, 4}).boxed().collect(Collectors.toList()), new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ListViewVector.class));
        }
    }

    @Test
    public void testEmptyListViewVector() {
        try (ListViewVector vector = ListViewVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((ListViewVector)vector, (List[])new List[]{new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, ListViewVector.class));
        }
    }

    @Test
    public void testLargeListViewVector() {
        try (LargeListViewVector vector = LargeListViewVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((LargeListViewVector)vector, (List[])new List[]{Arrays.stream(new int[]{1, 2}).boxed().collect(Collectors.toList()), Arrays.stream(new int[]{3, 4}).boxed().collect(Collectors.toList()), new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, LargeListViewVector.class));
        }
    }

    @Test
    public void testEmptyLargeListViewVector() {
        try (LargeListViewVector vector = LargeListViewVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((LargeListViewVector)vector, (List[])new List[]{new ArrayList()});
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, LargeListViewVector.class));
        }
    }

    @Test
    public void testMapVector() {
        int count = 5;
        try (MapVector vector = MapVector.empty((String)"v", (BufferAllocator)this.allocator, (boolean)false);){
            vector.allocateNew();
            UnionMapWriter mapWriter = vector.getWriter();
            for (int i = 0; i < count; ++i) {
                mapWriter.startMap();
                for (int j = 0; j < i + 1; ++j) {
                    mapWriter.startEntry();
                    mapWriter.key().bigInt().writeBigInt((long)j);
                    mapWriter.value().integer().writeInt(j);
                    mapWriter.endEntry();
                }
                mapWriter.endMap();
            }
            mapWriter.setValueCount(count);
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, MapVector.class));
        }
    }

    @Test
    public void testUnionVector() {
        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
        uInt4Holder.value = 100;
        uInt4Holder.isSet = 1;
        try (UnionVector vector = UnionVector.empty((String)"v", (BufferAllocator)this.allocator);){
            vector.allocateNew();
            vector.setType(0, Types.MinorType.UINT4);
            vector.setSafe(0, uInt4Holder);
            vector.setType(2, Types.MinorType.UINT4);
            vector.setSafe(2, uInt4Holder);
            vector.setValueCount(4);
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, UnionVector.class));
        }
    }

    @Test
    public void testStructVector() {
        try (StructVector vector = StructVector.empty((String)"v", (BufferAllocator)this.allocator);){
            HashMap data = new HashMap();
            data.put("col_1", Arrays.stream(new int[]{1, 2}).boxed().collect(Collectors.toList()));
            data.put("col_2", Arrays.stream(new int[]{3, 4}).boxed().collect(Collectors.toList()));
            ValueVectorDataPopulator.setVector((StructVector)vector, data);
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, StructVector.class));
        }
    }

    @Test
    public void testRunEndEncodedVector() {
        try (RunEndEncodedVector vector = RunEndEncodedVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((RunEndEncodedVector)vector, List.of(Integer.valueOf(1), Integer.valueOf(3)), List.of(Integer.valueOf(1), Integer.valueOf(2)));
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, RunEndEncodedVector.class));
        }
    }

    @Test
    public void testEmptyRunEndEncodedVector() {
        try (RunEndEncodedVector vector = RunEndEncodedVector.empty((String)"v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((RunEndEncodedVector)vector, List.of(), List.of());
            Assertions.assertTrue((boolean)this.roundtrip((FieldVector)vector, RunEndEncodedVector.class));
        }
    }

    @Test
    public void testExtensionTypeVector() {
        ExtensionTypeRegistry.register((ArrowType.ExtensionType)new UuidType());
        Schema schema = new Schema(Collections.singletonList(Field.nullable((String)"a", (ArrowType)new UuidType())));
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            UUID u1 = UUID.randomUUID();
            UUID u2 = UUID.randomUUID();
            UuidVector vector = (UuidVector)root.getVector("a");
            vector.setValueCount(2);
            vector.set(0, u1);
            vector.set(1, u2);
            root.setRowCount(2);
            VectorSchemaRoot importedRoot = this.vectorSchemaRootRoundtrip(root);
            Assertions.assertEquals((Object)root.getSchema(), (Object)importedRoot.getSchema());
            Field field = (Field)importedRoot.getSchema().getFields().get(0);
            UuidType expectedType = new UuidType();
            Assertions.assertEquals(field.getMetadata().get("ARROW:extension:name"), (Object)expectedType.extensionName());
            Assertions.assertEquals(field.getMetadata().get("ARROW:extension:metadata"), (Object)expectedType.serialize());
            UuidVector deserialized = (UuidVector)((Object)importedRoot.getFieldVectors().get(0));
            Assertions.assertEquals((int)vector.getValueCount(), (int)deserialized.getValueCount());
            for (int i = 0; i < vector.getValueCount(); ++i) {
                Assertions.assertEquals((Object)vector.isNull(i), (Object)deserialized.isNull(i));
                if (vector.isNull(i)) continue;
                Assertions.assertEquals((Object)vector.getObject(i), (Object)deserialized.getObject(i));
            }
            importedRoot.close();
        }
    }

    @Test
    public void testVectorSchemaRoot() {
        VectorSchemaRoot imported;
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);
             ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);){
            try (VectorSchemaRoot vsr = this.createTestVSR();
                 ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                 ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());){
                Data.exportVectorSchemaRoot((BufferAllocator)this.allocator, (VectorSchemaRoot)vsr, null, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
            }
            imported = Data.importVectorSchemaRoot((BufferAllocator)this.allocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, null);
        }
        try (VectorSchemaRoot original = this.createTestVSR();){
            Assertions.assertTrue((boolean)imported.equals(original));
        }
        imported.close();
    }

    @Test
    public void testTable() {
        VectorSchemaRoot imported;
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);
             ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);){
            try (VectorSchemaRoot vsr = this.createTestVSR();
                 Table table = new Table(vsr);
                 ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                 ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());){
                Data.exportTable((BufferAllocator)this.allocator, (Table)table, null, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
            }
            imported = Data.importVectorSchemaRoot((BufferAllocator)this.allocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, null);
        }
        try (VectorSchemaRoot original = this.createTestVSR();){
            Assertions.assertTrue((boolean)imported.equals(original));
        }
        imported.close();
    }

    @Test
    public void testVectorSchemaRootWithDuplicatedFieldNames() {
        VectorSchemaRoot imported;
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);
             ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);){
            try (VectorSchemaRoot testVSR1 = this.createTestVSR();
                 VectorSchemaRoot testVSR2 = this.createTestVSR();){
                VectorSchemaRoot vsr = new VectorSchemaRoot((Iterable)Stream.concat(testVSR1.getFieldVectors().stream(), testVSR2.getFieldVectors().stream()).collect(Collectors.toList()));
                try (ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                     ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());){
                    Data.exportVectorSchemaRoot((BufferAllocator)this.allocator, (VectorSchemaRoot)vsr, null, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
                }
            }
            imported = Data.importVectorSchemaRoot((BufferAllocator)this.allocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, null);
        }
        try (VectorSchemaRoot testVSR1 = this.createTestVSR();
             VectorSchemaRoot testVSR2 = this.createTestVSR();){
            VectorSchemaRoot original = new VectorSchemaRoot((Iterable)Stream.concat(testVSR1.getFieldVectors().stream(), testVSR2.getFieldVectors().stream()).collect(Collectors.toList()));
            Assertions.assertTrue((boolean)imported.equals(original));
        }
        imported.close();
    }

    @Test
    public void testSchema() {
        Field decimalField = new Field("inner1", FieldType.nullable((ArrowType)new ArrowType.Decimal(19, 4, 128)), null);
        Field strField = new Field("inner2", FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
        Field itemField = new Field("col1", FieldType.nullable((ArrowType)new ArrowType.Struct()), Arrays.asList(decimalField, strField));
        Field intField = new Field("col2", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
        Schema schema = new Schema(Arrays.asList(itemField, intField));
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
            try (ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());){
                Data.exportSchema((BufferAllocator)this.allocator, (Schema)schema, null, (ArrowSchema)arrowSchema);
            }
            Schema importedSchema = Data.importSchema((BufferAllocator)this.allocator, (ArrowSchema)consumerArrowSchema, null);
            Assertions.assertEquals((Object)schema.toJson(), (Object)importedSchema.toJson());
        }
    }

    @Test
    public void testImportedBufferAsNioBuffer() {
        IntVector imported;
        try (IntVector vector = new IntVector("v", (BufferAllocator)this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vector, (Integer[])new Integer[]{1, 2, 3, null});
            imported = (IntVector)this.vectorRoundtrip((FieldVector)vector);
        }
        ArrowBuf dataBuffer = imported.getDataBuffer();
        ByteBuffer nioBuffer = dataBuffer.nioBuffer().asReadOnlyBuffer();
        nioBuffer.order(ByteOrder.nativeOrder());
        Assertions.assertEquals((int)1, (int)nioBuffer.getInt(0));
        Assertions.assertEquals((int)2, (int)nioBuffer.getInt(4));
        Assertions.assertEquals((int)3, (int)nioBuffer.getInt(8));
        imported.close();
    }

    @Test
    public void testImportReleasedArray() {
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);
             ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);){
            try (ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                 ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());
                 NullVector vector = new NullVector();){
                Data.exportVector((BufferAllocator)this.allocator, (FieldVector)vector, null, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
            }
            consumerArrowArray.markReleased();
            Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> Data.importVector((BufferAllocator)this.allocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, null));
            Assertions.assertEquals((Object)"Cannot import released ArrowArray", (Object)e.getMessage());
        }
    }

    private VectorSchemaRoot createTestVSR() {
        BitVector bitVector = new BitVector("boolean", (BufferAllocator)this.allocator);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key", "value");
        FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Utf8.INSTANCE, null, metadata);
        VarCharVector varCharVector = new VarCharVector("varchar", fieldType, (BufferAllocator)this.allocator);
        bitVector.allocateNew();
        varCharVector.allocateNew();
        for (int i = 0; i < 10; ++i) {
            bitVector.setSafe(i, i % 2 == 0 ? 0 : 1);
            varCharVector.setSafe(i, ("test" + i).getBytes(StandardCharsets.UTF_8));
        }
        bitVector.setValueCount(10);
        varCharVector.setValueCount(10);
        List<Field> fields = Arrays.asList(bitVector.getField(), varCharVector.getField());
        List<FieldVector> vectors = Arrays.asList(bitVector, varCharVector);
        return new VectorSchemaRoot(fields, vectors);
    }

    static class UuidType
    extends ArrowType.ExtensionType {
        UuidType() {
        }

        public ArrowType storageType() {
            return new ArrowType.FixedSizeBinary(16);
        }

        public String extensionName() {
            return "uuid";
        }

        public boolean extensionEquals(ArrowType.ExtensionType other) {
            return other instanceof UuidType;
        }

        public ArrowType deserialize(ArrowType storageType, String serializedData) {
            if (!storageType.equals(this.storageType())) {
                throw new UnsupportedOperationException("Cannot construct UuidType from underlying type " + String.valueOf(storageType));
            }
            return new UuidType();
        }

        public String serialize() {
            return RoundtripTest.EMPTY_SCHEMA_PATH;
        }

        public FieldVector getNewVector(String name, FieldType fieldType, BufferAllocator allocator) {
            return new UuidVector(name, allocator, new FixedSizeBinaryVector(name, allocator, 16));
        }
    }

    static class UuidVector
    extends ExtensionTypeVector<FixedSizeBinaryVector> {
        public UuidVector(String name, BufferAllocator allocator, FixedSizeBinaryVector underlyingVector) {
            super(name, allocator, (ValueVector)underlyingVector);
        }

        public UUID getObject(int index) {
            ByteBuffer bb = ByteBuffer.wrap(((FixedSizeBinaryVector)this.getUnderlyingVector()).getObject(index));
            return new UUID(bb.getLong(), bb.getLong());
        }

        public int hashCode(int index) {
            return this.hashCode(index, null);
        }

        public int hashCode(int index, ArrowBufHasher hasher) {
            return ((FixedSizeBinaryVector)this.getUnderlyingVector()).hashCode(index, hasher);
        }

        public void set(int index, UUID uuid) {
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            ((FixedSizeBinaryVector)this.getUnderlyingVector()).set(index, bb.array());
        }
    }
}

