/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.c.NativeUtil;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.memory.util.MemoryUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NativeUtilTest {
    private RootAllocator allocator = null;

    @BeforeEach
    public void setUp() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testString() {
        String javaString = "abc";
        byte[] nativeString = new byte[]{97, 98, 99, 0};
        try (ArrowBuf buffer = NativeUtil.toNativeString((BufferAllocator)this.allocator, (String)javaString);){
            int totalSize = LargeMemoryUtil.checkedCastToInt((long)buffer.readableBytes());
            ByteBuffer reader = MemoryUtil.directBuffer((long)buffer.memoryAddress(), (int)totalSize).order(ByteOrder.nativeOrder());
            byte[] result = new byte[totalSize];
            reader.get(result);
            Assertions.assertArrayEquals((byte[])nativeString, (byte[])result);
            Assertions.assertEquals((Object)javaString, (Object)NativeUtil.toJavaString((long)buffer.memoryAddress()));
        }
    }

    @Test
    public void testToJavaArray() {
        long[] nativeArray = new long[]{1L, 2L, 3L};
        try (ArrowBuf buffer = this.allocator.buffer(8L * (long)nativeArray.length, null);){
            for (long value : nativeArray) {
                buffer.writeLong(value);
            }
            long[] actual = NativeUtil.toJavaArray((long)buffer.memoryAddress(), (int)nativeArray.length);
            Assertions.assertArrayEquals((long[])nativeArray, (long[])actual);
        }
    }

    @Test
    public void testToZeroJavaArray() {
        long[] actual = NativeUtil.toJavaArray((long)-559038737L, (int)0);
        Assertions.assertEquals((int)0, (int)actual.length);
    }
}

