/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.c.Metadata;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.memory.util.MemoryUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MetadataTest {
    private RootAllocator allocator = null;
    private static Map<String, String> metadata;
    private static byte[] encoded;

    @BeforeAll
    static void beforeAll() {
        metadata = new HashMap<String, String>();
        metadata.put("key1", "");
        metadata.put("key2", "bar");
        encoded = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? new byte[]{2, 0, 0, 0, 4, 0, 0, 0, 107, 101, 121, 49, 0, 0, 0, 0, 4, 0, 0, 0, 107, 101, 121, 50, 3, 0, 0, 0, 98, 97, 114} : new byte[]{0, 0, 0, 2, 0, 0, 0, 4, 107, 101, 121, 49, 0, 0, 0, 0, 0, 0, 0, 4, 107, 101, 121, 50, 0, 0, 0, 3, 98, 97, 114};
    }

    @BeforeEach
    public void setUp() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void testEncode() {
        try (ArrowBuf buffer = Metadata.encode((BufferAllocator)this.allocator, metadata);){
            int totalSize = LargeMemoryUtil.checkedCastToInt((long)buffer.readableBytes());
            ByteBuffer reader = MemoryUtil.directBuffer((long)buffer.memoryAddress(), (int)totalSize).order(ByteOrder.nativeOrder());
            byte[] result = new byte[totalSize];
            reader.get(result);
            Assertions.assertArrayEquals((byte[])encoded, (byte[])result);
        }
    }

    @Test
    public void testDecode() {
        try (ArrowBuf buffer = this.allocator.buffer(31L);){
            buffer.setBytes(0L, encoded);
            Map decoded = Metadata.decode((long)buffer.memoryAddress());
            Assertions.assertNotNull((Object)decoded);
            Assertions.assertEquals(metadata, (Object)decoded);
        }
    }

    @Test
    public void testEncodeEmpty() {
        HashMap metadata = new HashMap();
        try (ArrowBuf encoded = Metadata.encode((BufferAllocator)this.allocator, metadata);){
            Assertions.assertNull((Object)encoded);
        }
    }

    @Test
    public void testDecodeEmpty() {
        Map decoded = Metadata.decode((long)0L);
        Assertions.assertNull((Object)decoded);
    }
}

