/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import org.apache.arrow.c.Format;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormatTest {
    @Test
    public void testAsString() {
        Assertions.assertEquals((Object)"z", (Object)Format.asString((ArrowType)new ArrowType.Binary()));
        Assertions.assertEquals((Object)"b", (Object)Format.asString((ArrowType)new ArrowType.Bool()));
        Assertions.assertEquals((Object)"tdD", (Object)Format.asString((ArrowType)new ArrowType.Date(DateUnit.DAY)));
        Assertions.assertEquals((Object)"tdm", (Object)Format.asString((ArrowType)new ArrowType.Date(DateUnit.MILLISECOND)));
        Assertions.assertEquals((Object)"d:1,1", (Object)Format.asString((ArrowType)new ArrowType.Decimal(1, 1, 128)));
        Assertions.assertEquals((Object)"d:1,1,1", (Object)Format.asString((ArrowType)new ArrowType.Decimal(1, 1, 1)));
        Assertions.assertEquals((Object)"d:9,1,1", (Object)Format.asString((ArrowType)new ArrowType.Decimal(9, 1, 1)));
        Assertions.assertEquals((Object)"tDs", (Object)Format.asString((ArrowType)new ArrowType.Duration(TimeUnit.SECOND)));
        Assertions.assertEquals((Object)"tDm", (Object)Format.asString((ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND)));
        Assertions.assertEquals((Object)"tDu", (Object)Format.asString((ArrowType)new ArrowType.Duration(TimeUnit.MICROSECOND)));
        Assertions.assertEquals((Object)"tDn", (Object)Format.asString((ArrowType)new ArrowType.Duration(TimeUnit.NANOSECOND)));
        Assertions.assertEquals((Object)"w:1", (Object)Format.asString((ArrowType)new ArrowType.FixedSizeBinary(1)));
        Assertions.assertEquals((Object)"+w:3", (Object)Format.asString((ArrowType)new ArrowType.FixedSizeList(3)));
        Assertions.assertEquals((Object)"e", (Object)Format.asString((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.HALF)));
        Assertions.assertEquals((Object)"f", (Object)Format.asString((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)));
        Assertions.assertEquals((Object)"g", (Object)Format.asString((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)));
        Assertions.assertEquals((Object)"c", (Object)Format.asString((ArrowType)new ArrowType.Int(8, true)));
        Assertions.assertEquals((Object)"C", (Object)Format.asString((ArrowType)new ArrowType.Int(8, false)));
        Assertions.assertEquals((Object)"s", (Object)Format.asString((ArrowType)new ArrowType.Int(16, true)));
        Assertions.assertEquals((Object)"S", (Object)Format.asString((ArrowType)new ArrowType.Int(16, false)));
        Assertions.assertEquals((Object)"i", (Object)Format.asString((ArrowType)new ArrowType.Int(32, true)));
        Assertions.assertEquals((Object)"I", (Object)Format.asString((ArrowType)new ArrowType.Int(32, false)));
        Assertions.assertEquals((Object)"l", (Object)Format.asString((ArrowType)new ArrowType.Int(64, true)));
        Assertions.assertEquals((Object)"L", (Object)Format.asString((ArrowType)new ArrowType.Int(64, false)));
        Assertions.assertEquals((Object)"tiD", (Object)Format.asString((ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME)));
        Assertions.assertEquals((Object)"tiM", (Object)Format.asString((ArrowType)new ArrowType.Interval(IntervalUnit.YEAR_MONTH)));
        Assertions.assertEquals((Object)"Z", (Object)Format.asString((ArrowType)new ArrowType.LargeBinary()));
        Assertions.assertEquals((Object)"+L", (Object)Format.asString((ArrowType)new ArrowType.LargeList()));
        Assertions.assertEquals((Object)"U", (Object)Format.asString((ArrowType)new ArrowType.LargeUtf8()));
        Assertions.assertEquals((Object)"+l", (Object)Format.asString((ArrowType)new ArrowType.List()));
        Assertions.assertEquals((Object)"+m", (Object)Format.asString((ArrowType)new ArrowType.Map(true)));
        Assertions.assertEquals((Object)"n", (Object)Format.asString((ArrowType)new ArrowType.Null()));
        Assertions.assertEquals((Object)"+s", (Object)Format.asString((ArrowType)new ArrowType.Struct()));
        Assertions.assertEquals((Object)"tts", (Object)Format.asString((ArrowType)new ArrowType.Time(TimeUnit.SECOND, 32)));
        Assertions.assertEquals((Object)"ttm", (Object)Format.asString((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)));
        Assertions.assertEquals((Object)"ttu", (Object)Format.asString((ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 64)));
        Assertions.assertEquals((Object)"ttn", (Object)Format.asString((ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 64)));
        Assertions.assertEquals((Object)"tss:Timezone", (Object)Format.asString((ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, "Timezone")));
        Assertions.assertEquals((Object)"tsm:Timezone", (Object)Format.asString((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "Timezone")));
        Assertions.assertEquals((Object)"tsu:Timezone", (Object)Format.asString((ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "Timezone")));
        Assertions.assertEquals((Object)"tsn:Timezone", (Object)Format.asString((ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "Timezone")));
        Assertions.assertEquals((Object)"+us:1,1,1", (Object)Format.asString((ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[]{1, 1, 1})));
        Assertions.assertEquals((Object)"+ud:1,1,1", (Object)Format.asString((ArrowType)new ArrowType.Union(UnionMode.Dense, new int[]{1, 1, 1})));
        Assertions.assertEquals((Object)"u", (Object)Format.asString((ArrowType)new ArrowType.Utf8()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Format.asString((ArrowType)new ArrowType.Int(1, true)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Format.asString((ArrowType)new ArrowType.Time(TimeUnit.SECOND, 1)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Format.asString((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 64)));
    }

    @Test
    public void testAsType() throws IllegalStateException, NumberFormatException, UnsupportedOperationException {
        Assertions.assertTrue((boolean)(Format.asType((String)"n", (long)0L) instanceof ArrowType.Null));
        Assertions.assertTrue((boolean)(Format.asType((String)"b", (long)0L) instanceof ArrowType.Bool));
        Assertions.assertEquals((Object)new ArrowType.Int(8, true), (Object)Format.asType((String)"c", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(8, false), (Object)Format.asType((String)"C", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(16, true), (Object)Format.asType((String)"s", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(16, false), (Object)Format.asType((String)"S", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(32, true), (Object)Format.asType((String)"i", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(32, false), (Object)Format.asType((String)"I", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(64, true), (Object)Format.asType((String)"l", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Int(64, false), (Object)Format.asType((String)"L", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.FloatingPoint(FloatingPointPrecision.HALF), (Object)Format.asType((String)"e", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), (Object)Format.asType((String)"f", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), (Object)Format.asType((String)"g", (long)0L));
        Assertions.assertTrue((boolean)(Format.asType((String)"z", (long)0L) instanceof ArrowType.Binary));
        Assertions.assertTrue((boolean)(Format.asType((String)"Z", (long)0L) instanceof ArrowType.LargeBinary));
        Assertions.assertTrue((boolean)(Format.asType((String)"u", (long)0L) instanceof ArrowType.Utf8));
        Assertions.assertTrue((boolean)(Format.asType((String)"U", (long)0L) instanceof ArrowType.LargeUtf8));
        Assertions.assertEquals((Object)new ArrowType.Date(DateUnit.DAY), (Object)Format.asType((String)"tdD", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Date(DateUnit.MILLISECOND), (Object)Format.asType((String)"tdm", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Time(TimeUnit.SECOND, 32), (Object)Format.asType((String)"tts", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Time(TimeUnit.MILLISECOND, 32), (Object)Format.asType((String)"ttm", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Time(TimeUnit.MICROSECOND, 64), (Object)Format.asType((String)"ttu", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Time(TimeUnit.NANOSECOND, 64), (Object)Format.asType((String)"ttn", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Duration(TimeUnit.SECOND), (Object)Format.asType((String)"tDs", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Duration(TimeUnit.MILLISECOND), (Object)Format.asType((String)"tDm", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Duration(TimeUnit.MICROSECOND), (Object)Format.asType((String)"tDu", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Duration(TimeUnit.NANOSECOND), (Object)Format.asType((String)"tDn", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Interval(IntervalUnit.YEAR_MONTH), (Object)Format.asType((String)"tiM", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Interval(IntervalUnit.DAY_TIME), (Object)Format.asType((String)"tiD", (long)0L));
        Assertions.assertTrue((boolean)(Format.asType((String)"+l", (long)0L) instanceof ArrowType.List));
        Assertions.assertTrue((boolean)(Format.asType((String)"+L", (long)0L) instanceof ArrowType.LargeList));
        Assertions.assertTrue((boolean)(Format.asType((String)"+s", (long)0L) instanceof ArrowType.Struct));
        Assertions.assertEquals((Object)new ArrowType.Map(false), (Object)Format.asType((String)"+m", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Map(true), (Object)Format.asType((String)"+m", (long)4L));
        Assertions.assertEquals((Object)new ArrowType.Decimal(1, 1, 128), (Object)Format.asType((String)"d:1,1", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Decimal(1, 1, 1), (Object)Format.asType((String)"d:1,1,1", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Decimal(9, 1, 1), (Object)Format.asType((String)"d:9,1,1", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.FixedSizeBinary(1), (Object)Format.asType((String)"w:1", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.FixedSizeList(3), (Object)Format.asType((String)"+w:3", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Union(UnionMode.Dense, new int[]{1, 1, 1}), (Object)Format.asType((String)"+ud:1,1,1", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Union(UnionMode.Sparse, new int[]{1, 1, 1}), (Object)Format.asType((String)"+us:1,1,1", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Timestamp(TimeUnit.SECOND, "Timezone"), (Object)Format.asType((String)"tss:Timezone", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "Timezone"), (Object)Format.asType((String)"tsm:Timezone", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "Timezone"), (Object)Format.asType((String)"tsu:Timezone", (long)0L));
        Assertions.assertEquals((Object)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "Timezone"), (Object)Format.asType((String)"tsn:Timezone", (long)0L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Format.asType((String)"Format", (long)0L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> Format.asType((String)":", (long)0L));
        Assertions.assertThrows(NumberFormatException.class, () -> Format.asType((String)"w:1,2,3", (long)0L));
    }
}

