/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import org.apache.arrow.c.Flags;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlagsTest {
    @Test
    public void testForFieldNullableOrderedDict() {
        FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Binary.INSTANCE, new DictionaryEncoding(123L, true, new ArrowType.Int(8, true)));
        Assertions.assertEquals((long)3L, (long)Flags.forField((Field)new Field("Name", fieldType, new ArrayList())));
    }

    @Test
    public void testForFieldOrderedDict() {
        FieldType fieldType = new FieldType(false, (ArrowType)ArrowType.Binary.INSTANCE, new DictionaryEncoding(123L, true, new ArrowType.Int(8, true)));
        Assertions.assertEquals((long)1L, (long)Flags.forField((Field)new Field("Name", fieldType, new ArrayList())));
    }

    @Test
    public void testForFieldNullableDict() {
        FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Binary.INSTANCE, new DictionaryEncoding(123L, false, new ArrowType.Int(8, true)));
        Assertions.assertEquals((long)2L, (long)Flags.forField((Field)new Field("Name", fieldType, new ArrayList())));
    }

    @Test
    public void testForFieldNullable() {
        FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Binary.INSTANCE, null);
        Assertions.assertEquals((long)2L, (long)Flags.forField((Field)new Field("Name", fieldType, new ArrayList())));
    }

    @Test
    public void testForFieldNullableOrderedSortedMap() {
        ArrowType.Map type = new ArrowType.Map(true);
        FieldType fieldType = new FieldType(true, (ArrowType)type, new DictionaryEncoding(123L, true, new ArrowType.Int(8, true)));
        Assertions.assertEquals((long)7L, (long)Flags.forField((Field)new Field("Name", fieldType, new ArrayList())));
    }

    @Test
    public void testForFieldNullableOrderedMap() {
        ArrowType.Map type = new ArrowType.Map(false);
        FieldType fieldType = new FieldType(true, (ArrowType)type, new DictionaryEncoding(123L, true, new ArrowType.Int(8, true)));
        Assertions.assertEquals((long)3L, (long)Flags.forField((Field)new Field("Name", fieldType, new ArrayList())));
    }
}

