/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.CDataDictionaryProvider;
import org.apache.arrow.c.Data;
import org.apache.arrow.c.StructVectorLoader;
import org.apache.arrow.c.StructVectorUnloader;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ViewVarCharVector;
import org.apache.arrow.vector.compare.VectorEqualsVisitor;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DictionaryTest {
    private RootAllocator allocator = null;

    @BeforeEach
    public void setUp() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterEach
    public void tearDown() {
        this.allocator.close();
    }

    void roundtrip(FieldVector vector, DictionaryProvider provider, Class<?> clazz) {
        try (ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);
             ArrowArray consumerArrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);){
            try (ArrowSchema arrowSchema = ArrowSchema.wrap((long)consumerArrowSchema.memoryAddress());
                 ArrowArray arrowArray = ArrowArray.wrap((long)consumerArrowArray.memoryAddress());){
                Data.exportVector((BufferAllocator)this.allocator, (FieldVector)vector, (DictionaryProvider)provider, (ArrowArray)arrowArray, (ArrowSchema)arrowSchema);
            }
            try (CDataDictionaryProvider cDictionaryProvider = new CDataDictionaryProvider();
                 FieldVector imported = Data.importVector((BufferAllocator)this.allocator, (ArrowArray)consumerArrowArray, (ArrowSchema)consumerArrowSchema, (CDataDictionaryProvider)cDictionaryProvider);){
                Assertions.assertTrue((boolean)clazz.isInstance(imported), (String)String.format("expected %s but was %s", clazz, imported.getClass()));
                Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)vector, (ValueVector)imported), (String)"vectors are not equivalent");
                Iterator iterator = cDictionaryProvider.getDictionaryIds().iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    FieldVector exportedDictionaryVector = provider.lookup(id).getVector();
                    FieldVector importedDictionaryVector = cDictionaryProvider.lookup(id).getVector();
                    Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)exportedDictionaryVector, (ValueVector)importedDictionaryVector), (String)String.format("Dictionary vectors for ID %d are not equivalent", id));
                }
            }
        }
    }

    @Test
    public void testWithDictionary() throws Exception {
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        VarCharVector dictVector = new VarCharVector("dict", (BufferAllocator)this.allocator);
        dictVector.allocateNewSafe();
        dictVector.setSafe(0, "aa".getBytes(StandardCharsets.UTF_8));
        dictVector.setSafe(1, "bb".getBytes(StandardCharsets.UTF_8));
        dictVector.setSafe(2, "cc".getBytes(StandardCharsets.UTF_8));
        dictVector.setValueCount(3);
        Dictionary dictionary = new Dictionary((FieldVector)dictVector, new DictionaryEncoding(0L, false, null));
        provider.put(dictionary);
        VarCharVector vector = new VarCharVector("vector", (BufferAllocator)this.allocator);
        vector.allocateNewSafe();
        vector.setSafe(0, "bb".getBytes(StandardCharsets.UTF_8));
        vector.setSafe(1, "bb".getBytes(StandardCharsets.UTF_8));
        vector.setSafe(2, "cc".getBytes(StandardCharsets.UTF_8));
        vector.setSafe(3, "aa".getBytes(StandardCharsets.UTF_8));
        vector.setValueCount(4);
        IntVector encodedVector = (IntVector)DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);
        this.roundtrip((FieldVector)encodedVector, (DictionaryProvider)provider, IntVector.class);
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{vector, encodedVector, dictVector});
    }

    @Test
    public void testRoundtripMultipleBatches() throws IOException {
        try (ArrowStreamReader reader = this.createMultiBatchReader();
             ArrowSchema consumerArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
            reader.loadNextBatch();
            Data.exportSchema((BufferAllocator)this.allocator, (Schema)reader.getVectorSchemaRoot().getSchema(), (DictionaryProvider)reader, (ArrowSchema)consumerArrowSchema);
            try (CDataDictionaryProvider consumerDictionaryProvider = new CDataDictionaryProvider();
                 VectorSchemaRoot consumerRoot = Data.importVectorSchemaRoot((BufferAllocator)this.allocator, (ArrowSchema)consumerArrowSchema, (CDataDictionaryProvider)consumerDictionaryProvider);){
                do {
                    try (ArrowArray consumerArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);){
                        Data.exportVectorSchemaRoot((BufferAllocator)this.allocator, (VectorSchemaRoot)reader.getVectorSchemaRoot(), (DictionaryProvider)reader, (ArrowArray)consumerArray);
                        Data.importIntoVectorSchemaRoot((BufferAllocator)this.allocator, (ArrowArray)consumerArray, (VectorSchemaRoot)consumerRoot, (DictionaryProvider)consumerDictionaryProvider);
                        Assertions.assertTrue((boolean)consumerRoot.equals(reader.getVectorSchemaRoot()), (String)"vector schema roots are not equivalent");
                        Iterator iterator = consumerDictionaryProvider.getDictionaryIds().iterator();
                        while (iterator.hasNext()) {
                            long id = (Long)iterator.next();
                            FieldVector exportedDictionaryVector = reader.lookup(id).getVector();
                            FieldVector importedDictionaryVector = consumerDictionaryProvider.lookup(id).getVector();
                            Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)exportedDictionaryVector, (ValueVector)importedDictionaryVector), (String)String.format("Dictionary vectors for ID %d are not equivalent", id));
                        }
                    }
                } while (reader.loadNextBatch());
            }
        }
    }

    private ArrowStreamReader createMultiBatchReader() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (VarCharVector dictVector = new VarCharVector("dict", (BufferAllocator)this.allocator);
             IntVector vector = new IntVector("foo", (BufferAllocator)this.allocator);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            dictVector.allocateNewSafe();
            dictVector.setSafe(0, "aa".getBytes(StandardCharsets.UTF_8));
            dictVector.setSafe(1, "bb".getBytes(StandardCharsets.UTF_8));
            dictVector.setSafe(2, "cc".getBytes(StandardCharsets.UTF_8));
            dictVector.setSafe(3, "dd".getBytes(StandardCharsets.UTF_8));
            dictVector.setSafe(4, "ee".getBytes(StandardCharsets.UTF_8));
            dictVector.setValueCount(5);
            Dictionary dictionary = new Dictionary((FieldVector)dictVector, new DictionaryEncoding(0L, false, null));
            provider.put(dictionary);
            Schema schema = new Schema(Collections.singletonList(vector.getField()));
            try (VectorSchemaRoot root = new VectorSchemaRoot(schema, Collections.singletonList(vector), vector.getValueCount());
                 ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)provider, Channels.newChannel(os));){
                writer.start();
                vector.setNull(0);
                vector.setSafe(1, 1);
                vector.setSafe(2, 2);
                vector.setNull(3);
                vector.setSafe(4, 1);
                vector.setValueCount(5);
                root.setRowCount(5);
                writer.writeBatch();
                vector.setNull(0);
                vector.setSafe(1, 1);
                vector.setSafe(2, 2);
                vector.setValueCount(3);
                root.setRowCount(3);
                writer.writeBatch();
                vector.setSafe(0, 0);
                vector.setSafe(1, 1);
                vector.setSafe(2, 2);
                vector.setSafe(3, 3);
                vector.setSafe(4, 4);
                vector.setValueCount(5);
                root.setRowCount(5);
                writer.writeBatch();
                writer.end();
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
        return new ArrowStreamReader((InputStream)in, (BufferAllocator)this.allocator);
    }

    private void createStructVector(StructVector vector) {
        ViewVarCharVector child1 = (ViewVarCharVector)vector.addOrGet("f0", FieldType.nullable((ArrowType)Types.MinorType.VIEWVARCHAR.getType()), ViewVarCharVector.class);
        IntVector child2 = (IntVector)vector.addOrGet("f1", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
        child1.allocateNew();
        child1.set(0, "01234567890".getBytes(StandardCharsets.UTF_8));
        child1.set(1, "012345678901234567".getBytes(StandardCharsets.UTF_8));
        vector.setIndexDefined(0);
        child2.allocateNew();
        child2.set(0, 10);
        child2.set(1, 11);
        vector.setIndexDefined(1);
        vector.setValueCount(2);
    }

    private void createStructVectorInline(StructVector vector) {
        ViewVarCharVector child1 = (ViewVarCharVector)vector.addOrGet("f0", FieldType.nullable((ArrowType)Types.MinorType.VIEWVARCHAR.getType()), ViewVarCharVector.class);
        IntVector child2 = (IntVector)vector.addOrGet("f1", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), IntVector.class);
        child1.allocateNew();
        child1.set(0, "012345678".getBytes(StandardCharsets.UTF_8));
        child1.set(1, "01234".getBytes(StandardCharsets.UTF_8));
        vector.setIndexDefined(0);
        child2.allocateNew();
        child2.set(0, 10);
        child2.set(1, 11);
        vector.setIndexDefined(1);
        vector.setValueCount(2);
    }

    @Test
    public void testVectorLoadUnloadOnStructVector() {
        try (StructVector structVector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            this.createStructVector(structVector1);
            Field field1 = structVector1.getField();
            Schema schema = new Schema((Iterable)field1.getChildren());
            StructVectorUnloader vectorUnloader = new StructVectorUnloader(structVector1);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("struct", 0L, Long.MAX_VALUE);){
                Assertions.assertFalse((boolean)recordBatch.getVariadicBufferCounts().isEmpty());
                Assertions.assertEquals((int)1, (int)recordBatch.getVariadicBufferCounts().size());
                Assertions.assertEquals((long)1L, (Long)((Long)recordBatch.getVariadicBufferCounts().get(0)));
                StructVectorLoader vectorLoader = new StructVectorLoader(schema);
                try (StructVector structVector2 = vectorLoader.load(finalVectorsAllocator, recordBatch);){
                    Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)structVector1.getChild("f0"), (ValueVector)structVector2.getChild("f0")), (String)"vectors are not equivalent");
                    Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)structVector1.getChild("f1"), (ValueVector)structVector2.getChild("f1")), (String)"vectors are not equivalent");
                }
            }
        }
    }

    @Test
    public void testVectorLoadUnloadOnStructVectorWithInline() {
        try (StructVector structVector1 = StructVector.empty((String)"struct", (BufferAllocator)this.allocator);){
            this.createStructVectorInline(structVector1);
            Field field1 = structVector1.getField();
            Schema schema = new Schema((Iterable)field1.getChildren());
            StructVectorUnloader vectorUnloader = new StructVectorUnloader(structVector1);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("struct", 0L, Long.MAX_VALUE);){
                Assertions.assertFalse((boolean)recordBatch.getVariadicBufferCounts().isEmpty());
                Assertions.assertEquals((int)1, (int)recordBatch.getVariadicBufferCounts().size());
                Assertions.assertEquals((long)0L, (Long)((Long)recordBatch.getVariadicBufferCounts().get(0)));
                StructVectorLoader vectorLoader = new StructVectorLoader(schema);
                try (StructVector structVector2 = vectorLoader.load(finalVectorsAllocator, recordBatch);){
                    Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)structVector1.getChild("f0"), (ValueVector)structVector2.getChild("f0")), (String)"vectors are not equivalent");
                    Assertions.assertTrue((boolean)VectorEqualsVisitor.vectorEquals((ValueVector)structVector1.getChild("f1"), (ValueVector)structVector2.getChild("f1")), (String)"vectors are not equivalent");
                }
            }
        }
    }
}

