/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.List;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.BufferImportTypeVisitor;
import org.apache.arrow.c.ReferenceCountedArrowArray;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArrowArrayUtilityTest {
    BufferAllocator allocator;
    ArrowArray arrowArray;
    ReferenceCountedArrowArray dummyHandle;

    ArrowArrayUtilityTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.allocator = new RootAllocator();
        this.arrowArray = ArrowArray.allocateNew((BufferAllocator)this.allocator);
        this.dummyHandle = new ReferenceCountedArrowArray(this.arrowArray);
    }

    @AfterEach
    void afterEach() {
        this.dummyHandle.release();
        this.allocator.close();
    }

    @Test
    void arraySchemaInit() {
        ArrowSchema schema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);
        Assertions.assertThat((long)schema.snapshot().release).isEqualTo(0L);
        schema.close();
    }

    @Test
    void importBuffer() throws Exception {
        try (BufferImportTypeVisitor notEmptyDataVisitor = new BufferImportTypeVisitor(this.allocator, this.dummyHandle, new ArrowFieldNode(1L, 0L), new long[]{0L});){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> notEmptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 1, 1L));
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> notEmptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 0, 1L));
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> notEmptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 0, 1L));
            Assertions.assertThat((Object)notEmptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 0, 0L)).isEqualTo((Object)this.allocator.getEmpty());
        }
        try (BufferImportTypeVisitor emptyDataVisitor = new BufferImportTypeVisitor(this.allocator, this.dummyHandle, new ArrowFieldNode(0L, 0L), new long[]{0L});){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> emptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 1, 1L));
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> emptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 0, 1L));
            Assertions.assertThat((Object)emptyDataVisitor.importBuffer((ArrowType)new ArrowType.Bool(), 0, 0L)).isEqualTo((Object)this.allocator.getEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void cleanupAfterFailure() throws Exception {
        long address = MemoryUtil.allocateMemory((long)16L);
        try (BufferImportTypeVisitor visitor = new BufferImportTypeVisitor(this.allocator, this.dummyHandle, new ArrowFieldNode(0L, 0L), new long[]{address});){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> visitor.visit(new ArrowType.Int(32, true)));
        }
        finally {
            MemoryUtil.freeMemory((long)address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void bufferAssociatedWithAllocator() throws Exception {
        long bufferSize = 16L;
        long fieldLength = 4L;
        long address = MemoryUtil.allocateMemory((long)16L);
        long baseline = this.allocator.getAllocatedMemory();
        ArrowFieldNode fieldNode = new ArrowFieldNode(4L, 0L);
        try (BufferImportTypeVisitor visitor = new BufferImportTypeVisitor(this.allocator, this.dummyHandle, fieldNode, new long[]{0L, address});){
            List buffers = visitor.visit(new ArrowType.Int(32, true));
            Assertions.assertThat((List)buffers).hasSize(2);
            Assertions.assertThat((Object)((ArrowBuf)buffers.get(0))).isNull();
            ((ObjectAssert)Assertions.assertThat((Object)((ArrowBuf)buffers.get(1))).isNotNull()).extracting(ArrowBuf::getReferenceManager).extracting(ReferenceManager::getAllocator).isEqualTo((Object)this.allocator);
            Assertions.assertThat((long)this.allocator.getAllocatedMemory()).isEqualTo(baseline + 16L);
        }
        finally {
            MemoryUtil.freeMemory((long)address);
        }
        Assertions.assertThat((long)this.allocator.getAllocatedMemory()).isEqualTo(baseline);
    }

    @Test
    void releaseRetain() {
        ArrowArray array = ArrowArray.allocateNew((BufferAllocator)this.allocator);
        ReferenceCountedArrowArray handle = new ReferenceCountedArrowArray(array);
        Assertions.assertThat((boolean)array.isClosed()).isFalse();
        handle.retain();
        Assertions.assertThat((boolean)array.isClosed()).isFalse();
        handle.release();
        Assertions.assertThat((boolean)array.isClosed()).isFalse();
        handle.release();
        Assertions.assertThat((boolean)array.isClosed()).isTrue();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ReferenceCountedArrowArray)handle).release());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ReferenceCountedArrowArray)handle).retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void associate() {
        long bufferSize = 16L;
        long address = MemoryUtil.allocateMemory((long)16L);
        try {
            ArrowArray array = ArrowArray.allocateNew((BufferAllocator)this.allocator);
            ReferenceCountedArrowArray handle = new ReferenceCountedArrowArray(array);
            Assertions.assertThat((boolean)array.isClosed()).isFalse();
            ArrowBuf buf = handle.unsafeAssociateAllocation(this.allocator, 16L, address);
            Assertions.assertThat((boolean)array.isClosed()).isFalse();
            buf.close();
            Assertions.assertThat((boolean)array.isClosed()).isFalse();
            handle.release();
            Assertions.assertThat((boolean)array.isClosed()).isTrue();
        }
        finally {
            MemoryUtil.freeMemory((long)address);
        }
    }
}

