/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.TestSortingUtil;
import org.apache.arrow.algorithm.sort.VariableWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.Text;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestVariableWidthSorting<V extends BaseVariableWidthVector, U extends Comparable<U>> {
    static final int[] VECTOR_LENGTHS = new int[]{2, 5, 10, 50, 100, 1000, 3000};
    static final double[] NULL_FRACTIONS = new double[]{0.0, 0.1, 0.3, 0.5, 0.7, 0.9, 1.0};
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testSort(int length, double nullFraction, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        this.sortOutOfPlace(length, nullFraction, vectorGenerator, dataGenerator);
    }

    void sortOutOfPlace(int length, double nullFraction, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        try (BaseVariableWidthVector vector = (BaseVariableWidthVector)vectorGenerator.apply(this.allocator);){
            Comparable[] array = dataGenerator.populate((ValueVector)vector, length, nullFraction);
            Arrays.sort(array, new StringComparator());
            VariableWidthOutOfPlaceVectorSorter sorter = new VariableWidthOutOfPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            try (BaseVariableWidthVector sortedVec = (BaseVariableWidthVector)vector.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                int dataSize = vector.getOffsetBuffer().getInt((long)vector.getValueCount() * 4L);
                sortedVec.allocateNew((long)dataSize, vector.getValueCount());
                sortedVec.setValueCount(vector.getValueCount());
                sorter.sortOutOfPlace(vector, sortedVec, comparator);
                TestVariableWidthSorting.verifyResults(sortedVec, (String[])array);
            }
        }
    }

    public static Stream<Arguments> getParameters() {
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        for (int length : VECTOR_LENGTHS) {
            for (double nullFrac : NULL_FRACTIONS) {
                params.add(Arguments.of((Object[])new Object[]{length, nullFrac, allocator -> new VarCharVector("vector", allocator), TestSortingUtil.STRING_GENERATOR}));
            }
        }
        return params.stream();
    }

    public static <V extends ValueVector> void verifyResults(V vector, String[] expected) {
        Assertions.assertEquals((int)vector.getValueCount(), (int)expected.length);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == null) {
                Assertions.assertTrue((boolean)vector.isNull(i));
                continue;
            }
            Assertions.assertArrayEquals((byte[])((Text)vector.getObject(i)).getBytes(), (byte[])expected[i].getBytes(StandardCharsets.UTF_8));
        }
    }

    static class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            if (str1 == null || str2 == null) {
                if (str1 == null && str2 == null) {
                    return 0;
                }
                return str1 == null ? -1 : 1;
            }
            byte[] bytes1 = str1.getBytes(StandardCharsets.UTF_8);
            byte[] bytes2 = str2.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < bytes1.length && i < bytes2.length; ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                return (bytes1[i] & 0xFF) < (bytes2[i] & 0xFF) ? -1 : 1;
            }
            return bytes1.length - bytes2.length;
        }
    }
}

