/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.GeneralOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.TestOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VariableWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestVariableWidthOutOfPlaceVectorSorter
extends TestOutOfPlaceVectorSorter {
    private BufferAllocator allocator;

    <V extends BaseVariableWidthVector> OutOfPlaceVectorSorter<V> getSorter(boolean generalSorter) {
        return generalSorter ? new GeneralOutOfPlaceVectorSorter() : new VariableWidthOutOfPlaceVectorSorter();
    }

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortString(boolean generalSorter) {
        try (VarCharVector vec = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            vec.set(0, "hello".getBytes(StandardCharsets.UTF_8));
            vec.set(1, "abc".getBytes(StandardCharsets.UTF_8));
            vec.setNull(2);
            vec.set(3, "world".getBytes(StandardCharsets.UTF_8));
            vec.set(4, "12".getBytes(StandardCharsets.UTF_8));
            vec.set(5, "dictionary".getBytes(StandardCharsets.UTF_8));
            vec.setNull(6);
            vec.set(7, "hello".getBytes(StandardCharsets.UTF_8));
            vec.set(8, "good".getBytes(StandardCharsets.UTF_8));
            vec.set(9, "yes".getBytes(StandardCharsets.UTF_8));
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            VarCharVector sortedVec = (VarCharVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew((long)vec.getByteCapacity(), vec.getValueCount());
            sortedVec.setLastSet(vec.getValueCount() - 1);
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertEquals((int)vec.getByteCapacity(), (int)sortedVec.getByteCapacity());
            Assertions.assertEquals((int)vec.getLastSet(), (int)sortedVec.getLastSet());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((Object)"12", (Object)new String(Objects.requireNonNull(sortedVec.get(2)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"abc", (Object)new String(Objects.requireNonNull(sortedVec.get(3)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"dictionary", (Object)new String(Objects.requireNonNull(sortedVec.get(4)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"good", (Object)new String(Objects.requireNonNull(sortedVec.get(5)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"hello", (Object)new String(Objects.requireNonNull(sortedVec.get(6)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"hello", (Object)new String(Objects.requireNonNull(sortedVec.get(7)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"world", (Object)new String(Objects.requireNonNull(sortedVec.get(8)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"yes", (Object)new String(Objects.requireNonNull(sortedVec.get(9)), StandardCharsets.UTF_8));
            sortedVec.close();
        }
    }
}

