/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.arrow.algorithm.sort.StableVectorComparator;
import org.apache.arrow.algorithm.sort.VariableWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestStableVectorComparator {
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testCompare() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 5);
            vec.setValueCount(10);
            vec.set(0, "ba".getBytes(StandardCharsets.UTF_8));
            vec.set(1, "abc".getBytes(StandardCharsets.UTF_8));
            vec.set(2, "aa".getBytes(StandardCharsets.UTF_8));
            vec.set(3, "abc".getBytes(StandardCharsets.UTF_8));
            vec.set(4, "a".getBytes(StandardCharsets.UTF_8));
            TestVarCharSorter comparator = new TestVarCharSorter();
            StableVectorComparator stableComparator = new StableVectorComparator((VectorValueComparator)comparator);
            stableComparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((stableComparator.compare(0, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(2, 3) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(1, 3) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(3, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)0, (int)stableComparator.compare(3, 3));
        }
    }

    @Test
    public void testStableSortString() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            vec.set(0, "a".getBytes(StandardCharsets.UTF_8));
            vec.set(1, "abc".getBytes(StandardCharsets.UTF_8));
            vec.set(2, "aa".getBytes(StandardCharsets.UTF_8));
            vec.set(3, "a1".getBytes(StandardCharsets.UTF_8));
            vec.set(4, "abcdefg".getBytes(StandardCharsets.UTF_8));
            vec.set(5, "accc".getBytes(StandardCharsets.UTF_8));
            vec.set(6, "afds".getBytes(StandardCharsets.UTF_8));
            vec.set(7, "0".getBytes(StandardCharsets.UTF_8));
            vec.set(8, "01".getBytes(StandardCharsets.UTF_8));
            vec.set(9, "0c".getBytes(StandardCharsets.UTF_8));
            VariableWidthOutOfPlaceVectorSorter sorter = new VariableWidthOutOfPlaceVectorSorter();
            TestVarCharSorter comparator = new TestVarCharSorter();
            StableVectorComparator stableComparator = new StableVectorComparator((VectorValueComparator)comparator);
            try (VarCharVector sortedVec = (VarCharVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                sortedVec.allocateNew((long)vec.getByteCapacity(), vec.getValueCount());
                sortedVec.setLastSet(vec.getValueCount() - 1);
                sortedVec.setValueCount(vec.getValueCount());
                sorter.sortOutOfPlace((BaseVariableWidthVector)vec, (BaseVariableWidthVector)sortedVec, (VectorValueComparator)stableComparator);
                Assertions.assertEquals((Object)"0", (Object)new String(Objects.requireNonNull(sortedVec.get(0)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"01", (Object)new String(Objects.requireNonNull(sortedVec.get(1)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"0c", (Object)new String(Objects.requireNonNull(sortedVec.get(2)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"a", (Object)new String(Objects.requireNonNull(sortedVec.get(3)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"abc", (Object)new String(Objects.requireNonNull(sortedVec.get(4)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"aa", (Object)new String(Objects.requireNonNull(sortedVec.get(5)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"a1", (Object)new String(Objects.requireNonNull(sortedVec.get(6)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"abcdefg", (Object)new String(Objects.requireNonNull(sortedVec.get(7)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"accc", (Object)new String(Objects.requireNonNull(sortedVec.get(8)), StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)"afds", (Object)new String(Objects.requireNonNull(sortedVec.get(9)), StandardCharsets.UTF_8));
            }
        }
    }

    private static class TestVarCharSorter
    extends VectorValueComparator<VarCharVector> {
        private TestVarCharSorter() {
        }

        public int compareNotNull(int index1, int index2) {
            byte b1 = ((VarCharVector)this.vector1).get(index1)[0];
            byte b2 = ((VarCharVector)this.vector2).get(index2)[0];
            return b1 - b2;
        }

        public VectorValueComparator<VarCharVector> createNew() {
            return new TestVarCharSorter();
        }
    }
}

