/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.OffHeapIntStack;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestOffHeapIntStack {
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testPushPop() {
        try (OffHeapIntStack stack = new OffHeapIntStack(this.allocator);){
            int i;
            Assertions.assertTrue((boolean)stack.isEmpty());
            int elemCount = 500;
            for (i = 0; i < 500; ++i) {
                stack.push(i);
                Assertions.assertEquals((int)i, (int)stack.getTop());
            }
            Assertions.assertEquals((int)500, (int)stack.getCount());
            for (i = 0; i < 500; ++i) {
                Assertions.assertEquals((int)(500 - i - 1), (int)stack.getTop());
                Assertions.assertEquals((int)(500 - i - 1), (int)stack.pop());
            }
            Assertions.assertTrue((boolean)stack.isEmpty());
        }
    }
}

