/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.GeneralOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGeneralOutOfPlaceVectorSorter {
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    VectorValueComparator<StructVector> getComparator(StructVector structVector) {
        IntVector child0 = (IntVector)structVector.getChild("column0", IntVector.class);
        final VectorValueComparator childComp0 = DefaultVectorComparators.createDefaultComparator((ValueVector)child0);
        childComp0.attachVector((ValueVector)child0);
        IntVector child1 = (IntVector)structVector.getChild("column1", IntVector.class);
        final VectorValueComparator childComp1 = DefaultVectorComparators.createDefaultComparator((ValueVector)child1);
        childComp1.attachVector((ValueVector)child1);
        VectorValueComparator<StructVector> comp = new VectorValueComparator<StructVector>(){

            public int compareNotNull(int index1, int index2) {
                int result0 = childComp0.compare(index1, index2);
                if (result0 != 0) {
                    return result0;
                }
                return childComp1.compare(index1, index2);
            }

            public VectorValueComparator createNew() {
                return this;
            }
        };
        return comp;
    }

    @Test
    public void testSortStructVector() {
        int vectorLength = 7;
        try (StructVector srcVector = StructVector.empty((String)"src struct", (BufferAllocator)this.allocator);
             StructVector dstVector = StructVector.empty((String)"dst struct", (BufferAllocator)this.allocator);){
            IntVector srcChild0 = (IntVector)srcVector.addOrGet("column0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            IntVector srcChild1 = (IntVector)srcVector.addOrGet("column1", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            IntVector dstChild0 = (IntVector)dstVector.addOrGet("column0", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            IntVector dstChild1 = (IntVector)dstVector.addOrGet("column1", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), IntVector.class);
            ValueVectorDataPopulator.setVector((IntVector)srcChild0, (Integer[])new Integer[]{2, 3, 5, null, 7, null, 6});
            ValueVectorDataPopulator.setVector((IntVector)srcChild1, (Integer[])new Integer[]{1, 4, 4, 3, null, null, 6});
            srcVector.setIndexDefined(0);
            srcVector.setIndexDefined(1);
            srcVector.setIndexDefined(2);
            srcVector.setIndexDefined(3);
            srcVector.setIndexDefined(4);
            srcVector.setIndexDefined(6);
            srcVector.setValueCount(7);
            dstChild0.allocateNew(7);
            dstChild1.allocateNew(7);
            dstVector.setValueCount(7);
            VectorValueComparator<StructVector> comp = this.getComparator(srcVector);
            GeneralOutOfPlaceVectorSorter sorter = new GeneralOutOfPlaceVectorSorter();
            sorter.sortOutOfPlace((ValueVector)srcVector, (ValueVector)dstVector, comp);
            Assertions.assertEquals((int)7, (int)dstVector.getValueCount());
            Assertions.assertEquals((Object)"[null, {\"column1\":3}, {\"column0\":2,\"column1\":1}, {\"column0\":3,\"column1\":4}, {\"column0\":5,\"column1\":4}, {\"column0\":6,\"column1\":6}, {\"column0\":7}]", (Object)dstVector.toString());
        }
    }
}

