/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.FixedWidthInPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.FixedWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.TestSortingUtil;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestFixedWidthSorting<V extends BaseFixedWidthVector, U extends Comparable<U>> {
    static final int[] VECTOR_LENGTHS = new int[]{2, 5, 10, 50, 100, 1000, 3000};
    static final double[] NULL_FRACTIONS = new double[]{0.0, 0.1, 0.3, 0.5, 0.7, 0.9, 1.0};
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testSort(boolean inPlace, int length, double nullFraction, String desc, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        if (inPlace) {
            this.sortInPlace(length, nullFraction, vectorGenerator, dataGenerator);
        } else {
            this.sortOutOfPlace(length, nullFraction, vectorGenerator, dataGenerator);
        }
    }

    void sortInPlace(int length, double nullFraction, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        try (BaseFixedWidthVector vector = (BaseFixedWidthVector)vectorGenerator.apply(this.allocator);){
            Comparable[] array = dataGenerator.populate((ValueVector)vector, length, nullFraction);
            TestSortingUtil.sortArray((Comparable[])array);
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            sorter.sortInPlace(vector, comparator);
            TestSortingUtil.verifyResults(vector, array);
        }
    }

    void sortOutOfPlace(int length, double nullFraction, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        try (BaseFixedWidthVector vector = (BaseFixedWidthVector)vectorGenerator.apply(this.allocator);){
            Comparable[] array = dataGenerator.populate((ValueVector)vector, length, nullFraction);
            TestSortingUtil.sortArray((Comparable[])array);
            FixedWidthOutOfPlaceVectorSorter sorter = new FixedWidthOutOfPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            try (BaseFixedWidthVector sortedVec = (BaseFixedWidthVector)vector.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                sortedVec.allocateNew(vector.getValueCount());
                sortedVec.setValueCount(vector.getValueCount());
                sorter.sortOutOfPlace(vector, sortedVec, comparator);
                TestSortingUtil.verifyResults(sortedVec, array);
            }
        }
    }

    public static Stream<Arguments> getParameters() {
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        for (int length : VECTOR_LENGTHS) {
            for (double nullFrac : NULL_FRACTIONS) {
                for (boolean inPlace : new boolean[]{true, false}) {
                    params.add(Arguments.of((Object[])new Object[]{inPlace, length, nullFrac, "TinyIntVector", allocator -> new TinyIntVector("vector", allocator), TestSortingUtil.TINY_INT_GENERATOR}));
                    params.add(Arguments.of((Object[])new Object[]{inPlace, length, nullFrac, "SmallIntVector", allocator -> new SmallIntVector("vector", allocator), TestSortingUtil.SMALL_INT_GENERATOR}));
                    params.add(Arguments.of((Object[])new Object[]{inPlace, length, nullFrac, "IntVector", allocator -> new IntVector("vector", allocator), TestSortingUtil.INT_GENERATOR}));
                    params.add(Arguments.of((Object[])new Object[]{inPlace, length, nullFrac, "BigIntVector", allocator -> new BigIntVector("vector", allocator), TestSortingUtil.LONG_GENERATOR}));
                    params.add(Arguments.of((Object[])new Object[]{inPlace, length, nullFrac, "Float4Vector", allocator -> new Float4Vector("vector", allocator), TestSortingUtil.FLOAT_GENERATOR}));
                    params.add(Arguments.of((Object[])new Object[]{inPlace, length, nullFrac, "Float8Vector", allocator -> new Float8Vector("vector", allocator), TestSortingUtil.DOUBLE_GENERATOR}));
                }
            }
        }
        return params.stream();
    }
}

