/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.stream.IntStream;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.FixedWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.GeneralOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.TestOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestFixedWidthOutOfPlaceVectorSorter
extends TestOutOfPlaceVectorSorter {
    private BufferAllocator allocator;

    <V extends BaseFixedWidthVector> OutOfPlaceVectorSorter<V> getSorter(boolean generalSorter) {
        return generalSorter ? new GeneralOutOfPlaceVectorSorter() : new FixedWidthOutOfPlaceVectorSorter();
    }

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortByte(boolean generalSorter) {
        try (TinyIntVector vec = new TinyIntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10);
            vec.set(1, 8);
            vec.setNull(2);
            vec.set(3, 10);
            vec.set(4, 12);
            vec.set(5, 17);
            vec.setNull(6);
            vec.set(7, 23);
            vec.set(8, 35);
            vec.set(9, 2);
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            TinyIntVector sortedVec = (TinyIntVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew(vec.getValueCount());
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((byte)2, (byte)sortedVec.get(2));
            Assertions.assertEquals((byte)8, (byte)sortedVec.get(3));
            Assertions.assertEquals((byte)10, (byte)sortedVec.get(4));
            Assertions.assertEquals((byte)10, (byte)sortedVec.get(5));
            Assertions.assertEquals((byte)12, (byte)sortedVec.get(6));
            Assertions.assertEquals((byte)17, (byte)sortedVec.get(7));
            Assertions.assertEquals((byte)23, (byte)sortedVec.get(8));
            Assertions.assertEquals((byte)35, (byte)sortedVec.get(9));
            sortedVec.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortShort(boolean generalSorter) {
        try (SmallIntVector vec = new SmallIntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10);
            vec.set(1, 8);
            vec.setNull(2);
            vec.set(3, 10);
            vec.set(4, 12);
            vec.set(5, 17);
            vec.setNull(6);
            vec.set(7, 23);
            vec.set(8, 35);
            vec.set(9, 2);
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SmallIntVector sortedVec = (SmallIntVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew(vec.getValueCount());
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((short)2, (short)sortedVec.get(2));
            Assertions.assertEquals((short)8, (short)sortedVec.get(3));
            Assertions.assertEquals((short)10, (short)sortedVec.get(4));
            Assertions.assertEquals((short)10, (short)sortedVec.get(5));
            Assertions.assertEquals((short)12, (short)sortedVec.get(6));
            Assertions.assertEquals((short)17, (short)sortedVec.get(7));
            Assertions.assertEquals((short)23, (short)sortedVec.get(8));
            Assertions.assertEquals((short)35, (short)sortedVec.get(9));
            sortedVec.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortInt(boolean generalSorter) {
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10);
            vec.set(1, 8);
            vec.setNull(2);
            vec.set(3, 10);
            vec.set(4, 12);
            vec.set(5, 17);
            vec.setNull(6);
            vec.set(7, 23);
            vec.set(8, 35);
            vec.set(9, 2);
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            IntVector sortedVec = (IntVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew(vec.getValueCount());
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((int)2, (int)sortedVec.get(2));
            Assertions.assertEquals((int)8, (int)sortedVec.get(3));
            Assertions.assertEquals((int)10, (int)sortedVec.get(4));
            Assertions.assertEquals((int)10, (int)sortedVec.get(5));
            Assertions.assertEquals((int)12, (int)sortedVec.get(6));
            Assertions.assertEquals((int)17, (int)sortedVec.get(7));
            Assertions.assertEquals((int)23, (int)sortedVec.get(8));
            Assertions.assertEquals((int)35, (int)sortedVec.get(9));
            sortedVec.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortLong(boolean generalSorter) {
        try (BigIntVector vec = new BigIntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10L);
            vec.set(1, 8L);
            vec.setNull(2);
            vec.set(3, 10L);
            vec.set(4, 12L);
            vec.set(5, 17L);
            vec.setNull(6);
            vec.set(7, 23L);
            vec.set(8, 0x800000000L);
            vec.set(9, 2L);
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            BigIntVector sortedVec = (BigIntVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew(vec.getValueCount());
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((long)2L, (long)sortedVec.get(2));
            Assertions.assertEquals((long)8L, (long)sortedVec.get(3));
            Assertions.assertEquals((long)10L, (long)sortedVec.get(4));
            Assertions.assertEquals((long)10L, (long)sortedVec.get(5));
            Assertions.assertEquals((long)12L, (long)sortedVec.get(6));
            Assertions.assertEquals((long)17L, (long)sortedVec.get(7));
            Assertions.assertEquals((long)23L, (long)sortedVec.get(8));
            Assertions.assertEquals((long)0x800000000L, (long)sortedVec.get(9));
            sortedVec.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortFloat(boolean generalSorter) {
        try (Float4Vector vec = new Float4Vector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10.0f);
            vec.set(1, 8.0f);
            vec.setNull(2);
            vec.set(3, 10.0f);
            vec.set(4, 12.0f);
            vec.set(5, 17.0f);
            vec.setNull(6);
            vec.set(7, 23.0f);
            vec.set(8, Float.NaN);
            vec.set(9, 2.0f);
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            Float4Vector sortedVec = (Float4Vector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew(vec.getValueCount());
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((float)2.0f, (float)sortedVec.get(2), (float)0.0f);
            Assertions.assertEquals((float)8.0f, (float)sortedVec.get(3), (float)0.0f);
            Assertions.assertEquals((float)10.0f, (float)sortedVec.get(4), (float)0.0f);
            Assertions.assertEquals((float)10.0f, (float)sortedVec.get(5), (float)0.0f);
            Assertions.assertEquals((float)12.0f, (float)sortedVec.get(6), (float)0.0f);
            Assertions.assertEquals((float)17.0f, (float)sortedVec.get(7), (float)0.0f);
            Assertions.assertEquals((float)23.0f, (float)sortedVec.get(8), (float)0.0f);
            Assertions.assertEquals((float)Float.NaN, (float)sortedVec.get(9), (float)0.0f);
            sortedVec.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortDouble(boolean generalSorter) {
        try (Float8Vector vec = new Float8Vector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10.0);
            vec.set(1, 8.0);
            vec.setNull(2);
            vec.set(3, 10.0);
            vec.set(4, 12.0);
            vec.set(5, 17.0);
            vec.setNull(6);
            vec.set(7, Double.NaN);
            vec.set(8, 35.0);
            vec.set(9, 2.0);
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            Float8Vector sortedVec = (Float8Vector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew(vec.getValueCount());
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assertions.assertEquals((int)vec.getValueCount(), (int)sortedVec.getValueCount());
            Assertions.assertTrue((boolean)sortedVec.isNull(0));
            Assertions.assertTrue((boolean)sortedVec.isNull(1));
            Assertions.assertEquals((double)2.0, (double)sortedVec.get(2), (double)0.0);
            Assertions.assertEquals((double)8.0, (double)sortedVec.get(3), (double)0.0);
            Assertions.assertEquals((double)10.0, (double)sortedVec.get(4), (double)0.0);
            Assertions.assertEquals((double)10.0, (double)sortedVec.get(5), (double)0.0);
            Assertions.assertEquals((double)12.0, (double)sortedVec.get(6), (double)0.0);
            Assertions.assertEquals((double)17.0, (double)sortedVec.get(7), (double)0.0);
            Assertions.assertEquals((double)35.0, (double)sortedVec.get(8), (double)0.0);
            Assertions.assertEquals((double)Double.NaN, (double)sortedVec.get(9), (double)0.0);
            sortedVec.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameter"})
    public void testSortInt2(boolean generalSorter) {
        try (IntVector vec = new IntVector("", this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{0, 1, 2, 3, 4, 5, 30, 31, 32, 33, 34, 35, 60, 61, 62, 63, 64, 65, 6, 7, 8, 9, 10, 11, 36, 37, 38, 39, 40, 41, 66, 67, 68, 69, 70, 71});
            OutOfPlaceVectorSorter sorter = this.getSorter(generalSorter);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            try (IntVector sortedVec = (IntVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                sortedVec.allocateNew(vec.getValueCount());
                sortedVec.setValueCount(vec.getValueCount());
                sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
                int[] actual = new int[sortedVec.getValueCount()];
                IntStream.range(0, sortedVec.getValueCount()).forEach(i -> {
                    actual[i] = sortedVec.get(i);
                });
                Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71}, (int[])actual);
            }
        }
    }
}

