/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.stream.IntStream;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.FixedWidthInPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFixedWidthInPlaceVectorSorter {
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testSortInt() {
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.set(0, 10);
            vec.set(1, 8);
            vec.setNull(2);
            vec.set(3, 10);
            vec.set(4, 12);
            vec.set(5, 17);
            vec.setNull(6);
            vec.set(7, 23);
            vec.set(8, 35);
            vec.set(9, 2);
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            sorter.sortInPlace((BaseFixedWidthVector)vec, comparator);
            Assertions.assertEquals((int)10, (int)vec.getValueCount());
            Assertions.assertTrue((boolean)vec.isNull(0));
            Assertions.assertTrue((boolean)vec.isNull(1));
            Assertions.assertEquals((int)2, (int)vec.get(2));
            Assertions.assertEquals((int)8, (int)vec.get(3));
            Assertions.assertEquals((int)10, (int)vec.get(4));
            Assertions.assertEquals((int)10, (int)vec.get(5));
            Assertions.assertEquals((int)12, (int)vec.get(6));
            Assertions.assertEquals((int)17, (int)vec.get(7));
            Assertions.assertEquals((int)23, (int)vec.get(8));
            Assertions.assertEquals((int)35, (int)vec.get(9));
        }
    }

    @Test
    public void testSortLargeIncreasingInt() {
        int vectorLength = 20000;
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(20000);
            vec.setValueCount(20000);
            for (int i = 0; i < 20000; ++i) {
                vec.set(i, i);
            }
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            sorter.sortInPlace((BaseFixedWidthVector)vec, comparator);
            Assertions.assertEquals((int)20000, (int)vec.getValueCount());
            for (int i = 0; i < 20000; ++i) {
                Assertions.assertEquals((int)i, (int)vec.get(i));
            }
        }
    }

    @Test
    public void testChoosePivot() {
        int vectorLength = 100;
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(100);
            for (int i = 0; i < 100; ++i) {
                vec.set(i, i * 100);
            }
            vec.setValueCount(100);
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            try (IntVector pivotBuffer = (IntVector)vec.getField().createVector(this.allocator);){
                pivotBuffer.allocateNew(1);
                sorter.pivotBuffer = pivotBuffer;
                sorter.comparator = comparator;
                sorter.vec = vec;
                comparator.attachVectors((ValueVector)vec, (ValueVector)pivotBuffer);
                int low = 5;
                int high = 6;
                int pivotValue = vec.get(low);
                Assertions.assertTrue((high - low + 1 < 3 ? 1 : 0) != 0);
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)pivotValue, (int)vec.get(low));
                low = 30;
                high = 80;
                pivotValue = vec.get((low + high) / 2);
                Assertions.assertTrue((high - low + 1 >= 3 ? 1 : 0) != 0);
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)pivotValue, (int)vec.get(low));
            }
        }
    }

    @Test
    public void testChoosePivotAllPermutes() {
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(3);
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            try (IntVector pivotBuffer = (IntVector)vec.getField().createVector(this.allocator);){
                pivotBuffer.allocateNew(1);
                sorter.pivotBuffer = pivotBuffer;
                sorter.comparator = comparator;
                sorter.vec = vec;
                comparator.attachVectors((ValueVector)vec, (ValueVector)pivotBuffer);
                int low = 0;
                int high = 2;
                ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{11, 22, 33});
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)22, (int)vec.get(0));
                ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{11, 33, 22});
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)22, (int)vec.get(0));
                ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{22, 11, 33});
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)22, (int)vec.get(0));
                ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{22, 33, 11});
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)22, (int)vec.get(0));
                ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{33, 11, 22});
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)22, (int)vec.get(0));
                ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{33, 22, 11});
                sorter.choosePivot(low, high);
                Assertions.assertEquals((int)22, (int)vec.get(0));
            }
        }
    }

    @Test
    public void testSortInt2() {
        try (IntVector vector = new IntVector("vector", this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vector, (Integer[])new Integer[]{0, 1, 2, 3, 4, 5, 30, 31, 32, 33, 34, 35, 60, 61, 62, 63, 64, 65, 6, 7, 8, 9, 10, 11, 36, 37, 38, 39, 40, 41, 66, 67, 68, 69, 70, 71});
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            sorter.sortInPlace((BaseFixedWidthVector)vector, comparator);
            int[] actual = new int[vector.getValueCount()];
            IntStream.range(0, vector.getValueCount()).forEach(i -> {
                actual[i] = vector.get(i);
            });
            Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71}, (int[])actual);
        }
    }
}

