/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import java.util.stream.Stream;
import org.apache.arrow.algorithm.search.VectorRangeSearcher;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestVectorRangeSearcher {
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @ParameterizedTest
    @MethodSource(value={"getRepeat"})
    public void testGetLowerBounds(int repeat) {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);){
            intVector.allocateNew(100 * repeat);
            intVector.setValueCount(100 * repeat);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * repeat + j);
                        continue;
                    }
                    intVector.set(i * repeat + j, i);
                }
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getFirstMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)intVector, (int)(i * repeat));
                Assertions.assertEquals((long)((long)i * (long)repeat), (long)result);
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getRepeat"})
    public void testGetLowerBoundsNegative(int repeat) {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);
             IntVector negVector = new IntVector("neg vec", this.allocator);){
            intVector.allocateNew(100 * repeat);
            intVector.setValueCount(100 * repeat);
            negVector.allocateNew(100);
            negVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * repeat + j);
                        continue;
                    }
                    intVector.set(i * repeat + j, i);
                }
                negVector.set(i, 100 + i);
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getFirstMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)i);
                Assertions.assertEquals((int)-1, (int)result);
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getRepeat"})
    public void testGetUpperBounds(int repeat) {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);){
            intVector.allocateNew(100 * repeat);
            intVector.setValueCount(100 * repeat);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * repeat + j);
                        continue;
                    }
                    intVector.set(i * repeat + j, i);
                }
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getLastMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)intVector, (int)(i * repeat));
                Assertions.assertEquals((int)((i + 1) * repeat - 1), (int)result);
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getRepeat"})
    public void testGetUpperBoundsNegative(int repeat) {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);
             IntVector negVector = new IntVector("neg vec", this.allocator);){
            intVector.allocateNew(100 * repeat);
            intVector.setValueCount(100 * repeat);
            negVector.allocateNew(100);
            negVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * repeat + j);
                        continue;
                    }
                    intVector.set(i * repeat + j, i);
                }
                negVector.set(i, 100 + i);
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getLastMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)i);
                Assertions.assertEquals((int)-1, (int)result);
            }
        }
    }

    public static Stream<Arguments> getRepeat() {
        return Stream.of(Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{2}), Arguments.of((Object[])new Object[]{5}), Arguments.of((Object[])new Object[]{10}));
    }
}

