/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.arrow.algorithm.search.ParallelSearcher;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestParallelSearcher {
    private static final int VECTOR_LENGTH = 10000;
    private BufferAllocator allocator;
    private ExecutorService threadPool;

    public static Stream<Arguments> getComparatorName() {
        ArrayList<Arguments> params = new ArrayList<Arguments>();
        int[] threadCounts = new int[]{1, 2, 5, 10, 20, 50};
        for (ComparatorType type : ComparatorType.values()) {
            for (int count : threadCounts) {
                params.add(Arguments.of((Object[])new Object[]{type, count}));
            }
        }
        return params.stream();
    }

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getComparatorName"})
    public void testParallelIntSearch(ComparatorType comparatorType, int threadCount) throws ExecutionException, InterruptedException {
        this.threadPool = Executors.newFixedThreadPool(threadCount);
        try (IntVector targetVector = new IntVector("targetVector", this.allocator);
             IntVector keyVector = new IntVector("keyVector", this.allocator);){
            targetVector.allocateNew(10000);
            keyVector.allocateNew(10000);
            VectorValueComparator comparator = comparatorType == ComparatorType.EqualityComparator ? null : DefaultVectorComparators.createDefaultComparator((ValueVector)targetVector);
            for (int i = 0; i < 10000; ++i) {
                targetVector.set(i, i);
                keyVector.set(i, i * 2);
            }
            targetVector.setValueCount(10000);
            keyVector.setValueCount(10000);
            ParallelSearcher searcher = new ParallelSearcher((ValueVector)targetVector, this.threadPool, threadCount);
            for (int i = 0; i < 10000; ++i) {
                int pos;
                int n = pos = comparator == null ? searcher.search((ValueVector)keyVector, i) : searcher.search((ValueVector)keyVector, i, comparator);
                if (i * 2 < 10000) {
                    Assertions.assertEquals((int)(i * 2), (int)pos);
                    continue;
                }
                Assertions.assertEquals((int)-1, (int)pos);
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getComparatorName"})
    public void testParallelStringSearch(ComparatorType comparatorType, int threadCount) throws ExecutionException, InterruptedException {
        this.threadPool = Executors.newFixedThreadPool(threadCount);
        try (VarCharVector targetVector = new VarCharVector("targetVector", this.allocator);
             VarCharVector keyVector = new VarCharVector("keyVector", this.allocator);){
            targetVector.allocateNew(10000);
            keyVector.allocateNew(10000);
            VectorValueComparator comparator = comparatorType == ComparatorType.EqualityComparator ? null : DefaultVectorComparators.createDefaultComparator((ValueVector)targetVector);
            for (int i = 0; i < 10000; ++i) {
                targetVector.setSafe(i, String.valueOf(i).getBytes(StandardCharsets.UTF_8));
                keyVector.setSafe(i, String.valueOf(i * 2).getBytes(StandardCharsets.UTF_8));
            }
            targetVector.setValueCount(10000);
            keyVector.setValueCount(10000);
            ParallelSearcher searcher = new ParallelSearcher((ValueVector)targetVector, this.threadPool, threadCount);
            for (int i = 0; i < 10000; ++i) {
                int pos;
                int n = pos = comparator == null ? searcher.search((ValueVector)keyVector, i) : searcher.search((ValueVector)keyVector, i, comparator);
                if (i * 2 < 10000) {
                    Assertions.assertEquals((int)(i * 2), (int)pos);
                    continue;
                }
                Assertions.assertEquals((int)-1, (int)pos);
            }
        }
    }

    private static enum ComparatorType {
        EqualityComparator,
        OrderingComparator;

    }
}

