/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.rank;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.algorithm.rank.VectorRank;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVectorRank {
    private BufferAllocator allocator;
    private static final int VECTOR_LENGTH = 10;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testFixedWidthRank() {
        VectorRank rank = new VectorRank(this.allocator);
        try (IntVector vector = new IntVector("int vec", this.allocator);){
            vector.allocateNew(10);
            vector.setValueCount(10);
            vector.set(0, 1);
            vector.set(1, 5);
            vector.set(2, 3);
            vector.set(3, 7);
            vector.set(4, 9);
            vector.set(5, 8);
            vector.set(6, 2);
            vector.set(7, 0);
            vector.set(8, 4);
            vector.set(9, 6);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            Assertions.assertEquals((int)7, (int)rank.indexAtRank((ValueVector)vector, comparator, 0));
            Assertions.assertEquals((int)0, (int)rank.indexAtRank((ValueVector)vector, comparator, 1));
            Assertions.assertEquals((int)6, (int)rank.indexAtRank((ValueVector)vector, comparator, 2));
            Assertions.assertEquals((int)2, (int)rank.indexAtRank((ValueVector)vector, comparator, 3));
            Assertions.assertEquals((int)8, (int)rank.indexAtRank((ValueVector)vector, comparator, 4));
            Assertions.assertEquals((int)1, (int)rank.indexAtRank((ValueVector)vector, comparator, 5));
            Assertions.assertEquals((int)9, (int)rank.indexAtRank((ValueVector)vector, comparator, 6));
            Assertions.assertEquals((int)3, (int)rank.indexAtRank((ValueVector)vector, comparator, 7));
            Assertions.assertEquals((int)5, (int)rank.indexAtRank((ValueVector)vector, comparator, 8));
            Assertions.assertEquals((int)4, (int)rank.indexAtRank((ValueVector)vector, comparator, 9));
        }
    }

    @Test
    public void testVariableWidthRank() {
        VectorRank rank = new VectorRank(this.allocator);
        try (VarCharVector vector = new VarCharVector("varchar vec", this.allocator);){
            vector.allocateNew(50L, 10);
            vector.setValueCount(10);
            vector.set(0, String.valueOf(1).getBytes(StandardCharsets.UTF_8));
            vector.set(1, String.valueOf(5).getBytes(StandardCharsets.UTF_8));
            vector.set(2, String.valueOf(3).getBytes(StandardCharsets.UTF_8));
            vector.set(3, String.valueOf(7).getBytes(StandardCharsets.UTF_8));
            vector.set(4, String.valueOf(9).getBytes(StandardCharsets.UTF_8));
            vector.set(5, String.valueOf(8).getBytes(StandardCharsets.UTF_8));
            vector.set(6, String.valueOf(2).getBytes(StandardCharsets.UTF_8));
            vector.set(7, String.valueOf(0).getBytes(StandardCharsets.UTF_8));
            vector.set(8, String.valueOf(4).getBytes(StandardCharsets.UTF_8));
            vector.set(9, String.valueOf(6).getBytes(StandardCharsets.UTF_8));
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            Assertions.assertEquals((int)7, (int)rank.indexAtRank((ValueVector)vector, comparator, 0));
            Assertions.assertEquals((int)0, (int)rank.indexAtRank((ValueVector)vector, comparator, 1));
            Assertions.assertEquals((int)6, (int)rank.indexAtRank((ValueVector)vector, comparator, 2));
            Assertions.assertEquals((int)2, (int)rank.indexAtRank((ValueVector)vector, comparator, 3));
            Assertions.assertEquals((int)8, (int)rank.indexAtRank((ValueVector)vector, comparator, 4));
            Assertions.assertEquals((int)1, (int)rank.indexAtRank((ValueVector)vector, comparator, 5));
            Assertions.assertEquals((int)9, (int)rank.indexAtRank((ValueVector)vector, comparator, 6));
            Assertions.assertEquals((int)3, (int)rank.indexAtRank((ValueVector)vector, comparator, 7));
            Assertions.assertEquals((int)5, (int)rank.indexAtRank((ValueVector)vector, comparator, 8));
            Assertions.assertEquals((int)4, (int)rank.indexAtRank((ValueVector)vector, comparator, 9));
        }
    }

    @Test
    public void testRankNegative() {
        VectorRank rank = new VectorRank(this.allocator);
        try (IntVector vector = new IntVector("int vec", this.allocator);){
            vector.allocateNew(10);
            vector.setValueCount(10);
            vector.set(0, 1);
            vector.set(1, 5);
            vector.set(2, 3);
            vector.set(3, 7);
            vector.set(4, 9);
            vector.set(5, 8);
            vector.set(6, 2);
            vector.set(7, 0);
            vector.set(8, 4);
            vector.set(9, 6);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            Assertions.assertThrows(IllegalArgumentException.class, () -> rank.indexAtRank((ValueVector)vector, comparator, 11));
        }
    }
}

