/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.arrow.algorithm.dictionary.SearchTreeBasedDictionaryBuilder;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSearchTreeBasedDictionaryBuilder {
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testBuildVariableWidthDictionaryWithNull() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);
             VarCharVector dictionary = new VarCharVector("", this.allocator);
             VarCharVector sortedDictionary = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, "hello".getBytes(StandardCharsets.UTF_8));
            vec.set(1, "abc".getBytes(StandardCharsets.UTF_8));
            vec.setNull(2);
            vec.set(3, "world".getBytes(StandardCharsets.UTF_8));
            vec.set(4, "12".getBytes(StandardCharsets.UTF_8));
            vec.set(5, "dictionary".getBytes(StandardCharsets.UTF_8));
            vec.setNull(6);
            vec.set(7, "hello".getBytes(StandardCharsets.UTF_8));
            vec.set(8, "good".getBytes(StandardCharsets.UTF_8));
            vec.set(9, "abc".getBytes(StandardCharsets.UTF_8));
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, true);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assertions.assertEquals((int)7, (int)result);
            Assertions.assertEquals((int)7, (int)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assertions.assertTrue((boolean)sortedDictionary.isNull(0));
            Assertions.assertEquals((Object)"12", (Object)new String(Objects.requireNonNull(sortedDictionary.get(1)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"abc", (Object)new String(Objects.requireNonNull(sortedDictionary.get(2)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"dictionary", (Object)new String(Objects.requireNonNull(sortedDictionary.get(3)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"good", (Object)new String(Objects.requireNonNull(sortedDictionary.get(4)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"hello", (Object)new String(Objects.requireNonNull(sortedDictionary.get(5)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"world", (Object)new String(Objects.requireNonNull(sortedDictionary.get(6)), StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testBuildVariableWidthDictionaryWithoutNull() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);
             VarCharVector dictionary = new VarCharVector("", this.allocator);
             VarCharVector sortedDictionary = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, "hello".getBytes(StandardCharsets.UTF_8));
            vec.set(1, "abc".getBytes(StandardCharsets.UTF_8));
            vec.setNull(2);
            vec.set(3, "world".getBytes(StandardCharsets.UTF_8));
            vec.set(4, "12".getBytes(StandardCharsets.UTF_8));
            vec.set(5, "dictionary".getBytes(StandardCharsets.UTF_8));
            vec.setNull(6);
            vec.set(7, "hello".getBytes(StandardCharsets.UTF_8));
            vec.set(8, "good".getBytes(StandardCharsets.UTF_8));
            vec.set(9, "abc".getBytes(StandardCharsets.UTF_8));
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, false);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assertions.assertEquals((int)6, (int)result);
            Assertions.assertEquals((int)6, (int)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assertions.assertEquals((Object)"12", (Object)new String(Objects.requireNonNull(sortedDictionary.get(0)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"abc", (Object)new String(Objects.requireNonNull(sortedDictionary.get(1)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"dictionary", (Object)new String(Objects.requireNonNull(sortedDictionary.get(2)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"good", (Object)new String(Objects.requireNonNull(sortedDictionary.get(3)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"hello", (Object)new String(Objects.requireNonNull(sortedDictionary.get(4)), StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"world", (Object)new String(Objects.requireNonNull(sortedDictionary.get(5)), StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testBuildFixedWidthDictionaryWithNull() {
        try (IntVector vec = new IntVector("", this.allocator);
             IntVector dictionary = new IntVector("", this.allocator);
             IntVector sortedDictionary = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, 4);
            vec.set(1, 8);
            vec.set(2, 32);
            vec.set(3, 8);
            vec.set(4, 16);
            vec.set(5, 32);
            vec.setNull(6);
            vec.set(7, 4);
            vec.set(8, 4);
            vec.setNull(9);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, true);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assertions.assertEquals((int)5, (int)result);
            Assertions.assertEquals((int)5, (int)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assertions.assertTrue((boolean)sortedDictionary.isNull(0));
            Assertions.assertEquals((int)4, (int)sortedDictionary.get(1));
            Assertions.assertEquals((int)8, (int)sortedDictionary.get(2));
            Assertions.assertEquals((int)16, (int)sortedDictionary.get(3));
            Assertions.assertEquals((int)32, (int)sortedDictionary.get(4));
        }
    }

    @Test
    public void testBuildFixedWidthDictionaryWithoutNull() {
        try (IntVector vec = new IntVector("", this.allocator);
             IntVector dictionary = new IntVector("", this.allocator);
             IntVector sortedDictionary = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, 4);
            vec.set(1, 8);
            vec.set(2, 32);
            vec.set(3, 8);
            vec.set(4, 16);
            vec.set(5, 32);
            vec.setNull(6);
            vec.set(7, 4);
            vec.set(8, 4);
            vec.setNull(9);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, false);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assertions.assertEquals((int)4, (int)result);
            Assertions.assertEquals((int)4, (int)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assertions.assertEquals((int)4, (int)sortedDictionary.get(0));
            Assertions.assertEquals((int)8, (int)sortedDictionary.get(1));
            Assertions.assertEquals((int)16, (int)sortedDictionary.get(2));
            Assertions.assertEquals((int)32, (int)sortedDictionary.get(3));
        }
    }
}

