/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import org.apache.arrow.algorithm.dictionary.HashTableDictionaryEncoder;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.ElementAddressableVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHashTableDictionaryEncoder {
    private final int VECTOR_LENGTH = 50;
    private final int DICTIONARY_LENGTH = 10;
    private BufferAllocator allocator;
    byte[] zero = "000".getBytes(StandardCharsets.UTF_8);
    byte[] one = "111".getBytes(StandardCharsets.UTF_8);
    byte[] two = "222".getBytes(StandardCharsets.UTF_8);
    byte[][] data = new byte[][]{this.zero, this.one, this.two};

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testEncodeAndDecode() {
        Random random = new Random();
        try (VarCharVector rawVector = new VarCharVector("original vector", this.allocator);
             IntVector encodedVector = new IntVector("encoded vector", this.allocator);
             VarCharVector dictionary = new VarCharVector("dictionary", this.allocator);){
            int i;
            dictionary.allocateNew();
            for (i = 0; i < 10; ++i) {
                dictionary.setSafe(i, String.valueOf(i).getBytes(StandardCharsets.UTF_8));
            }
            dictionary.setValueCount(10);
            rawVector.allocateNew(500L, 50);
            for (i = 0; i < 50; ++i) {
                int val = (random.nextInt() & Integer.MAX_VALUE) % 10;
                rawVector.set(i, String.valueOf(val).getBytes(StandardCharsets.UTF_8));
            }
            rawVector.setValueCount(50);
            HashTableDictionaryEncoder encoder = new HashTableDictionaryEncoder((ElementAddressableVector)dictionary, false);
            encodedVector.allocateNew();
            encoder.encode((ElementAddressableVector)rawVector, (BaseIntVector)encodedVector);
            Assertions.assertEquals((int)rawVector.getValueCount(), (int)encodedVector.getValueCount());
            for (int i2 = 0; i2 < 50; ++i2) {
                Assertions.assertArrayEquals((byte[])rawVector.get(i2), (byte[])String.valueOf(encodedVector.get(i2)).getBytes(StandardCharsets.UTF_8));
            }
            Dictionary dict = new Dictionary((FieldVector)dictionary, new DictionaryEncoding(1L, false, null));
            try (VarCharVector decodedVector = (VarCharVector)DictionaryEncoder.decode((ValueVector)encodedVector, (Dictionary)dict);){
                Assertions.assertEquals((int)encodedVector.getValueCount(), (int)decodedVector.getValueCount());
                for (int i3 = 0; i3 < 50; ++i3) {
                    Assertions.assertArrayEquals((byte[])String.valueOf(encodedVector.get(i3)).getBytes(StandardCharsets.UTF_8), (byte[])decodedVector.get(i3));
                }
            }
        }
    }

    @Test
    public void testEncodeAndDecodeWithNull() {
        Random random = new Random();
        try (VarCharVector rawVector = new VarCharVector("original vector", this.allocator);
             IntVector encodedVector = new IntVector("encoded vector", this.allocator);
             VarCharVector dictionary = new VarCharVector("dictionary", this.allocator);){
            int i;
            dictionary.allocateNew();
            dictionary.setNull(0);
            for (i = 1; i < 10; ++i) {
                dictionary.setSafe(i, String.valueOf(i).getBytes(StandardCharsets.UTF_8));
            }
            dictionary.setValueCount(10);
            rawVector.allocateNew(500L, 50);
            for (i = 0; i < 50; ++i) {
                if (i % 10 == 0) {
                    rawVector.setNull(i);
                    continue;
                }
                int val = (random.nextInt() & Integer.MAX_VALUE) % 9 + 1;
                rawVector.set(i, String.valueOf(val).getBytes(StandardCharsets.UTF_8));
            }
            rawVector.setValueCount(50);
            HashTableDictionaryEncoder encoder = new HashTableDictionaryEncoder((ElementAddressableVector)dictionary, true);
            encodedVector.allocateNew();
            encoder.encode((ElementAddressableVector)rawVector, (BaseIntVector)encodedVector);
            Assertions.assertEquals((int)rawVector.getValueCount(), (int)encodedVector.getValueCount());
            for (int i2 = 0; i2 < 50; ++i2) {
                if (i2 % 10 == 0) {
                    Assertions.assertEquals((int)0, (int)encodedVector.get(i2));
                    continue;
                }
                Assertions.assertArrayEquals((byte[])rawVector.get(i2), (byte[])String.valueOf(encodedVector.get(i2)).getBytes(StandardCharsets.UTF_8));
            }
            Dictionary dict = new Dictionary((FieldVector)dictionary, new DictionaryEncoding(1L, false, null));
            try (VarCharVector decodedVector = (VarCharVector)DictionaryEncoder.decode((ValueVector)encodedVector, (Dictionary)dict);){
                Assertions.assertEquals((int)encodedVector.getValueCount(), (int)decodedVector.getValueCount());
                for (int i3 = 0; i3 < 50; ++i3) {
                    if (i3 % 10 == 0) {
                        Assertions.assertTrue((boolean)decodedVector.isNull(i3));
                        continue;
                    }
                    Assertions.assertArrayEquals((byte[])String.valueOf(encodedVector.get(i3)).getBytes(StandardCharsets.UTF_8), (byte[])decodedVector.get(i3));
                }
            }
        }
    }

    @Test
    public void testEncodeNullWithoutNullInDictionary() {
        try (VarCharVector rawVector = new VarCharVector("original vector", this.allocator);
             IntVector encodedVector = new IntVector("encoded vector", this.allocator);
             VarCharVector dictionary = new VarCharVector("dictionary", this.allocator);){
            dictionary.allocateNew();
            for (int i = 0; i < 10; ++i) {
                dictionary.setSafe(i, String.valueOf(i).getBytes(StandardCharsets.UTF_8));
            }
            dictionary.setValueCount(10);
            rawVector.allocateNew(1);
            rawVector.setNull(0);
            rawVector.setValueCount(1);
            encodedVector.allocateNew();
            HashTableDictionaryEncoder encoder = new HashTableDictionaryEncoder((ElementAddressableVector)dictionary, true);
            Assertions.assertThrows(IllegalArgumentException.class, () -> encoder.encode((ElementAddressableVector)rawVector, (BaseIntVector)encodedVector));
        }
    }

    @Test
    public void testEncodeStrings() {
        try (VarCharVector vector = new VarCharVector("foo", this.allocator);
             IntVector encoded = new IntVector("encoded", this.allocator);
             VarCharVector dictionaryVector = new VarCharVector("dict", this.allocator);){
            vector.allocateNew(512L, 5);
            encoded.allocateNew();
            vector.setSafe(0, this.zero, 0, this.zero.length);
            vector.setSafe(1, this.one, 0, this.one.length);
            vector.setSafe(2, this.one, 0, this.one.length);
            vector.setSafe(3, this.two, 0, this.two.length);
            vector.setSafe(4, this.zero, 0, this.zero.length);
            vector.setValueCount(5);
            dictionaryVector.allocateNew(512L, 3);
            dictionaryVector.setSafe(0, this.zero, 0, this.one.length);
            dictionaryVector.setSafe(1, this.one, 0, this.two.length);
            dictionaryVector.setSafe(2, this.two, 0, this.zero.length);
            dictionaryVector.setValueCount(3);
            HashTableDictionaryEncoder encoder = new HashTableDictionaryEncoder((ElementAddressableVector)dictionaryVector);
            encoder.encode((ElementAddressableVector)vector, (BaseIntVector)encoded);
            Assertions.assertEquals((int)5, (int)encoded.getValueCount());
            Assertions.assertEquals((int)0, (int)encoded.get(0));
            Assertions.assertEquals((int)1, (int)encoded.get(1));
            Assertions.assertEquals((int)1, (int)encoded.get(2));
            Assertions.assertEquals((int)2, (int)encoded.get(3));
            Assertions.assertEquals((int)0, (int)encoded.get(4));
            Dictionary dict = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (VarCharVector decoded = (VarCharVector)DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dict);){
                Assertions.assertEquals((int)vector.getValueCount(), (int)decoded.getValueCount());
                for (int i = 0; i < 5; ++i) {
                    Assertions.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                }
            }
        }
    }

    @Test
    public void testEncodeLargeVector() {
        try (VarCharVector vector = new VarCharVector("foo", this.allocator);
             IntVector encoded = new IntVector("encoded", this.allocator);
             VarCharVector dictionaryVector = new VarCharVector("dict", this.allocator);){
            vector.allocateNew();
            encoded.allocateNew();
            int count = 10000;
            for (int i = 0; i < 10000; ++i) {
                vector.setSafe(i, this.data[i % 3], 0, this.data[i % 3].length);
            }
            vector.setValueCount(count);
            dictionaryVector.allocateNew(512L, 3);
            dictionaryVector.setSafe(0, this.zero, 0, this.one.length);
            dictionaryVector.setSafe(1, this.one, 0, this.two.length);
            dictionaryVector.setSafe(2, this.two, 0, this.zero.length);
            dictionaryVector.setValueCount(3);
            HashTableDictionaryEncoder encoder = new HashTableDictionaryEncoder((ElementAddressableVector)dictionaryVector);
            encoder.encode((ElementAddressableVector)vector, (BaseIntVector)encoded);
            Assertions.assertEquals((int)count, (int)encoded.getValueCount());
            for (int i = 0; i < count; ++i) {
                Assertions.assertEquals((int)(i % 3), (int)encoded.get(i));
            }
            Dictionary dict = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (VarCharVector decoded = (VarCharVector)DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dict);){
                Assertions.assertEquals(vector.getClass(), decoded.getClass());
                Assertions.assertEquals((int)vector.getValueCount(), (int)decoded.getValueCount());
                for (int i = 0; i < count; ++i) {
                    Assertions.assertEquals((Object)vector.getObject(i), (Object)decoded.getObject(i));
                }
            }
        }
    }

    @Test
    public void testEncodeBinaryVector() {
        try (VarBinaryVector vector = new VarBinaryVector("foo", this.allocator);
             VarBinaryVector dictionaryVector = new VarBinaryVector("dict", this.allocator);
             IntVector encoded = new IntVector("encoded", this.allocator);){
            vector.allocateNew(512L, 5);
            vector.allocateNew();
            encoded.allocateNew();
            vector.setSafe(0, this.zero, 0, this.zero.length);
            vector.setSafe(1, this.one, 0, this.one.length);
            vector.setSafe(2, this.one, 0, this.one.length);
            vector.setSafe(3, this.two, 0, this.two.length);
            vector.setSafe(4, this.zero, 0, this.zero.length);
            vector.setValueCount(5);
            dictionaryVector.allocateNew(512L, 3);
            dictionaryVector.setSafe(0, this.zero, 0, this.one.length);
            dictionaryVector.setSafe(1, this.one, 0, this.two.length);
            dictionaryVector.setSafe(2, this.two, 0, this.zero.length);
            dictionaryVector.setValueCount(3);
            HashTableDictionaryEncoder encoder = new HashTableDictionaryEncoder((ElementAddressableVector)dictionaryVector);
            encoder.encode((ElementAddressableVector)vector, (BaseIntVector)encoded);
            Assertions.assertEquals((int)5, (int)encoded.getValueCount());
            Assertions.assertEquals((int)0, (int)encoded.get(0));
            Assertions.assertEquals((int)1, (int)encoded.get(1));
            Assertions.assertEquals((int)1, (int)encoded.get(2));
            Assertions.assertEquals((int)2, (int)encoded.get(3));
            Assertions.assertEquals((int)0, (int)encoded.get(4));
            Dictionary dict = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (VarBinaryVector decoded = (VarBinaryVector)DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dict);){
                Assertions.assertEquals(vector.getClass(), decoded.getClass());
                Assertions.assertEquals((int)vector.getValueCount(), (int)decoded.getValueCount());
                for (int i = 0; i < 5; ++i) {
                    Assertions.assertTrue((boolean)Arrays.equals(vector.getObject(i), decoded.getObject(i)));
                }
            }
        }
    }
}

