/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.deduplicate;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.algorithm.deduplicate.VectorRunDeduplicator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVectorRunDeduplicator {
    private static final int VECTOR_LENGTH = 100;
    private static final int REPETITION_COUNT = 3;
    private BufferAllocator allocator;

    @BeforeEach
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @AfterEach
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testDeduplicateFixedWidth() {
        try (IntVector origVec = new IntVector("original vec", this.allocator);
             IntVector dedupVec = new IntVector("deduplicated vec", this.allocator);
             IntVector lengthVec = new IntVector("length vec", this.allocator);
             VectorRunDeduplicator deduplicator = new VectorRunDeduplicator((ValueVector)origVec, this.allocator);){
            int i;
            origVec.allocateNew(300);
            origVec.setValueCount(300);
            lengthVec.allocateNew();
            for (int i2 = 0; i2 < 100; ++i2) {
                for (int j = 0; j < 3; ++j) {
                    origVec.set(i2 * 3 + j, i2);
                }
            }
            int distinctCount = deduplicator.getRunCount();
            Assertions.assertEquals((int)100, (int)distinctCount);
            dedupVec.allocateNew(distinctCount);
            deduplicator.populateDeduplicatedValues((ValueVector)dedupVec);
            Assertions.assertEquals((int)100, (int)dedupVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assertions.assertEquals((int)i, (int)dedupVec.get(i));
            }
            deduplicator.populateRunLengths(lengthVec);
            Assertions.assertEquals((int)100, (int)lengthVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assertions.assertEquals((int)3, (int)lengthVec.get(i));
            }
        }
    }

    @Test
    public void testDeduplicateVariableWidth() {
        try (VarCharVector origVec = new VarCharVector("original vec", this.allocator);
             VarCharVector dedupVec = new VarCharVector("deduplicated vec", this.allocator);
             IntVector lengthVec = new IntVector("length vec", this.allocator);
             VectorRunDeduplicator deduplicator = new VectorRunDeduplicator((ValueVector)origVec, this.allocator);){
            int i;
            origVec.allocateNew(3000L, 300);
            origVec.setValueCount(300);
            lengthVec.allocateNew();
            for (int i2 = 0; i2 < 100; ++i2) {
                String str = String.valueOf(i2 * i2);
                for (int j = 0; j < 3; ++j) {
                    origVec.set(i2 * 3 + j, str.getBytes(StandardCharsets.UTF_8));
                }
            }
            int distinctCount = deduplicator.getRunCount();
            Assertions.assertEquals((int)100, (int)distinctCount);
            dedupVec.allocateNew((long)distinctCount * 10L, distinctCount);
            deduplicator.populateDeduplicatedValues((ValueVector)dedupVec);
            Assertions.assertEquals((int)100, (int)dedupVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assertions.assertArrayEquals((byte[])String.valueOf(i * i).getBytes(StandardCharsets.UTF_8), (byte[])dedupVec.get(i));
            }
            deduplicator.populateRunLengths(lengthVec);
            Assertions.assertEquals((int)100, (int)lengthVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assertions.assertEquals((int)3, (int)lengthVec.get(i));
            }
        }
    }
}

