/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.TestSortingUtil;
import org.apache.arrow.algorithm.sort.VariableWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.Text;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestVariableWidthSorting<V extends BaseVariableWidthVector, U extends Comparable<U>> {
    static final int[] VECTOR_LENGTHS = new int[]{2, 5, 10, 50, 100, 1000, 3000};
    static final double[] NULL_FRACTIONS = new double[]{0.0, 0.1, 0.3, 0.5, 0.7, 0.9, 1.0};
    private final int length;
    private final double nullFraction;
    private final Function<BufferAllocator, V> vectorGenerator;
    private final TestSortingUtil.DataGenerator<V, U> dataGenerator;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    public TestVariableWidthSorting(int length, double nullFraction, String desc, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        this.length = length;
        this.nullFraction = nullFraction;
        this.vectorGenerator = vectorGenerator;
        this.dataGenerator = dataGenerator;
    }

    @Test
    public void testSort() {
        this.sortOutOfPlace();
    }

    void sortOutOfPlace() {
        try (BaseVariableWidthVector vector = (BaseVariableWidthVector)this.vectorGenerator.apply(this.allocator);){
            Comparable[] array = this.dataGenerator.populate((ValueVector)vector, this.length, this.nullFraction);
            Arrays.sort(array, new StringComparator());
            VariableWidthOutOfPlaceVectorSorter sorter = new VariableWidthOutOfPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            try (BaseVariableWidthVector sortedVec = (BaseVariableWidthVector)vector.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                int dataSize = vector.getOffsetBuffer().getInt((long)(vector.getValueCount() * 4));
                sortedVec.allocateNew((long)dataSize, vector.getValueCount());
                sortedVec.setValueCount(vector.getValueCount());
                sorter.sortOutOfPlace(vector, sortedVec, comparator);
                TestVariableWidthSorting.verifyResults(sortedVec, (String[])array);
            }
        }
    }

    @Parameterized.Parameters(name="length = {0}, null fraction = {1}, vector = {2}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int length : VECTOR_LENGTHS) {
            for (double nullFrac : NULL_FRACTIONS) {
                params.add(new Object[]{length, nullFrac, "VarCharVector", allocator -> new VarCharVector("vector", allocator), TestSortingUtil.STRING_GENERATOR});
            }
        }
        return params;
    }

    public static <V extends ValueVector> void verifyResults(V vector, String[] expected) {
        Assertions.assertEquals((int)vector.getValueCount(), (int)expected.length);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == null) {
                Assertions.assertTrue((boolean)vector.isNull(i));
                continue;
            }
            Assertions.assertArrayEquals((byte[])((Text)vector.getObject(i)).getBytes(), (byte[])expected[i].getBytes());
        }
    }

    static class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            if (str1 == null || str2 == null) {
                if (str1 == null && str2 == null) {
                    return 0;
                }
                return str1 == null ? -1 : 1;
            }
            byte[] bytes1 = str1.getBytes();
            byte[] bytes2 = str2.getBytes();
            for (int i = 0; i < bytes1.length && i < bytes2.length; ++i) {
                if (bytes1[i] == bytes2[i]) continue;
                return (bytes1[i] & 0xFF) < (bytes2[i] & 0xFF) ? -1 : 1;
            }
            return bytes1.length - bytes2.length;
        }
    }
}

