/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.GeneralOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.TestOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VariableWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVariableWidthOutOfPlaceVectorSorter
extends TestOutOfPlaceVectorSorter {
    private BufferAllocator allocator;

    public TestVariableWidthOutOfPlaceVectorSorter(boolean generalSorter) {
        super(generalSorter);
    }

    <V extends BaseVariableWidthVector> OutOfPlaceVectorSorter<V> getSorter() {
        return this.generalSorter ? new GeneralOutOfPlaceVectorSorter() : new VariableWidthOutOfPlaceVectorSorter();
    }

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testSortString() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            vec.set(0, "hello".getBytes());
            vec.set(1, "abc".getBytes());
            vec.setNull(2);
            vec.set(3, "world".getBytes());
            vec.set(4, "12".getBytes());
            vec.set(5, "dictionary".getBytes());
            vec.setNull(6);
            vec.set(7, "hello".getBytes());
            vec.set(8, "good".getBytes());
            vec.set(9, "yes".getBytes());
            OutOfPlaceVectorSorter sorter = this.getSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            VarCharVector sortedVec = (VarCharVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);
            sortedVec.allocateNew((long)vec.getByteCapacity(), vec.getValueCount());
            sortedVec.setLastSet(vec.getValueCount() - 1);
            sortedVec.setValueCount(vec.getValueCount());
            sorter.sortOutOfPlace((ValueVector)vec, (ValueVector)sortedVec, comparator);
            Assert.assertEquals((long)vec.getValueCount(), (long)sortedVec.getValueCount());
            Assert.assertEquals((long)vec.getByteCapacity(), (long)sortedVec.getByteCapacity());
            Assert.assertEquals((long)vec.getLastSet(), (long)sortedVec.getLastSet());
            Assert.assertTrue((boolean)sortedVec.isNull(0));
            Assert.assertTrue((boolean)sortedVec.isNull(1));
            Assert.assertEquals((Object)"12", (Object)new String(sortedVec.get(2)));
            Assert.assertEquals((Object)"abc", (Object)new String(sortedVec.get(3)));
            Assert.assertEquals((Object)"dictionary", (Object)new String(sortedVec.get(4)));
            Assert.assertEquals((Object)"good", (Object)new String(sortedVec.get(5)));
            Assert.assertEquals((Object)"hello", (Object)new String(sortedVec.get(6)));
            Assert.assertEquals((Object)"hello", (Object)new String(sortedVec.get(7)));
            Assert.assertEquals((Object)"world", (Object)new String(sortedVec.get(8)));
            Assert.assertEquals((Object)"yes", (Object)new String(sortedVec.get(9)));
            sortedVec.close();
        }
    }
}

