/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.StableVectorComparator;
import org.apache.arrow.algorithm.sort.VariableWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestStableVectorComparator {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testCompare() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 5);
            vec.setValueCount(10);
            vec.set(0, "ba".getBytes());
            vec.set(1, "abc".getBytes());
            vec.set(2, "aa".getBytes());
            vec.set(3, "abc".getBytes());
            vec.set(4, "a".getBytes());
            TestVarCharSorter comparator = new TestVarCharSorter();
            StableVectorComparator stableComparator = new StableVectorComparator((VectorValueComparator)comparator);
            stableComparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((stableComparator.compare(0, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(2, 3) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(1, 3) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(3, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((stableComparator.compare(3, 3) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStableSortString() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            vec.set(0, "a".getBytes());
            vec.set(1, "abc".getBytes());
            vec.set(2, "aa".getBytes());
            vec.set(3, "a1".getBytes());
            vec.set(4, "abcdefg".getBytes());
            vec.set(5, "accc".getBytes());
            vec.set(6, "afds".getBytes());
            vec.set(7, "0".getBytes());
            vec.set(8, "01".getBytes());
            vec.set(9, "0c".getBytes());
            VariableWidthOutOfPlaceVectorSorter sorter = new VariableWidthOutOfPlaceVectorSorter();
            TestVarCharSorter comparator = new TestVarCharSorter();
            StableVectorComparator stableComparator = new StableVectorComparator((VectorValueComparator)comparator);
            try (VarCharVector sortedVec = (VarCharVector)vec.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                sortedVec.allocateNew((long)vec.getByteCapacity(), vec.getValueCount());
                sortedVec.setLastSet(vec.getValueCount() - 1);
                sortedVec.setValueCount(vec.getValueCount());
                sorter.sortOutOfPlace((BaseVariableWidthVector)vec, (BaseVariableWidthVector)sortedVec, (VectorValueComparator)stableComparator);
                Assert.assertEquals((Object)"0", (Object)new String(sortedVec.get(0)));
                Assert.assertEquals((Object)"01", (Object)new String(sortedVec.get(1)));
                Assert.assertEquals((Object)"0c", (Object)new String(sortedVec.get(2)));
                Assert.assertEquals((Object)"a", (Object)new String(sortedVec.get(3)));
                Assert.assertEquals((Object)"abc", (Object)new String(sortedVec.get(4)));
                Assert.assertEquals((Object)"aa", (Object)new String(sortedVec.get(5)));
                Assert.assertEquals((Object)"a1", (Object)new String(sortedVec.get(6)));
                Assert.assertEquals((Object)"abcdefg", (Object)new String(sortedVec.get(7)));
                Assert.assertEquals((Object)"accc", (Object)new String(sortedVec.get(8)));
                Assert.assertEquals((Object)"afds", (Object)new String(sortedVec.get(9)));
            }
        }
    }

    private static class TestVarCharSorter
    extends VectorValueComparator<VarCharVector> {
        private TestVarCharSorter() {
        }

        public int compareNotNull(int index1, int index2) {
            byte b1 = ((VarCharVector)this.vector1).get(index1)[0];
            byte b2 = ((VarCharVector)this.vector2).get(index2)[0];
            return b1 - b2;
        }

        public VectorValueComparator<VarCharVector> createNew() {
            return new TestVarCharSorter();
        }
    }
}

