/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.testing.RandomDataGenerator;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.junit.jupiter.api.Assertions;

public class TestSortingUtil {
    static final Random random = new Random(0L);
    static final DataGenerator<TinyIntVector, Byte> TINY_INT_GENERATOR = new DataGenerator<TinyIntVector, Byte>(RandomDataGenerator.TINY_INT_GENERATOR, (vector, array) -> ValueVectorDataPopulator.setVector((TinyIntVector)vector, (Byte[])array), Byte.class);
    static final DataGenerator<SmallIntVector, Short> SMALL_INT_GENERATOR = new DataGenerator<SmallIntVector, Short>(RandomDataGenerator.SMALL_INT_GENERATOR, (vector, array) -> ValueVectorDataPopulator.setVector((SmallIntVector)vector, (Short[])array), Short.class);
    static final DataGenerator<IntVector, Integer> INT_GENERATOR = new DataGenerator<IntVector, Integer>(RandomDataGenerator.INT_GENERATOR, (vector, array) -> ValueVectorDataPopulator.setVector((IntVector)vector, (Integer[])array), Integer.class);
    static final DataGenerator<BigIntVector, Long> LONG_GENERATOR = new DataGenerator<BigIntVector, Long>(RandomDataGenerator.LONG_GENERATOR, (vector, array) -> ValueVectorDataPopulator.setVector((BigIntVector)vector, (Long[])array), Long.class);
    static final DataGenerator<Float4Vector, Float> FLOAT_GENERATOR = new DataGenerator<Float4Vector, Float>(RandomDataGenerator.FLOAT_GENERATOR, (vector, array) -> ValueVectorDataPopulator.setVector((Float4Vector)vector, (Float[])array), Float.class);
    static final DataGenerator<Float8Vector, Double> DOUBLE_GENERATOR = new DataGenerator<Float8Vector, Double>(RandomDataGenerator.DOUBLE_GENERATOR, (vector, array) -> ValueVectorDataPopulator.setVector((Float8Vector)vector, (Double[])array), Double.class);
    static final DataGenerator<VarCharVector, String> STRING_GENERATOR = new DataGenerator<VarCharVector, String>(() -> {
        int strLength = random.nextInt(20) + 1;
        return TestSortingUtil.generateRandomString(strLength);
    }, (vector, array) -> ValueVectorDataPopulator.setVector((VarCharVector)vector, (String[])array), String.class);

    private TestSortingUtil() {
    }

    public static <V extends ValueVector, U> void verifyResults(V vector, U[] expected) {
        Assertions.assertEquals((int)vector.getValueCount(), (int)expected.length);
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)vector.getObject(i), expected[i]);
        }
    }

    public static <U extends Comparable<U>> void sortArray(U[] array) {
        Arrays.sort(array, (a, b) -> {
            if (a == null || b == null) {
                if (a == null && b == null) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                return 1;
            }
            return a.compareTo(b);
        });
    }

    static String generateRandomString(int length) {
        byte[] str = new byte[length];
        int lower = 97;
        int upper = 122;
        for (int i = 0; i < length; ++i) {
            int r = random.nextInt() & Integer.MAX_VALUE;
            str[i] = (byte)(r % 26 + 97);
        }
        return new String(str);
    }

    static class DataGenerator<V extends ValueVector, U extends Comparable<U>> {
        final Supplier<U> dataGenerator;
        final BiConsumer<V, U[]> vectorPopulator;
        final Class<U> clazz;

        DataGenerator(Supplier<U> dataGenerator, BiConsumer<V, U[]> vectorPopulator, Class<U> clazz) {
            this.dataGenerator = dataGenerator;
            this.vectorPopulator = vectorPopulator;
            this.clazz = clazz;
        }

        U[] populate(V vector, int length, double nullFraction) {
            Comparable[] array = (Comparable[])Array.newInstance(this.clazz, length);
            for (int i = 0; i < length; ++i) {
                Comparable value;
                double r = Math.random();
                array[i] = value = r < nullFraction ? null : (Comparable)this.dataGenerator.get();
            }
            this.vectorPopulator.accept(vector, (Comparable[][])array);
            return array;
        }
    }
}

