/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import junit.framework.TestCase;
import org.apache.arrow.algorithm.sort.OffHeapIntStack;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestOffHeapIntStack {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testPushPop() {
        try (OffHeapIntStack stack = new OffHeapIntStack(this.allocator);){
            int i;
            TestCase.assertTrue((boolean)stack.isEmpty());
            int elemCount = 500;
            for (i = 0; i < 500; ++i) {
                stack.push(i);
                TestCase.assertEquals((int)i, (int)stack.getTop());
            }
            TestCase.assertEquals((int)500, (int)stack.getCount());
            for (i = 0; i < 500; ++i) {
                TestCase.assertEquals((int)(500 - i - 1), (int)stack.getTop());
                TestCase.assertEquals((int)(500 - i - 1), (int)stack.pop());
            }
            TestCase.assertTrue((boolean)stack.isEmpty());
        }
    }
}

