/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.InsertionSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestInsertionSorter {
    private BufferAllocator allocator;
    private static final int VECTOR_LENGTH = 10;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    private void testSortIntVectorRange(int start, int end, int[] expected) {
        try (IntVector vector = new IntVector("vector", this.allocator);
             IntVector buffer = new IntVector("buffer", this.allocator);){
            buffer.allocateNew(1);
            ValueVectorDataPopulator.setVector((IntVector)vector, (Integer[])new Integer[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
            Assertions.assertEquals((int)10, (int)vector.getValueCount());
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            InsertionSorter.insertionSort((BaseFixedWidthVector)vector, (int)start, (int)end, (VectorValueComparator)comparator, (BaseFixedWidthVector)buffer);
            Assertions.assertEquals((int)10, (int)expected.length);
            for (int i = 0; i < 10; ++i) {
                Assert.assertFalse((boolean)vector.isNull(i));
                Assertions.assertEquals((int)expected[i], (int)vector.get(i));
            }
        }
    }

    @Test
    public void testSortIntVector() {
        this.testSortIntVectorRange(2, 5, new int[]{9, 8, 4, 5, 6, 7, 3, 2, 1, 0});
        this.testSortIntVectorRange(3, 7, new int[]{9, 8, 7, 2, 3, 4, 5, 6, 1, 0});
        this.testSortIntVectorRange(3, 4, new int[]{9, 8, 7, 5, 6, 4, 3, 2, 1, 0});
        this.testSortIntVectorRange(7, 7, new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
        this.testSortIntVectorRange(0, 5, new int[]{4, 5, 6, 7, 8, 9, 3, 2, 1, 0});
        this.testSortIntVectorRange(8, 9, new int[]{9, 8, 7, 6, 5, 4, 3, 2, 0, 1});
        this.testSortIntVectorRange(0, 9, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    private void testSortIndicesRange(int start, int end, int[] expectedIndices) {
        try (IntVector vector = new IntVector("vector", this.allocator);
             IntVector indices = new IntVector("indices", this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vector, (Integer[])new Integer[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
            Assertions.assertEquals((int)10, (int)vector.getValueCount());
            Assertions.assertEquals((int)10, (int)indices.getValueCount());
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            comparator.attachVector((ValueVector)vector);
            InsertionSorter.insertionSort((IntVector)indices, (int)start, (int)end, (VectorValueComparator)comparator);
            Assertions.assertEquals((int)10, (int)expectedIndices.length);
            for (int i = 0; i < 10; ++i) {
                Assert.assertFalse((boolean)indices.isNull(i));
                Assertions.assertEquals((int)expectedIndices[i], (int)indices.get(i));
            }
        }
    }

    @Test
    public void testSortIndices() {
        this.testSortIndicesRange(2, 5, new int[]{0, 1, 5, 4, 3, 2, 6, 7, 8, 9});
        this.testSortIndicesRange(3, 7, new int[]{0, 1, 2, 7, 6, 5, 4, 3, 8, 9});
        this.testSortIndicesRange(3, 4, new int[]{0, 1, 2, 4, 3, 5, 6, 7, 8, 9});
        this.testSortIndicesRange(7, 7, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        this.testSortIndicesRange(0, 5, new int[]{5, 4, 3, 2, 1, 0, 6, 7, 8, 9});
        this.testSortIndicesRange(8, 9, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 9, 8});
        this.testSortIndicesRange(0, 9, new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0});
    }
}

