/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestIndexSorter {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testIndexSort() {
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{11, 8, 33, 10, 12, 17, null, 23, 35, 2});
            IndexSorter indexSorter = new IndexSorter();
            DefaultVectorComparators.IntComparator intComparator = new DefaultVectorComparators.IntComparator();
            intComparator.attachVector((ValueVector)vec);
            IntVector indices = new IntVector("", this.allocator);
            indices.setValueCount(10);
            indexSorter.sort((ValueVector)vec, indices, (VectorValueComparator)intComparator);
            int[] expected = new int[]{6, 9, 1, 3, 0, 4, 5, 7, 2, 8};
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertTrue((!indices.isNull(i) ? 1 : 0) != 0);
                Assert.assertEquals((long)expected[i], (long)indices.get(i));
            }
            indices.close();
        }
    }

    @Test
    public void testSortLargeIncreasingInt() {
        int vectorLength = 20000;
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(20000);
            vec.setValueCount(20000);
            for (int i = 0; i < 20000; ++i) {
                vec.set(i, i);
            }
            IndexSorter indexSorter = new IndexSorter();
            DefaultVectorComparators.IntComparator intComparator = new DefaultVectorComparators.IntComparator();
            intComparator.attachVector((ValueVector)vec);
            try (IntVector indices = new IntVector("", this.allocator);){
                indices.setValueCount(20000);
                indexSorter.sort((ValueVector)vec, indices, (VectorValueComparator)intComparator);
                for (int i = 0; i < 20000; ++i) {
                    Assert.assertTrue((!indices.isNull(i) ? 1 : 0) != 0);
                    Assert.assertEquals((long)i, (long)indices.get(i));
                }
            }
        }
    }

    @Test
    public void testChoosePivot() {
        int vectorLength = 100;
        try (IntVector vec = new IntVector("vector", this.allocator);
             IntVector indices = new IntVector("indices", this.allocator);){
            vec.allocateNew(100);
            indices.allocateNew(100);
            for (int i = 0; i < 100; ++i) {
                vec.set(i, i * 100);
                indices.set(i, i);
            }
            vec.setValueCount(100);
            indices.setValueCount(100);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            int low = 5;
            int high = 6;
            Assert.assertTrue((high - low + 1 < 3 ? 1 : 0) != 0);
            int pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)pivotIndex, (long)low);
            Assert.assertEquals((long)pivotIndex, (long)indices.get(low));
            low = 30;
            high = 80;
            Assert.assertTrue((high - low + 1 >= 3 ? 1 : 0) != 0);
            pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)pivotIndex, (long)((low + high) / 2));
            Assert.assertEquals((long)pivotIndex, (long)indices.get(low));
        }
    }

    @Test
    public void testChoosePivotAllPermutes() {
        try (IntVector vec = new IntVector("vector", this.allocator);
             IntVector indices = new IntVector("indices", this.allocator);){
            vec.allocateNew();
            indices.allocateNew();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            int low = 0;
            int high = 2;
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2});
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{11, 22, 33});
            int pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)1L, (long)pivotIndex);
            Assert.assertEquals((long)1L, (long)indices.get(low));
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2});
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{11, 33, 22});
            pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)2L, (long)pivotIndex);
            Assert.assertEquals((long)2L, (long)indices.get(low));
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2});
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{22, 11, 33});
            pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)0L, (long)pivotIndex);
            Assert.assertEquals((long)0L, (long)indices.get(low));
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2});
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{22, 33, 11});
            pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)0L, (long)pivotIndex);
            Assert.assertEquals((long)0L, (long)indices.get(low));
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2});
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{33, 11, 22});
            pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)2L, (long)pivotIndex);
            Assert.assertEquals((long)2L, (long)indices.get(low));
            ValueVectorDataPopulator.setVector((IntVector)indices, (Integer[])new Integer[]{0, 1, 2});
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{33, 22, 11});
            pivotIndex = IndexSorter.choosePivot((int)low, (int)high, (IntVector)indices, (VectorValueComparator)comparator);
            Assert.assertEquals((long)1L, (long)pivotIndex);
            Assert.assertEquals((long)1L, (long)indices.get(low));
        }
    }
}

