/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.FixedWidthInPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.FixedWidthOutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.TestSortingUtil;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFixedWidthSorting<V extends BaseFixedWidthVector, U extends Comparable<U>> {
    static final int[] VECTOR_LENGTHS = new int[]{2, 5, 10, 50, 100, 1000, 3000};
    static final double[] NULL_FRACTIONS = new double[]{0.0, 0.1, 0.3, 0.5, 0.7, 0.9, 1.0};
    private final int length;
    private final double nullFraction;
    private final boolean inPlace;
    private final Function<BufferAllocator, V> vectorGenerator;
    private final TestSortingUtil.DataGenerator<V, U> dataGenerator;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    public TestFixedWidthSorting(int length, double nullFraction, boolean inPlace, String desc, Function<BufferAllocator, V> vectorGenerator, TestSortingUtil.DataGenerator<V, U> dataGenerator) {
        this.length = length;
        this.nullFraction = nullFraction;
        this.inPlace = inPlace;
        this.vectorGenerator = vectorGenerator;
        this.dataGenerator = dataGenerator;
    }

    @Test
    public void testSort() {
        if (this.inPlace) {
            this.sortInPlace();
        } else {
            this.sortOutOfPlace();
        }
    }

    void sortInPlace() {
        try (BaseFixedWidthVector vector = (BaseFixedWidthVector)this.vectorGenerator.apply(this.allocator);){
            Comparable[] array = this.dataGenerator.populate((ValueVector)vector, this.length, this.nullFraction);
            TestSortingUtil.sortArray((Comparable[])array);
            FixedWidthInPlaceVectorSorter sorter = new FixedWidthInPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            sorter.sortInPlace(vector, comparator);
            TestSortingUtil.verifyResults(vector, array);
        }
    }

    void sortOutOfPlace() {
        try (BaseFixedWidthVector vector = (BaseFixedWidthVector)this.vectorGenerator.apply(this.allocator);){
            Comparable[] array = this.dataGenerator.populate((ValueVector)vector, this.length, this.nullFraction);
            TestSortingUtil.sortArray((Comparable[])array);
            FixedWidthOutOfPlaceVectorSorter sorter = new FixedWidthOutOfPlaceVectorSorter();
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vector);
            try (BaseFixedWidthVector sortedVec = (BaseFixedWidthVector)vector.getField().getFieldType().createNewSingleVector("", this.allocator, null);){
                sortedVec.allocateNew(vector.getValueCount());
                sortedVec.setValueCount(vector.getValueCount());
                sorter.sortOutOfPlace(vector, sortedVec, comparator);
                TestSortingUtil.verifyResults(sortedVec, array);
            }
        }
    }

    @Parameterized.Parameters(name="length = {0}, null fraction = {1}, in place = {2}, vector = {3}")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int length : VECTOR_LENGTHS) {
            for (double nullFrac : NULL_FRACTIONS) {
                for (boolean inPlace : new boolean[]{true, false}) {
                    params.add(new Object[]{length, nullFrac, inPlace, "TinyIntVector", allocator -> new TinyIntVector("vector", allocator), TestSortingUtil.TINY_INT_GENERATOR});
                    params.add(new Object[]{length, nullFrac, inPlace, "SmallIntVector", allocator -> new SmallIntVector("vector", allocator), TestSortingUtil.SMALL_INT_GENERATOR});
                    params.add(new Object[]{length, nullFrac, inPlace, "IntVector", allocator -> new IntVector("vector", allocator), TestSortingUtil.INT_GENERATOR});
                    params.add(new Object[]{length, nullFrac, inPlace, "BigIntVector", allocator -> new BigIntVector("vector", allocator), TestSortingUtil.LONG_GENERATOR});
                    params.add(new Object[]{length, nullFrac, inPlace, "Float4Vector", allocator -> new Float4Vector("vector", allocator), TestSortingUtil.FLOAT_GENERATOR});
                    params.add(new Object[]{length, nullFrac, inPlace, "Float8Vector", allocator -> new Float8Vector("vector", allocator), TestSortingUtil.DOUBLE_GENERATOR});
                }
            }
        }
        return params;
    }
}

