/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalDayVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.LargeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.testing.ValueVectorDataPopulator;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestDefaultVectorComparator {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    private ListVector createListVector(int count) {
        ListVector listVector = ListVector.empty((String)"list vector", (BufferAllocator)this.allocator);
        Types.MinorType type = Types.MinorType.INT;
        listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        listVector.allocateNew();
        IntVector dataVector = (IntVector)listVector.getDataVector();
        for (int i = 0; i < count; ++i) {
            dataVector.set(i, i);
        }
        dataVector.setValueCount(count);
        listVector.setNotNull(0);
        listVector.getOffsetBuffer().setInt(0L, 0);
        listVector.getOffsetBuffer().setInt(4L, count);
        listVector.setLastSet(0);
        listVector.setValueCount(1);
        return listVector;
    }

    @Test
    public void testCompareLists() {
        VectorValueComparator comparator2;
        Throwable throwable;
        ListVector listVector2;
        try (ListVector listVector1 = this.createListVector(10);){
            listVector2 = this.createListVector(11);
            throwable = null;
            try {
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                comparator2.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                Assertions.assertTrue((comparator2.compare(0, 0) < 0 ? 1 : 0) != 0);
            }
            catch (Throwable comparator2) {
                throwable = comparator2;
                throw comparator2;
            }
            finally {
                if (listVector2 != null) {
                    TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)listVector2);
                }
            }
        }
        listVector1 = this.createListVector(11);
        var2_2 = null;
        try {
            listVector2 = this.createListVector(11);
            throwable = null;
            try {
                ((IntVector)listVector2.getDataVector()).set(10, 110);
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                comparator2.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                Assertions.assertTrue((comparator2.compare(0, 0) < 0 ? 1 : 0) != 0);
            }
            catch (Throwable comparator3) {
                throwable = comparator3;
                throw comparator3;
            }
            finally {
                if (listVector2 != null) {
                    TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)listVector2);
                }
            }
        }
        catch (Throwable listVector22) {
            var2_2 = listVector22;
            throw listVector22;
        }
        finally {
            if (listVector1 != null) {
                TestDefaultVectorComparator.$closeResource(var2_2, (AutoCloseable)listVector1);
            }
        }
        listVector1 = this.createListVector(10);
        var2_2 = null;
        try {
            listVector2 = this.createListVector(10);
            throwable = null;
            try {
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                comparator2.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                Assertions.assertTrue((comparator2.compare(0, 0) == 0 ? 1 : 0) != 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (listVector2 != null) {
                    TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)listVector2);
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            if (listVector1 != null) {
                TestDefaultVectorComparator.$closeResource(var2_2, (AutoCloseable)listVector1);
            }
        }
    }

    @Test
    public void testCopiedComparatorForLists() {
        for (int i = 1; i < 10; ++i) {
            for (int j = 1; j < 10; ++j) {
                try (ListVector listVector1 = this.createListVector(10);
                     ListVector listVector2 = this.createListVector(11);){
                    VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                    comparator.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                    VectorValueComparator copyComparator = comparator.createNew();
                    copyComparator.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                    Assert.assertEquals((long)comparator.compare(0, 0), (long)copyComparator.compare(0, 0));
                    continue;
                }
            }
        }
    }

    private FixedSizeListVector createFixedSizeListVector(int count) {
        FixedSizeListVector listVector = FixedSizeListVector.empty((String)"list vector", (int)count, (BufferAllocator)this.allocator);
        Types.MinorType type = Types.MinorType.INT;
        listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        listVector.allocateNew();
        IntVector dataVector = (IntVector)listVector.getDataVector();
        for (int i = 0; i < count; ++i) {
            dataVector.set(i, i);
        }
        dataVector.setValueCount(count);
        listVector.setNotNull(0);
        listVector.setValueCount(1);
        return listVector;
    }

    @Test
    public void testCompareFixedSizeLists() {
        VectorValueComparator comparator2;
        Throwable throwable;
        FixedSizeListVector listVector2;
        try (FixedSizeListVector listVector1 = this.createFixedSizeListVector(10);){
            listVector2 = this.createFixedSizeListVector(11);
            throwable = null;
            try {
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                comparator2.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                Assertions.assertTrue((comparator2.compare(0, 0) < 0 ? 1 : 0) != 0);
            }
            catch (Throwable comparator2) {
                throwable = comparator2;
                throw comparator2;
            }
            finally {
                if (listVector2 != null) {
                    TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)listVector2);
                }
            }
        }
        listVector1 = this.createFixedSizeListVector(11);
        var2_2 = null;
        try {
            listVector2 = this.createFixedSizeListVector(11);
            throwable = null;
            try {
                ((IntVector)listVector2.getDataVector()).set(10, 110);
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                comparator2.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                Assertions.assertTrue((comparator2.compare(0, 0) < 0 ? 1 : 0) != 0);
            }
            catch (Throwable comparator3) {
                throwable = comparator3;
                throw comparator3;
            }
            finally {
                if (listVector2 != null) {
                    TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)listVector2);
                }
            }
        }
        catch (Throwable listVector22) {
            var2_2 = listVector22;
            throw listVector22;
        }
        finally {
            if (listVector1 != null) {
                TestDefaultVectorComparator.$closeResource(var2_2, (AutoCloseable)listVector1);
            }
        }
        listVector1 = this.createFixedSizeListVector(10);
        var2_2 = null;
        try {
            listVector2 = this.createFixedSizeListVector(10);
            throwable = null;
            try {
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)listVector1);
                comparator2.attachVectors((ValueVector)listVector1, (ValueVector)listVector2);
                Assertions.assertTrue((comparator2.compare(0, 0) == 0 ? 1 : 0) != 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (listVector2 != null) {
                    TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)listVector2);
                }
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            if (listVector1 != null) {
                TestDefaultVectorComparator.$closeResource(var2_2, (AutoCloseable)listVector1);
            }
        }
    }

    @Test
    public void testCompareUInt1() {
        try (UInt1Vector vec = new UInt1Vector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.setNull(0);
            vec.set(1, -2);
            vec.set(2, -1);
            vec.set(3, 0);
            vec.set(4, 1);
            vec.set(5, 2);
            vec.set(6, -2);
            vec.setNull(7);
            vec.set(8, (byte)127);
            vec.set(9, (byte)-128);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 5) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 5) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 8) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 9) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareUInt2() {
        try (UInt2Vector vec = new UInt2Vector("", this.allocator);){
            vec.allocateNew(10);
            ValueVectorDataPopulator.setVector((UInt2Vector)vec, (Character[])new Character[]{null, Character.valueOf('\ufffe'), Character.valueOf('\uffff'), Character.valueOf('\u0000'), Character.valueOf('\u0001'), Character.valueOf('\u0002'), Character.valueOf('\ufffe'), null, Character.valueOf(Short.MAX_VALUE), Character.valueOf('\u8000')});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 5) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 5) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 8) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 9) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareUInt4() {
        try (UInt4Vector vec = new UInt4Vector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.setNull(0);
            vec.set(1, -2);
            vec.set(2, -1);
            vec.set(3, 0);
            vec.set(4, 1);
            vec.set(5, 2);
            vec.set(6, -2);
            vec.setNull(7);
            vec.set(8, Integer.MAX_VALUE);
            vec.set(9, Integer.MIN_VALUE);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 5) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 5) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 8) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 9) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareUInt8() {
        try (UInt8Vector vec = new UInt8Vector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            vec.setNull(0);
            vec.set(1, -2L);
            vec.set(2, -1L);
            vec.set(3, 0L);
            vec.set(4, 1L);
            vec.set(5, 2L);
            vec.set(6, -2L);
            vec.setNull(7);
            vec.set(8, Long.MAX_VALUE);
            vec.set(9, Long.MIN_VALUE);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 5) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 5) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 8) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 9) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareFloat4() {
        try (Float4Vector vec = new Float4Vector("", this.allocator);){
            vec.allocateNew(9);
            ValueVectorDataPopulator.setVector((Float4Vector)vec, (Float[])new Float[]{Float.valueOf(-1.1f), Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN), Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY)});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 0) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 8) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 3) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareFloat8() {
        try (Float8Vector vec = new Float8Vector("", this.allocator);){
            vec.allocateNew(9);
            ValueVectorDataPopulator.setVector((Float8Vector)vec, (Double[])new Double[]{-1.1, 0.0, 1.0, null, 1.0, 2.0, Double.NaN, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 0) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 8) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 3) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareLong() {
        try (BigIntVector vec = new BigIntVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((BigIntVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareInt() {
        try (IntVector vec = new IntVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{-1, 0, 1, null, 1, 5, -2147483647, Integer.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareShort() {
        try (SmallIntVector vec = new SmallIntVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((SmallIntVector)vec, (Short[])new Short[]{(short)-1, (short)0, (short)1, null, (short)1, (short)5, (short)-32767, (short)Short.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareByte() {
        try (TinyIntVector vec = new TinyIntVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((TinyIntVector)vec, (Byte[])new Byte[]{(byte)-1, (byte)0, (byte)1, null, (byte)1, (byte)5, (byte)-127, (byte)127});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareBit() {
        try (BitVector vec = new BitVector("", this.allocator);){
            vec.allocateNew(6);
            ValueVectorDataPopulator.setVector((BitVector)vec, (Integer[])new Integer[]{1, 2, 0, 0, -1, null});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 0) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 2) < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareDateDay() {
        try (DateDayVector vec = new DateDayVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((DateDayVector)vec, (Integer[])new Integer[]{-1, 0, 1, null, 1, 5, -2147483647, Integer.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareDateMilli() {
        try (DateMilliVector vec = new DateMilliVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((DateMilliVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareDecimal() {
        try (DecimalVector vec = new DecimalVector("", this.allocator, 10, 1);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((DecimalVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareDecimal256() {
        try (Decimal256Vector vec = new Decimal256Vector("", this.allocator, 10, 1);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((Decimal256Vector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareDuration() {
        try (DurationVector vec = new DurationVector("", FieldType.nullable((ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND)), this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((DurationVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareIntervalDay() {
        try (IntervalDayVector vec = new IntervalDayVector("", FieldType.nullable((ArrowType)new ArrowType.Duration(TimeUnit.MILLISECOND)), this.allocator);){
            vec.allocateNew(8);
            vec.set(0, -1, 0);
            vec.set(1, 0, 0);
            vec.set(2, 1, 0);
            vec.setNull(3);
            vec.set(4, -1, -1);
            vec.set(5, 1, 1);
            vec.set(6, 1, 1);
            vec.set(7, -1, -1);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 5) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 4) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 6) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 7) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareTimeMicro() {
        try (TimeMicroVector vec = new TimeMicroVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((TimeMicroVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareTimeMilli() {
        try (TimeMilliVector vec = new TimeMilliVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((TimeMilliVector)vec, (Integer[])new Integer[]{-1, 0, 1, null, 1, 5, -2147483647, Integer.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareTimeNano() {
        try (TimeNanoVector vec = new TimeNanoVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((TimeNanoVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareTimeSec() {
        try (TimeSecVector vec = new TimeSecVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((TimeSecVector)vec, (Integer[])new Integer[]{-1, 0, 1, null, 1, 5, -2147483647, Integer.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareTimeStamp() {
        try (TimeStampMilliVector vec = new TimeStampMilliVector("", this.allocator);){
            vec.allocateNew(8);
            ValueVectorDataPopulator.setVector((TimeStampMilliVector)vec, (Long[])new Long[]{-1L, 0L, 1L, null, 1L, 5L, -9223372036854775807L, Long.MAX_VALUE});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((comparator.compare(0, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(0, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 1) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 4) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 4) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(5, 3) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(6, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 6) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareFixedSizeBinary() {
        VectorValueComparator comparator2;
        Throwable throwable;
        FixedSizeBinaryVector vector2;
        try (FixedSizeBinaryVector vector1 = new FixedSizeBinaryVector("test1", this.allocator, 2);){
            vector2 = new FixedSizeBinaryVector("test1", this.allocator, 3);
            throwable = null;
            try {
                vector1.allocateNew();
                vector2.allocateNew();
                vector1.set(0, new byte[]{1, 1});
                vector2.set(0, new byte[]{1, 1, 0});
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)vector1);
                comparator2.attachVectors((ValueVector)vector1, (ValueVector)vector2);
                Assertions.assertTrue((comparator2.compare(0, 0) < 0 ? 1 : 0) != 0);
            }
            catch (Throwable comparator2) {
                throwable = comparator2;
                throw comparator2;
            }
            finally {
                TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vector2);
            }
        }
        vector1 = new FixedSizeBinaryVector("test1", this.allocator, 3);
        var2_2 = null;
        try {
            vector2 = new FixedSizeBinaryVector("test1", this.allocator, 3);
            throwable = null;
            try {
                vector1.allocateNew();
                vector2.allocateNew();
                vector1.set(0, new byte[]{1, 1, 0});
                vector2.set(0, new byte[]{1, 1, 1});
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)vector1);
                comparator2.attachVectors((ValueVector)vector1, (ValueVector)vector2);
                Assertions.assertTrue((comparator2.compare(0, 0) < 0 ? 1 : 0) != 0);
            }
            catch (Throwable comparator3) {
                throwable = comparator3;
                throw comparator3;
            }
            finally {
                TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vector2);
            }
        }
        catch (Throwable vector22) {
            var2_2 = vector22;
            throw vector22;
        }
        finally {
            TestDefaultVectorComparator.$closeResource(var2_2, (AutoCloseable)vector1);
        }
        vector1 = new FixedSizeBinaryVector("test1", this.allocator, 3);
        var2_2 = null;
        try {
            vector2 = new FixedSizeBinaryVector("test1", this.allocator, 3);
            throwable = null;
            try {
                vector1.allocateNew();
                vector2.allocateNew();
                vector1.set(0, new byte[]{1, 1, 1});
                vector2.set(0, new byte[]{1, 1, 1});
                comparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)vector1);
                comparator2.attachVectors((ValueVector)vector1, (ValueVector)vector2);
                Assertions.assertTrue((comparator2.compare(0, 0) == 0 ? 1 : 0) != 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vector2);
            }
        }
        catch (Throwable throwable3) {
            var2_2 = throwable3;
            throw throwable3;
        }
        finally {
            TestDefaultVectorComparator.$closeResource(var2_2, (AutoCloseable)vector1);
        }
    }

    @Test
    public void testCompareNull() {
        try (NullVector vec = new NullVector("test", FieldType.notNullable((ArrowType)new ArrowType.Int(32, false)));){
            vec.setValueCount(2);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assert.assertEquals(DefaultVectorComparators.NullComparator.class, comparator.getClass());
            Assert.assertEquals((long)0L, (long)comparator.compare(0, 1));
        }
    }

    @Test
    public void testCheckNullsOnCompareIsFalseForNonNullableVector() {
        try (IntVector vec = new IntVector("not nullable", FieldType.notNullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{1, 2, 3, 4});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertFalse((boolean)comparator.checkNullsOnCompare());
        }
    }

    @Test
    public void testCheckNullsOnCompareIsTrueForNullableVector() {
        try (IntVector vec = new IntVector("nullable", FieldType.nullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);
             IntVector vec2 = new IntVector("not-nullable", FieldType.notNullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{1, null, 3, 4});
            ValueVectorDataPopulator.setVector((IntVector)vec2, (Integer[])new Integer[]{1, 2, 3, 4});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertTrue((boolean)comparator.checkNullsOnCompare());
            comparator.attachVectors((ValueVector)vec, (ValueVector)vec2);
            Assertions.assertTrue((boolean)comparator.checkNullsOnCompare());
        }
    }

    @Test
    public void testCheckNullsOnCompareIsFalseWithNoNulls() {
        try (IntVector vec = new IntVector("nullable", FieldType.nullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);
             IntVector vec2 = new IntVector("also-nullable", FieldType.nullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);){
            ValueVectorDataPopulator.setVector((IntVector)vec, (Integer[])new Integer[]{1, 2, 3, 4});
            ValueVectorDataPopulator.setVector((IntVector)vec2, (Integer[])new Integer[]{1, 2, 3, 4});
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec);
            Assertions.assertFalse((boolean)comparator.checkNullsOnCompare());
            comparator.attachVectors((ValueVector)vec, (ValueVector)vec2);
            Assertions.assertFalse((boolean)comparator.checkNullsOnCompare());
        }
    }

    @Test
    public void testCheckNullsOnCompareIsTrueWithEmptyVectors() {
        try (IntVector vec = new IntVector("nullable", FieldType.nullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);
             IntVector vec2 = new IntVector("also-nullable", FieldType.nullable((ArrowType)new ArrowType.Int(32, false)), this.allocator);){
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            comparator.attachVector((ValueVector)vec2);
            Assertions.assertTrue((boolean)comparator.checkNullsOnCompare());
            comparator.attachVectors((ValueVector)vec, (ValueVector)vec2);
            Assertions.assertTrue((boolean)comparator.checkNullsOnCompare());
        }
    }

    @Test
    public void testVariableWidthDefaultComparators() {
        VarCharVector vec = new VarCharVector("test", this.allocator);
        Throwable throwable = null;
        try {
            TestDefaultVectorComparator.verifyVariableWidthComparatorReturned(vec);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vec);
                throw throwable3;
            }
        }
        TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vec);
        vec = new VarBinaryVector("test", this.allocator);
        throwable = null;
        try {
            TestDefaultVectorComparator.verifyVariableWidthComparatorReturned(vec);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vec);
        }
        vec = new LargeVarCharVector("test", this.allocator);
        throwable = null;
        try {
            TestDefaultVectorComparator.verifyVariableWidthComparatorReturned(vec);
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vec);
        }
        vec = new LargeVarBinaryVector("test", this.allocator);
        throwable = null;
        try {
            TestDefaultVectorComparator.verifyVariableWidthComparatorReturned(vec);
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            TestDefaultVectorComparator.$closeResource(throwable, (AutoCloseable)vec);
        }
    }

    private static <V extends ValueVector> void verifyVariableWidthComparatorReturned(V vec) {
        VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator(vec);
        Assert.assertEquals(DefaultVectorComparators.VariableWidthComparator.class, comparator.getClass());
    }

    @Test
    public void testRepeatedDefaultComparators() {
        FieldType type = FieldType.nullable((ArrowType)Types.MinorType.INT.getType());
        try (LargeListVector vector = new LargeListVector("list", this.allocator, type, null);){
            vector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
            TestDefaultVectorComparator.verifyRepeatedComparatorReturned(vector);
        }
    }

    private static <V extends ValueVector> void verifyRepeatedComparatorReturned(V vec) {
        VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator(vec);
        Assert.assertEquals(DefaultVectorComparators.RepeatedValueComparator.class, comparator.getClass());
    }
}

