/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.Arrays;
import org.apache.arrow.algorithm.sort.CompositeVectorComparator;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestCompositeVectorComparator {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testCompareVectorSchemaRoot() {
        int vectorLength = 10;
        IntVector intVec1 = new IntVector("int1", this.allocator);
        VarCharVector strVec1 = new VarCharVector("str1", this.allocator);
        IntVector intVec2 = new IntVector("int2", this.allocator);
        VarCharVector strVec2 = new VarCharVector("str2", this.allocator);
        try (VectorSchemaRoot batch1 = new VectorSchemaRoot(Arrays.asList(intVec1, strVec1));
             VectorSchemaRoot batch2 = new VectorSchemaRoot(Arrays.asList(intVec2, strVec2));){
            intVec1.allocateNew(10);
            strVec1.allocateNew(100L, 10);
            intVec2.allocateNew(10);
            strVec2.allocateNew(100L, 10);
            for (int i = 0; i < 10; ++i) {
                intVec1.set(i, i);
                strVec1.set(i, new String("a" + i).getBytes());
                intVec2.set(i, i);
                strVec2.set(i, new String("a5").getBytes());
            }
            VectorValueComparator innerComparator1 = DefaultVectorComparators.createDefaultComparator((ValueVector)intVec1);
            innerComparator1.attachVectors((ValueVector)intVec1, (ValueVector)intVec2);
            VectorValueComparator innerComparator2 = DefaultVectorComparators.createDefaultComparator((ValueVector)strVec1);
            innerComparator2.attachVectors((ValueVector)strVec1, (ValueVector)strVec2);
            CompositeVectorComparator comparator = new CompositeVectorComparator(new VectorValueComparator[]{innerComparator1, innerComparator2});
            Assertions.assertTrue((comparator.compare(5, 5) == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 1) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 3) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(7, 7) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 8) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(9, 9) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(1, 2) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(3, 7) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 9) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(2, 0) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(8, 7) > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((comparator.compare(4, 1) > 0 ? 1 : 0) != 0);
        }
    }
}

