/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import org.apache.arrow.algorithm.search.VectorSearcher;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorSearcher {
    private final int VECTOR_LENGTH = 100;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testBinarySearchInt() {
        try (IntVector rawVector = new IntVector("", this.allocator);
             IntVector negVector = new IntVector("", this.allocator);){
            rawVector.allocateNew(100);
            rawVector.setValueCount(100);
            negVector.allocateNew(1);
            negVector.setValueCount(1);
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    rawVector.setNull(i);
                    continue;
                }
                rawVector.set(i, i);
            }
            negVector.set(0, -333);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)rawVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorSearcher.binarySearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)rawVector, (int)i);
                Assert.assertEquals((long)i, (long)result);
            }
            Assert.assertEquals((long)-1L, (long)VectorSearcher.binarySearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)0));
        }
    }

    @Test
    public void testLinearSearchInt() {
        try (IntVector rawVector = new IntVector("", this.allocator);
             IntVector negVector = new IntVector("", this.allocator);){
            rawVector.allocateNew(100);
            rawVector.setValueCount(100);
            negVector.allocateNew(1);
            negVector.setValueCount(1);
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    rawVector.setNull(i);
                    continue;
                }
                rawVector.set(i, i);
            }
            negVector.set(0, -333);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)rawVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorSearcher.linearSearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)rawVector, (int)i);
                Assert.assertEquals((long)i, (long)result);
            }
            Assert.assertEquals((long)-1L, (long)VectorSearcher.linearSearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)0));
        }
    }

    @Test
    public void testBinarySearchVarChar() {
        try (VarCharVector rawVector = new VarCharVector("", this.allocator);
             VarCharVector negVector = new VarCharVector("", this.allocator);){
            rawVector.allocateNew(1600L, 100);
            rawVector.setValueCount(100);
            negVector.allocateNew(100L, 1);
            negVector.setValueCount(1);
            byte[] content = new byte[2];
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    rawVector.setNull(i);
                    continue;
                }
                int q = i / 10;
                int r = i % 10;
                content[0] = (byte)(97 + q);
                content[1] = (byte)r;
                rawVector.set(i, content);
            }
            negVector.set(0, "abcd".getBytes());
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)rawVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorSearcher.binarySearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)rawVector, (int)i);
                Assert.assertEquals((long)i, (long)result);
            }
            Assert.assertEquals((long)-1L, (long)VectorSearcher.binarySearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)0));
        }
    }

    @Test
    public void testLinearSearchVarChar() {
        try (VarCharVector rawVector = new VarCharVector("", this.allocator);
             VarCharVector negVector = new VarCharVector("", this.allocator);){
            rawVector.allocateNew(1600L, 100);
            rawVector.setValueCount(100);
            negVector.allocateNew(100L, 1);
            negVector.setValueCount(1);
            byte[] content = new byte[2];
            for (int i = 0; i < 100; ++i) {
                if (i == 0) {
                    rawVector.setNull(i);
                    continue;
                }
                int q = i / 10;
                int r = i % 10;
                content[0] = (byte)(97 + q);
                content[1] = (byte)r;
                rawVector.set(i, content);
            }
            negVector.set(0, "abcd".getBytes());
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)rawVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorSearcher.linearSearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)rawVector, (int)i);
                Assert.assertEquals((long)i, (long)result);
            }
            Assert.assertEquals((long)-1L, (long)VectorSearcher.linearSearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)0));
        }
    }

    private ListVector createListVector() {
        int i;
        int innerCount = 100;
        int outerCount = 10;
        int listLength = 10;
        ListVector listVector = ListVector.empty((String)"list vector", (BufferAllocator)this.allocator);
        Types.MinorType type = Types.MinorType.INT;
        listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        listVector.allocateNew();
        IntVector dataVector = (IntVector)listVector.getDataVector();
        for (i = 0; i < 100; ++i) {
            dataVector.set(i, i);
        }
        dataVector.setValueCount(100);
        for (i = 0; i < 10; ++i) {
            BitVectorHelper.setBit((ArrowBuf)listVector.getValidityBuffer(), (long)i);
            listVector.getOffsetBuffer().setInt((long)(i * 4), i * 10);
            listVector.getOffsetBuffer().setInt((long)((i + 1) * 4), (i + 1) * 10);
        }
        listVector.setLastSet(9);
        listVector.setValueCount(10);
        return listVector;
    }

    private ListVector createNegativeListVector() {
        int i;
        int innerCount = 100;
        int outerCount = 10;
        int listLength = 10;
        ListVector listVector = ListVector.empty((String)"list vector", (BufferAllocator)this.allocator);
        Types.MinorType type = Types.MinorType.INT;
        listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
        listVector.allocateNew();
        IntVector dataVector = (IntVector)listVector.getDataVector();
        for (i = 0; i < 100; ++i) {
            dataVector.set(i, i + 1000);
        }
        dataVector.setValueCount(100);
        for (i = 0; i < 10; ++i) {
            BitVectorHelper.setBit((ArrowBuf)listVector.getValidityBuffer(), (long)i);
            listVector.getOffsetBuffer().setInt((long)(i * 4), i * 10);
            listVector.getOffsetBuffer().setInt((long)((i + 1) * 4), (i + 1) * 10);
        }
        listVector.setValueCount(10);
        return listVector;
    }

    @Test
    public void testBinarySearchList() {
        try (ListVector rawVector = this.createListVector();
             ListVector negVector = this.createNegativeListVector();){
            int result;
            int i;
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)rawVector);
            for (i = 0; i < rawVector.getValueCount(); ++i) {
                result = VectorSearcher.binarySearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)rawVector, (int)i);
                Assert.assertEquals((long)i, (long)result);
            }
            for (i = 0; i < rawVector.getValueCount(); ++i) {
                result = VectorSearcher.binarySearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)i);
                Assert.assertEquals((long)-1L, (long)result);
            }
        }
    }

    @Test
    public void testLinearSearchList() {
        try (ListVector rawVector = this.createListVector();
             ListVector negVector = this.createNegativeListVector();){
            int result;
            int i;
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)rawVector);
            for (i = 0; i < rawVector.getValueCount(); ++i) {
                result = VectorSearcher.linearSearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)rawVector, (int)i);
                Assert.assertEquals((long)i, (long)result);
            }
            for (i = 0; i < rawVector.getValueCount(); ++i) {
                result = VectorSearcher.linearSearch((ValueVector)rawVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)i);
                Assert.assertEquals((long)-1L, (long)result);
            }
        }
    }
}

