/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import java.util.Arrays;
import java.util.Collection;
import org.apache.arrow.algorithm.search.VectorRangeSearcher;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestVectorRangeSearcher {
    private BufferAllocator allocator;
    private int repeat;

    public TestVectorRangeSearcher(int repeat) {
        this.repeat = repeat;
    }

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testGetLowerBounds() {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);){
            intVector.allocateNew(100 * this.repeat);
            intVector.setValueCount(100 * this.repeat);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < this.repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * this.repeat + j);
                        continue;
                    }
                    intVector.set(i * this.repeat + j, i);
                }
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getFirstMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)intVector, (int)(i * this.repeat));
                Assert.assertEquals((long)(i * this.repeat), (long)result);
            }
        }
    }

    @Test
    public void testGetLowerBoundsNegative() {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);
             IntVector negVector = new IntVector("neg vec", this.allocator);){
            intVector.allocateNew(100 * this.repeat);
            intVector.setValueCount(100 * this.repeat);
            negVector.allocateNew(100);
            negVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < this.repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * this.repeat + j);
                        continue;
                    }
                    intVector.set(i * this.repeat + j, i);
                }
                negVector.set(i, 100 + i);
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getFirstMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)i);
                Assert.assertEquals((long)-1L, (long)result);
            }
        }
    }

    @Test
    public void testGetUpperBounds() {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);){
            intVector.allocateNew(100 * this.repeat);
            intVector.setValueCount(100 * this.repeat);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < this.repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * this.repeat + j);
                        continue;
                    }
                    intVector.set(i * this.repeat + j, i);
                }
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getLastMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)intVector, (int)(i * this.repeat));
                Assert.assertEquals((long)((i + 1) * this.repeat - 1), (long)result);
            }
        }
    }

    @Test
    public void testGetUpperBoundsNegative() {
        int maxValue = 100;
        try (IntVector intVector = new IntVector("int vec", this.allocator);
             IntVector negVector = new IntVector("neg vec", this.allocator);){
            intVector.allocateNew(100 * this.repeat);
            intVector.setValueCount(100 * this.repeat);
            negVector.allocateNew(100);
            negVector.setValueCount(100);
            for (int i = 0; i < 100; ++i) {
                for (int j = 0; j < this.repeat; ++j) {
                    if (i == 0) {
                        intVector.setNull(i * this.repeat + j);
                        continue;
                    }
                    intVector.set(i * this.repeat + j, i);
                }
                negVector.set(i, 100 + i);
            }
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)intVector);
            for (int i = 0; i < 100; ++i) {
                int result = VectorRangeSearcher.getLastMatch((ValueVector)intVector, (VectorValueComparator)comparator, (ValueVector)negVector, (int)i);
                Assert.assertEquals((long)-1L, (long)result);
            }
        }
    }

    @Parameterized.Parameters(name="repeat = {0}")
    public static Collection<Object[]> getRepeat() {
        return Arrays.asList({1}, {2}, {5}, {10});
    }
}

