/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.arrow.algorithm.search.ParallelSearcher;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParallelSearcher {
    private static final int VECTOR_LENGTH = 10000;
    private final int threadCount;
    private BufferAllocator allocator;
    private ExecutorService threadPool;
    private final ComparatorType comparatorType;

    public TestParallelSearcher(ComparatorType comparatorType, int threadCount) {
        this.comparatorType = comparatorType;
        this.threadCount = threadCount;
    }

    @Parameterized.Parameters(name="comparator type = {0}, thread count = {1}")
    public static Collection<Object[]> getComparatorName() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int[] threadCounts = new int[]{1, 2, 5, 10, 20, 50};
        for (ComparatorType type : ComparatorType.values()) {
            for (int count : threadCounts) {
                params.add(new Object[]{type, count});
            }
        }
        return params;
    }

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.threadPool = Executors.newFixedThreadPool(this.threadCount);
    }

    @After
    public void shutdown() {
        this.allocator.close();
        this.threadPool.shutdown();
    }

    @Test
    public void testParallelIntSearch() throws ExecutionException, InterruptedException {
        try (IntVector targetVector = new IntVector("targetVector", this.allocator);
             IntVector keyVector = new IntVector("keyVector", this.allocator);){
            targetVector.allocateNew(10000);
            keyVector.allocateNew(10000);
            VectorValueComparator comparator = this.comparatorType == ComparatorType.EqualityComparator ? null : DefaultVectorComparators.createDefaultComparator((ValueVector)targetVector);
            for (int i = 0; i < 10000; ++i) {
                targetVector.set(i, i);
                keyVector.set(i, i * 2);
            }
            targetVector.setValueCount(10000);
            keyVector.setValueCount(10000);
            ParallelSearcher searcher = new ParallelSearcher((ValueVector)targetVector, this.threadPool, this.threadCount);
            for (int i = 0; i < 10000; ++i) {
                int pos;
                int n = pos = comparator == null ? searcher.search((ValueVector)keyVector, i) : searcher.search((ValueVector)keyVector, i, comparator);
                if (i * 2 < 10000) {
                    Assertions.assertEquals((int)(i * 2), (int)pos);
                    continue;
                }
                Assertions.assertEquals((int)-1, (int)pos);
            }
        }
    }

    @Test
    public void testParallelStringSearch() throws ExecutionException, InterruptedException {
        try (VarCharVector targetVector = new VarCharVector("targetVector", this.allocator);
             VarCharVector keyVector = new VarCharVector("keyVector", this.allocator);){
            targetVector.allocateNew(10000);
            keyVector.allocateNew(10000);
            VectorValueComparator comparator = this.comparatorType == ComparatorType.EqualityComparator ? null : DefaultVectorComparators.createDefaultComparator((ValueVector)targetVector);
            for (int i = 0; i < 10000; ++i) {
                targetVector.setSafe(i, String.valueOf(i).getBytes());
                keyVector.setSafe(i, String.valueOf(i * 2).getBytes());
            }
            targetVector.setValueCount(10000);
            keyVector.setValueCount(10000);
            ParallelSearcher searcher = new ParallelSearcher((ValueVector)targetVector, this.threadPool, this.threadCount);
            for (int i = 0; i < 10000; ++i) {
                int pos;
                int n = pos = comparator == null ? searcher.search((ValueVector)keyVector, i) : searcher.search((ValueVector)keyVector, i, comparator);
                if (i * 2 < 10000) {
                    Assertions.assertEquals((int)(i * 2), (int)pos);
                    continue;
                }
                Assertions.assertEquals((int)-1, (int)pos);
            }
        }
    }

    private static enum ComparatorType {
        EqualityComparator,
        OrderingComparator;

    }
}

