/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.misc;

import org.apache.arrow.algorithm.misc.PartialSumUtils;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.IntVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPartialSumUtils {
    private static final int PARTIAL_SUM_VECTOR_LENGTH = 101;
    private static final int DELTA_VECTOR_LENGTH = 100;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testToPartialSumVector() {
        try (IntVector delta = new IntVector("delta", this.allocator);
             IntVector partialSum = new IntVector("partial sum", this.allocator);){
            delta.allocateNew(100);
            delta.setValueCount(100);
            partialSum.allocateNew(101);
            for (int i = 0; i < delta.getValueCount(); ++i) {
                delta.set(i, 3);
            }
            long sumBase = 10L;
            PartialSumUtils.toPartialSumVector((BaseIntVector)delta, (BaseIntVector)partialSum, (long)10L);
            Assert.assertEquals((long)101L, (long)partialSum.getValueCount());
            for (int i = 0; i < partialSum.getValueCount(); ++i) {
                Assert.assertEquals((long)((long)(i * 3) + 10L), (long)partialSum.get(i));
            }
        }
    }

    @Test
    public void testToDeltaVector() {
        try (IntVector partialSum = new IntVector("partial sum", this.allocator);
             IntVector delta = new IntVector("delta", this.allocator);){
            int i;
            partialSum.allocateNew(101);
            partialSum.setValueCount(101);
            delta.allocateNew(100);
            int sumBase = 10;
            for (i = 0; i < partialSum.getValueCount(); ++i) {
                partialSum.set(i, 10 + 3 * i);
            }
            PartialSumUtils.toDeltaVector((BaseIntVector)partialSum, (BaseIntVector)delta);
            Assert.assertEquals((long)100L, (long)delta.getValueCount());
            for (i = 0; i < delta.getValueCount(); ++i) {
                Assert.assertEquals((long)3L, (long)delta.get(i));
            }
        }
    }

    @Test
    public void testFindPositionInPartialSumVector() {
        try (IntVector partialSum = new IntVector("partial sum", this.allocator);){
            int i;
            partialSum.allocateNew(101);
            partialSum.setValueCount(101);
            int sumBase = 10;
            for (i = 0; i < partialSum.getValueCount(); ++i) {
                partialSum.set(i, 10 + 3 * i);
            }
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)i, (long)PartialSumUtils.findPositionInPartialSumVector((BaseIntVector)partialSum, (long)(10 + 3 * i + 1)));
            }
        }
    }

    @Test
    public void testFindPositionInPartialSumVectorNegative() {
        try (IntVector partialSum = new IntVector("partial sum", this.allocator);){
            partialSum.allocateNew(101);
            partialSum.setValueCount(101);
            int sumBase = 10;
            for (int i = 0; i < partialSum.getValueCount(); ++i) {
                partialSum.set(i, 10 + 3 * i);
            }
            Assert.assertEquals((long)0L, (long)PartialSumUtils.findPositionInPartialSumVector((BaseIntVector)partialSum, (long)10L));
            Assert.assertEquals((long)-1L, (long)PartialSumUtils.findPositionInPartialSumVector((BaseIntVector)partialSum, (long)9L));
            Assert.assertEquals((long)-1L, (long)PartialSumUtils.findPositionInPartialSumVector((BaseIntVector)partialSum, (long)310L));
        }
    }
}

