/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import org.apache.arrow.algorithm.dictionary.SearchTreeBasedDictionaryBuilder;
import org.apache.arrow.algorithm.sort.DefaultVectorComparators;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSearchTreeBasedDictionaryBuilder {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testBuildVariableWidthDictionaryWithNull() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);
             VarCharVector dictionary = new VarCharVector("", this.allocator);
             VarCharVector sortedDictionary = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, "hello".getBytes());
            vec.set(1, "abc".getBytes());
            vec.setNull(2);
            vec.set(3, "world".getBytes());
            vec.set(4, "12".getBytes());
            vec.set(5, "dictionary".getBytes());
            vec.setNull(6);
            vec.set(7, "hello".getBytes());
            vec.set(8, "good".getBytes());
            vec.set(9, "abc".getBytes());
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, true);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assert.assertEquals((long)7L, (long)result);
            Assert.assertEquals((long)7L, (long)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assert.assertTrue((boolean)sortedDictionary.isNull(0));
            Assert.assertEquals((Object)"12", (Object)new String(sortedDictionary.get(1)));
            Assert.assertEquals((Object)"abc", (Object)new String(sortedDictionary.get(2)));
            Assert.assertEquals((Object)"dictionary", (Object)new String(sortedDictionary.get(3)));
            Assert.assertEquals((Object)"good", (Object)new String(sortedDictionary.get(4)));
            Assert.assertEquals((Object)"hello", (Object)new String(sortedDictionary.get(5)));
            Assert.assertEquals((Object)"world", (Object)new String(sortedDictionary.get(6)));
        }
    }

    @Test
    public void testBuildVariableWidthDictionaryWithoutNull() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);
             VarCharVector dictionary = new VarCharVector("", this.allocator);
             VarCharVector sortedDictionary = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, "hello".getBytes());
            vec.set(1, "abc".getBytes());
            vec.setNull(2);
            vec.set(3, "world".getBytes());
            vec.set(4, "12".getBytes());
            vec.set(5, "dictionary".getBytes());
            vec.setNull(6);
            vec.set(7, "hello".getBytes());
            vec.set(8, "good".getBytes());
            vec.set(9, "abc".getBytes());
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, false);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assert.assertEquals((long)6L, (long)result);
            Assert.assertEquals((long)6L, (long)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assert.assertEquals((Object)"12", (Object)new String(sortedDictionary.get(0)));
            Assert.assertEquals((Object)"abc", (Object)new String(sortedDictionary.get(1)));
            Assert.assertEquals((Object)"dictionary", (Object)new String(sortedDictionary.get(2)));
            Assert.assertEquals((Object)"good", (Object)new String(sortedDictionary.get(3)));
            Assert.assertEquals((Object)"hello", (Object)new String(sortedDictionary.get(4)));
            Assert.assertEquals((Object)"world", (Object)new String(sortedDictionary.get(5)));
        }
    }

    @Test
    public void testBuildFixedWidthDictionaryWithNull() {
        try (IntVector vec = new IntVector("", this.allocator);
             IntVector dictionary = new IntVector("", this.allocator);
             IntVector sortedDictionary = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, 4);
            vec.set(1, 8);
            vec.set(2, 32);
            vec.set(3, 8);
            vec.set(4, 16);
            vec.set(5, 32);
            vec.setNull(6);
            vec.set(7, 4);
            vec.set(8, 4);
            vec.setNull(9);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, true);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assert.assertEquals((long)5L, (long)result);
            Assert.assertEquals((long)5L, (long)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assert.assertTrue((boolean)sortedDictionary.isNull(0));
            Assert.assertEquals((long)4L, (long)sortedDictionary.get(1));
            Assert.assertEquals((long)8L, (long)sortedDictionary.get(2));
            Assert.assertEquals((long)16L, (long)sortedDictionary.get(3));
            Assert.assertEquals((long)32L, (long)sortedDictionary.get(4));
        }
    }

    @Test
    public void testBuildFixedWidthDictionaryWithoutNull() {
        try (IntVector vec = new IntVector("", this.allocator);
             IntVector dictionary = new IntVector("", this.allocator);
             IntVector sortedDictionary = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            sortedDictionary.allocateNew();
            vec.set(0, 4);
            vec.set(1, 8);
            vec.set(2, 32);
            vec.set(3, 8);
            vec.set(4, 16);
            vec.set(5, 32);
            vec.setNull(6);
            vec.set(7, 4);
            vec.set(8, 4);
            vec.setNull(9);
            VectorValueComparator comparator = DefaultVectorComparators.createDefaultComparator((ValueVector)vec);
            SearchTreeBasedDictionaryBuilder dictionaryBuilder = new SearchTreeBasedDictionaryBuilder((ValueVector)dictionary, comparator, false);
            int result = dictionaryBuilder.addValues((ValueVector)vec);
            Assert.assertEquals((long)4L, (long)result);
            Assert.assertEquals((long)4L, (long)dictionary.getValueCount());
            dictionaryBuilder.populateSortedDictionary((ValueVector)sortedDictionary);
            Assert.assertEquals((long)4L, (long)sortedDictionary.get(0));
            Assert.assertEquals((long)8L, (long)sortedDictionary.get(1));
            Assert.assertEquals((long)16L, (long)sortedDictionary.get(2));
            Assert.assertEquals((long)32L, (long)sortedDictionary.get(3));
        }
    }
}

