/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import junit.framework.TestCase;
import org.apache.arrow.algorithm.dictionary.HashTableBasedDictionaryBuilder;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ElementAddressableVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestHashTableBasedDictionaryBuilder {
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testBuildVariableWidthDictionaryWithNull() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);
             VarCharVector dictionary = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            vec.set(0, "hello".getBytes());
            vec.set(1, "abc".getBytes());
            vec.setNull(2);
            vec.set(3, "world".getBytes());
            vec.set(4, "12".getBytes());
            vec.set(5, "dictionary".getBytes());
            vec.setNull(6);
            vec.set(7, "hello".getBytes());
            vec.set(8, "good".getBytes());
            vec.set(9, "abc".getBytes());
            HashTableBasedDictionaryBuilder dictionaryBuilder = new HashTableBasedDictionaryBuilder((ElementAddressableVector)dictionary, true);
            int result = dictionaryBuilder.addValues((ElementAddressableVector)vec);
            Assertions.assertEquals((int)7, (int)result);
            Assertions.assertEquals((int)7, (int)dictionary.getValueCount());
            Assertions.assertEquals((Object)"hello", (Object)new String(dictionary.get(0)));
            Assertions.assertEquals((Object)"abc", (Object)new String(dictionary.get(1)));
            Assert.assertNull((Object)dictionary.get(2));
            Assertions.assertEquals((Object)"world", (Object)new String(dictionary.get(3)));
            Assertions.assertEquals((Object)"12", (Object)new String(dictionary.get(4)));
            Assertions.assertEquals((Object)"dictionary", (Object)new String(dictionary.get(5)));
            Assertions.assertEquals((Object)"good", (Object)new String(dictionary.get(6)));
        }
    }

    @Test
    public void testBuildVariableWidthDictionaryWithoutNull() {
        try (VarCharVector vec = new VarCharVector("", this.allocator);
             VarCharVector dictionary = new VarCharVector("", this.allocator);){
            vec.allocateNew(100L, 10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            vec.set(0, "hello".getBytes());
            vec.set(1, "abc".getBytes());
            vec.setNull(2);
            vec.set(3, "world".getBytes());
            vec.set(4, "12".getBytes());
            vec.set(5, "dictionary".getBytes());
            vec.setNull(6);
            vec.set(7, "hello".getBytes());
            vec.set(8, "good".getBytes());
            vec.set(9, "abc".getBytes());
            HashTableBasedDictionaryBuilder dictionaryBuilder = new HashTableBasedDictionaryBuilder((ElementAddressableVector)dictionary, false);
            int result = dictionaryBuilder.addValues((ElementAddressableVector)vec);
            Assertions.assertEquals((int)6, (int)result);
            Assertions.assertEquals((int)6, (int)dictionary.getValueCount());
            Assertions.assertEquals((Object)"hello", (Object)new String(dictionary.get(0)));
            Assertions.assertEquals((Object)"abc", (Object)new String(dictionary.get(1)));
            Assertions.assertEquals((Object)"world", (Object)new String(dictionary.get(2)));
            Assertions.assertEquals((Object)"12", (Object)new String(dictionary.get(3)));
            Assertions.assertEquals((Object)"dictionary", (Object)new String(dictionary.get(4)));
            Assertions.assertEquals((Object)"good", (Object)new String(dictionary.get(5)));
        }
    }

    @Test
    public void testBuildFixedWidthDictionaryWithNull() {
        try (IntVector vec = new IntVector("", this.allocator);
             IntVector dictionary = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            vec.set(0, 4);
            vec.set(1, 8);
            vec.set(2, 32);
            vec.set(3, 8);
            vec.set(4, 16);
            vec.set(5, 32);
            vec.setNull(6);
            vec.set(7, 4);
            vec.set(8, 4);
            vec.setNull(9);
            HashTableBasedDictionaryBuilder dictionaryBuilder = new HashTableBasedDictionaryBuilder((ElementAddressableVector)dictionary, true);
            int result = dictionaryBuilder.addValues((ElementAddressableVector)vec);
            Assertions.assertEquals((int)5, (int)result);
            Assertions.assertEquals((int)5, (int)dictionary.getValueCount());
            Assertions.assertEquals((int)4, (int)dictionary.get(0));
            Assertions.assertEquals((int)8, (int)dictionary.get(1));
            Assertions.assertEquals((int)32, (int)dictionary.get(2));
            Assertions.assertEquals((int)16, (int)dictionary.get(3));
            TestCase.assertTrue((boolean)dictionary.isNull(4));
        }
    }

    @Test
    public void testBuildFixedWidthDictionaryWithoutNull() {
        try (IntVector vec = new IntVector("", this.allocator);
             IntVector dictionary = new IntVector("", this.allocator);){
            vec.allocateNew(10);
            vec.setValueCount(10);
            dictionary.allocateNew();
            vec.set(0, 4);
            vec.set(1, 8);
            vec.set(2, 32);
            vec.set(3, 8);
            vec.set(4, 16);
            vec.set(5, 32);
            vec.setNull(6);
            vec.set(7, 4);
            vec.set(8, 4);
            vec.setNull(9);
            HashTableBasedDictionaryBuilder dictionaryBuilder = new HashTableBasedDictionaryBuilder((ElementAddressableVector)dictionary, false);
            int result = dictionaryBuilder.addValues((ElementAddressableVector)vec);
            Assertions.assertEquals((int)4, (int)result);
            Assertions.assertEquals((int)4, (int)dictionary.getValueCount());
            Assertions.assertEquals((int)4, (int)dictionary.get(0));
            Assertions.assertEquals((int)8, (int)dictionary.get(1));
            Assertions.assertEquals((int)32, (int)dictionary.get(2));
            Assertions.assertEquals((int)16, (int)dictionary.get(3));
        }
    }
}

