/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.deduplicate;

import org.apache.arrow.algorithm.deduplicate.DeduplicationUtils;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.DataSizeRoundingUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestDeduplicationUtils {
    private static final int VECTOR_LENGTH = 100;
    private static final int REPETITION_COUNT = 3;
    private BufferAllocator allocator;

    @Before
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
    }

    @After
    public void shutdown() {
        this.allocator.close();
    }

    @Test
    public void testDeduplicateFixedWidth() {
        try (IntVector origVec = new IntVector("original vec", this.allocator);
             IntVector dedupVec = new IntVector("deduplicated vec", this.allocator);
             IntVector lengthVec = new IntVector("length vec", this.allocator);
             ArrowBuf distinctBuf = this.allocator.buffer((long)DataSizeRoundingUtil.divideBy8Ceil((int)300));){
            int i;
            origVec.allocateNew(300);
            origVec.setValueCount(300);
            lengthVec.allocateNew();
            for (i = 0; i < 100; ++i) {
                for (int j = 0; j < 3; ++j) {
                    origVec.set(i * 3 + j, i);
                }
            }
            DeduplicationUtils.populateRunStartIndicators((ValueVector)origVec, (ArrowBuf)distinctBuf);
            Assert.assertEquals((long)100L, (long)(300 - BitVectorHelper.getNullCount((ArrowBuf)distinctBuf, (int)300)));
            DeduplicationUtils.populateDeduplicatedValues((ArrowBuf)distinctBuf, (ValueVector)origVec, (ValueVector)dedupVec);
            Assert.assertEquals((long)100L, (long)dedupVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)i, (long)dedupVec.get(i));
            }
            DeduplicationUtils.populateRunLengths((ArrowBuf)distinctBuf, (IntVector)lengthVec, (int)300);
            Assert.assertEquals((long)100L, (long)lengthVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)3L, (long)lengthVec.get(i));
            }
        }
    }

    @Test
    public void testDeduplicateVariableWidth() {
        try (VarCharVector origVec = new VarCharVector("original vec", this.allocator);
             VarCharVector dedupVec = new VarCharVector("deduplicated vec", this.allocator);
             IntVector lengthVec = new IntVector("length vec", this.allocator);
             ArrowBuf distinctBuf = this.allocator.buffer((long)DataSizeRoundingUtil.divideBy8Ceil((int)300));){
            int i;
            origVec.allocateNew(3000L, 300);
            origVec.setValueCount(300);
            lengthVec.allocateNew();
            for (i = 0; i < 100; ++i) {
                String str = String.valueOf(i * i);
                for (int j = 0; j < 3; ++j) {
                    origVec.set(i * 3 + j, str.getBytes());
                }
            }
            DeduplicationUtils.populateRunStartIndicators((ValueVector)origVec, (ArrowBuf)distinctBuf);
            Assert.assertEquals((long)100L, (long)(300 - BitVectorHelper.getNullCount((ArrowBuf)distinctBuf, (int)300)));
            DeduplicationUtils.populateDeduplicatedValues((ArrowBuf)distinctBuf, (ValueVector)origVec, (ValueVector)dedupVec);
            Assert.assertEquals((long)100L, (long)dedupVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assertions.assertArrayEquals((byte[])String.valueOf(i * i).getBytes(), (byte[])dedupVec.get(i));
            }
            DeduplicationUtils.populateRunLengths((ArrowBuf)distinctBuf, (IntVector)lengthVec, (int)300);
            Assert.assertEquals((long)100L, (long)lengthVec.getValueCount());
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)3L, (long)lengthVec.get(i));
            }
        }
    }
}

