/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import java.util.stream.IntStream;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

public class IndexSorter<V extends ValueVector> {
    private VectorValueComparator<V> comparator;
    private IntVector indices;

    public void sort(V vector, IntVector indices, VectorValueComparator<V> comparator) {
        comparator.attachVector(vector);
        this.indices = indices;
        IntStream.range(0, vector.getValueCount()).forEach(i -> indices.set(i, i));
        this.comparator = comparator;
        this.quickSort(0, indices.getValueCount() - 1);
    }

    private void quickSort(int low, int high) {
        if (low < high) {
            int mid = this.partition(low, high);
            this.quickSort(low, mid - 1);
            this.quickSort(mid + 1, high);
        }
    }

    private int partition(int low, int high) {
        int pivotIndex = this.indices.get(low);
        while (low < high) {
            while (low < high && this.comparator.compare(this.indices.get(high), pivotIndex) >= 0) {
                --high;
            }
            this.indices.set(low, this.indices.get(high));
            while (low < high && this.comparator.compare(this.indices.get(low), pivotIndex) <= 0) {
                ++low;
            }
            this.indices.set(high, this.indices.get(low));
        }
        this.indices.set(low, pivotIndex);
        return low;
    }
}

