/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.jpa.xa.plugin.eclipse.impl;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.AbstractTransactionController;
import org.eclipse.persistence.transaction.SynchronizationListenerFactory;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionControl;
import org.osgi.service.transaction.control.TransactionException;
import org.osgi.service.transaction.control.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseTxControlPlatform
extends ServerPlatformBase {
    public static void setTransactionControl(ThreadLocal<TransactionControl> txControl) {
        TxControlAdapter.txControlToUse = txControl;
    }

    public EclipseTxControlPlatform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
    }

    public Class<?> getExternalTransactionControllerClass() {
        return TxControlAdapter.class;
    }

    public static class TxControlListener
    extends AbstractSynchronizationListener {
        public TxControlListener(UnitOfWorkImpl unitOfWork, AbstractSession session, Object transaction, AbstractTransactionController controller) {
            super(unitOfWork, session, transaction, controller);
        }
    }

    public static class TxControlListenerFactory
    implements SynchronizationListenerFactory {
        public AbstractSynchronizationListener newSynchronizationListener(UnitOfWorkImpl unitOfWork, AbstractSession session, Object transaction, AbstractTransactionController controller) {
            return new TxControlListener(unitOfWork, session, transaction, controller);
        }
    }

    private static class TransactionWrapper
    implements Transaction {
        private final TransactionContext context;

        public TransactionWrapper(TransactionContext context) {
            this.context = context;
        }

        public TransactionContext getContext() {
            return this.context;
        }

        public void registerSynchronization(Synchronization synch) throws IllegalStateException, RollbackException, SystemException {
            this.context.preCompletion(() -> ((Synchronization)synch).beforeCompletion());
            this.context.postCompletion(status -> synch.afterCompletion(this.toIntStatus((TransactionStatus)status)));
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.context.setRollbackOnly();
        }

        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            throw new TransactionException("Resources may not be delisted");
        }

        public boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
            this.context.registerXAResource(xaRes, null);
            return true;
        }

        public int getStatus() throws SystemException {
            return this.toIntStatus(this.context.getTransactionStatus());
        }

        private int toIntStatus(TransactionStatus status) {
            switch (status) {
                case NO_TRANSACTION: {
                    return 6;
                }
                case ACTIVE: {
                    return 0;
                }
                case PREPARING: {
                    return 7;
                }
                case PREPARED: {
                    return 2;
                }
                case COMMITTING: {
                    return 8;
                }
                case COMMITTED: {
                    return 3;
                }
                case MARKED_ROLLBACK: {
                    return 1;
                }
                case ROLLING_BACK: {
                    return 9;
                }
                case ROLLED_BACK: {
                    return 4;
                }
            }
            return 5;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            throw new TransactionException("Open scoped transactions are not supported");
        }

        public void rollback() throws IllegalStateException, SystemException {
            throw new TransactionException("Open scoped transactions are not supported");
        }
    }

    public static class TxControlAdapter
    extends AbstractTransactionController {
        private static final Logger LOGGER = LoggerFactory.getLogger(TxControlAdapter.class);
        private static ThreadLocal<TransactionControl> txControlToUse;

        public TransactionControl getTxControl() {
            TransactionControl transactionControl = txControlToUse.get();
            if (transactionControl == null) {
                throw new TransactionException("A No Transaction Context could not be created because there is no associated Transaction Control");
            }
            return transactionControl;
        }

        public TxControlAdapter() {
            this.listenerFactory = new TxControlListenerFactory();
        }

        public boolean isRolledBack_impl(Object status) {
            return status == TransactionStatus.ROLLED_BACK;
        }

        protected void registerSynchronization_impl(AbstractSynchronizationListener listener, Object txn) throws Exception {
            LOGGER.debug("Registering a synchronization with the current transaction");
            TransactionContext ctx = ((TransactionWrapper)txn).getContext();
            ctx.preCompletion(() -> ((AbstractSynchronizationListener)listener).beforeCompletion());
            ctx.postCompletion(arg_0 -> ((AbstractSynchronizationListener)listener).afterCompletion(arg_0));
        }

        protected Object getTransaction_impl() throws Exception {
            TransactionContext currentContext = this.getTxControl().getCurrentContext();
            if (currentContext == null || currentContext.getTransactionStatus() == TransactionStatus.NO_TRANSACTION) {
                return null;
            }
            return new TransactionWrapper(currentContext);
        }

        protected Object getTransactionKey_impl(Object transaction) throws Exception {
            return transaction == null ? null : ((TransactionWrapper)transaction).getContext().getTransactionKey();
        }

        protected Object getTransactionStatus_impl() throws Exception {
            TransactionContext currentContext = this.getTxControl().getCurrentContext();
            return currentContext == null ? null : currentContext.getTransactionStatus();
        }

        protected void beginTransaction_impl() throws Exception {
            throw new TransactionException("Open scoped transactions are not supported");
        }

        protected void commitTransaction_impl() throws Exception {
            throw new TransactionException("Open scoped transactions are not supported");
        }

        protected void rollbackTransaction_impl() throws Exception {
            throw new TransactionException("Open scoped transactions are not supported");
        }

        protected void markTransactionForRollback_impl() throws Exception {
            LOGGER.debug("Marking the current transaction for rollback");
            this.getTxControl().setRollbackOnly();
        }

        protected boolean canBeginTransaction_impl(Object status) {
            return false;
        }

        protected boolean canCommitTransaction_impl(Object status) {
            return false;
        }

        protected boolean canRollbackTransaction_impl(Object status) {
            return false;
        }

        protected boolean canIssueSQLToDatabase_impl(Object status) {
            return status == TransactionStatus.ACTIVE || status == TransactionStatus.PREPARING;
        }

        protected boolean canMergeUnitOfWork_impl(Object status) {
            return status == TransactionStatus.COMMITTED;
        }

        protected String statusToString_impl(Object status) {
            return status == null ? "No scope is active" : status.toString();
        }
    }
}

